/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PropertyValueUntagger
extends VisitorSupport {
    private static final String REFOBJ_VIA_SHORTCUT = "refobjViaShortcut";
    private static final String REFOBJ = "refobj";
    final String m_propertyValue;
    Element m_propertyValueElem;
    boolean m_bTagged = false;
    StringBuffer m_untaggedValueBuffer;

    public PropertyValueUntagger(String propertyValue) {
        this.m_propertyValue = propertyValue;
        if (this.m_propertyValue == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("mfwModel.Expression.init(): null expression received");
        } else if (this.m_propertyValue.startsWith("<") || this.m_propertyValue.startsWith("&")) {
            try {
                this.m_untaggedValueBuffer = new StringBuffer();
                SAXReader saxReader = new SAXReader();
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                StringReader stringReader = new StringReader(this.m_propertyValue);
                Document fileDoc = saxReader.read((Reader)stringReader);
                this.m_propertyValueElem = fileDoc.getRootElement();
                this.m_propertyValueElem.accept((Visitor)this);
                this.m_bTagged = true;
            }
            catch (DocumentException e) {
                MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("com.cognos.metadataService.mfwModel.Expression.untag(): Document Exception when trying to parse expression: \"" + this.m_propertyValue + "\"", e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public String getUntaggedValue() {
        return this.m_bTagged ? new String(this.m_untaggedValueBuffer) : this.m_propertyValue;
    }

    public void visit(Element node) {
        if (node.getParent() == this.m_propertyValueElem) {
            if (node.getName().equals(REFOBJ_VIA_SHORTCUT)) {
                List refobjElems = node.elements(REFOBJ);
                String viaShortcutRef = null;
                String targetObjectRef = null;
                for (int refobjElemsIdx = 0; refobjElemsIdx < refobjElems.size(); ++refobjElemsIdx) {
                    LineageObjectId idHelper;
                    String refobjValue = ((Element)refobjElems.get(refobjElemsIdx)).getText();
                    if (refobjElemsIdx == 0) {
                        viaShortcutRef = refobjValue;
                        continue;
                    }
                    if (refobjElemsIdx != 1 || (idHelper = new LineageObjectId(viaShortcutRef, targetObjectRef = refobjValue)).getValue() == null) continue;
                    this.m_untaggedValueBuffer.append(idHelper.getValue());
                }
            } else {
                this.m_untaggedValueBuffer.append(node.getText());
            }
        }
    }

    public void visit(Text node) {
        if (node.getParent() == this.m_propertyValueElem) {
            this.m_untaggedValueBuffer.append(node.getText());
        }
    }

    public void visit(Entity node) {
        if (node.getParent() == this.m_propertyValueElem) {
            this.m_untaggedValueBuffer.append(node.getText());
        }
    }
}

