/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.metadataService.sources.mfw.ParameterItem;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.reportservice.RequestInvoker;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class RequestContextBuilder {
    private MFWRequestContext m_mfwRequestContext;

    public RequestContextBuilder(String passport, String productLocale, String contentLocale, Element parametersElem, RequestInvoker requestInvoker, BIBusEnvelope request) {
        this.m_mfwRequestContext = MFWRequestContext.create((String)productLocale, (String)contentLocale, (String)passport);
        this.m_mfwRequestContext.setAdvancedIDResolution(true);
        this.m_mfwRequestContext.setRequestInvoker(requestInvoker);
        this.m_mfwRequestContext.setBiBusEnvelope(request);
        if (parametersElem != null) {
            Element mfwParameters = RequestContextBuilder.convertToDAMBusProperties(parametersElem);
            this.m_mfwRequestContext.setPromptResolution(mfwParameters);
            Element connection = RequestContextBuilder.buildConnectionDOM(mfwParameters);
            this.m_mfwRequestContext.setConnectionSpec(connection);
        }
    }

    public MFWRequestContext getRequestContext() {
        return this.m_mfwRequestContext;
    }

    static Element buildConnectionDOM(Element parameters) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("connection");
        RequestContextBuilder.populateConnectionDOM(root, parameters);
        return root;
    }

    static void populateConnectionDOM(Element rootConnection, Element parameters) {
        List<ParameterItem> params = RequestContextBuilder.getCredentialParameterItems(parameters);
        for (int i = 0; i < params.size(); ++i) {
            ParameterItem item = params.get(i);
            Element domSubConnection = rootConnection.addElement("connection");
            Element domQFProviderType = domSubConnection.addElement("QFProviderType");
            domQFProviderType.addAttribute("value", "Database");
            Element domDataSource = domSubConnection.addElement("dataSource");
            domDataSource.addAttribute("value", item.m_dataSourceName);
            if (item.m_connectionString != null) {
                Element domConnectionString = domSubConnection.addElement("connectionString");
                domConnectionString.addAttribute("value", item.m_connectionString);
            }
            if (item.m_userName != null) {
                Element domUserName = domSubConnection.addElement("username");
                domUserName.addAttribute("value", item.m_userName);
            }
            if (item.m_password != null) {
                Element password = domSubConnection.addElement("password");
                password.addAttribute("value", item.m_password);
            }
            if (item.m_cubePassword != null) {
                Element cubePassword = domSubConnection.addElement("cubePassword");
                cubePassword.addAttribute("value", item.m_cubePassword);
                cubePassword.addAttribute("encrypted", item.m_cubePasswordEncrypted);
            }
            if (item.m_connectionSearchPath != null) {
                Element domSearchPath = domSubConnection.addElement("searchPath");
                domSearchPath.addAttribute("value", item.m_connectionSearchPath);
            }
            if (item.m_signonSearchPath != null) {
                Element domSignon = domSubConnection.addElement("signon");
                Element domSignonSearchPath = domSignon.addElement("searchPath");
                domSignonSearchPath.addAttribute("value", item.m_signonSearchPath);
            }
            if (item.m_SAPLogonTicket != null) {
                Element domSAPLogonTicket = domSubConnection.addElement("SAPLogonTicket");
                domSAPLogonTicket.addAttribute("value", item.m_SAPLogonTicket);
            }
            if (item.m_namespace == null) continue;
            Element domNamespace = domSubConnection.addElement("namespace");
            domNamespace.addAttribute("value", item.m_namespace);
        }
    }

    static List<ParameterItem> getCredentialParameterItems(Element parameters) {
        List items = parameters.selectNodes("parameterValues");
        LinkedList<ParameterItem> ret = new LinkedList<ParameterItem>();
        CAMFactory factory = new CAMFactory();
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            ParameterItem pi = new ParameterItem(item, factory);
            ret.add(pi);
        }
        return ret;
    }

    private static Element convertToDAMBusProperties(Element parameterValues) {
        Document document = DocumentHelper.createDocument();
        Element parameters = document.addElement("bus:parameters");
        RequestContextBuilder.convertElementToBiBus(parameterValues, parameters);
        return parameters;
    }

    private static void convertElementToBiBus(Element originalChild, Element newChild) {
        List childAtts = originalChild.attributes();
        for (int attIdx = 0; attIdx < childAtts.size(); ++attIdx) {
            Attribute att = (Attribute)childAtts.get(attIdx);
            RequestContextBuilder.convertAttributeToBiBus(att, newChild);
        }
        String text = originalChild.getText();
        newChild.setText(text);
        List nss = originalChild.declaredNamespaces();
        for (int nIdx = 0; nIdx < nss.size(); ++nIdx) {
            Namespace ns = (Namespace)nss.get(nIdx);
            if (ns.getPrefix().toLowerCase().startsWith("ns")) {
                newChild.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
                continue;
            }
            newChild.addNamespace(ns.getPrefix(), ns.getURI());
        }
        List elements = originalChild.elements();
        for (int i = 0; i < elements.size(); ++i) {
            Element child = (Element)elements.get(i);
            Element newC = newChild.addElement(child.getQualifiedName());
            RequestContextBuilder.convertElementToBiBus(child, newC);
        }
    }

    static void convertAttributeToBiBus(Attribute att, Element element) {
        String attValueLower;
        String namespace = att.getQName().getNamespacePrefix();
        String attName = att.getQName().getName();
        String value = att.getValue();
        if ("xmlns".equalsIgnoreCase(namespace)) {
            if (attName.toLowerCase().startsWith("ns")) {
                element.addAttribute(new QName("xmlns:bus"), "http://developer.cognos.com/schemas/bibus/3/");
                return;
            }
        } else if ("xsi".equalsIgnoreCase(namespace)) {
            if ("type".equalsIgnoreCase(attName) && value != null) {
                attValueLower = value.toLowerCase();
                if (attValueLower.length() > 4 && attValueLower.startsWith("ns")) {
                    boolean foundCol = false;
                    int colIdx = 2;
                    for (colIdx = 2; colIdx < attValueLower.length(); ++colIdx) {
                        if (attValueLower.charAt(colIdx) != ':') continue;
                        foundCol = true;
                        break;
                    }
                    if (foundCol && colIdx + 1 < attValueLower.length()) {
                        String subStr = value.substring(colIdx + 1);
                        element.addAttribute(new QName("xsi:type"), "bus:" + subStr);
                        return;
                    }
                } else if (attValueLower.startsWith("xsd:")) {
                    String subStr = value.substring(4);
                    element.addAttribute(new QName("xsi:type"), "xs:" + subStr);
                    return;
                }
            }
        } else if ("soapenc".equalsIgnoreCase(namespace) && "arrayType".equalsIgnoreCase(attName) && (attValueLower = value.toLowerCase()).length() > 4 && attValueLower.startsWith("ns") && attValueLower.charAt(3) == ':') {
            String subStr = value.substring(4);
            element.addAttribute(new QName("soapenc:arrayType"), "bus:" + subStr);
            return;
        }
        Attribute newAtt = (Attribute)att.clone();
        element.add(newAtt);
    }
}

