/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.dispatcherJSP.api.DispatcherJSPDriver;
import com.cognos.dispatcherJSP.api.IApplication;
import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.exceptions.InterfaceFault;
import com.cognos.metadataService.ui.exceptions.InternalFault;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.metadataService.ui.jsp.UIJSPApplication;
import com.cognos.metadataService.ui.log.LogControl;
import com.cognos.metadataService.ui.log.UIPerfMarker;
import com.cognos.metadataService.ui.request.UIRequestParams;
import com.cognos.metadataService.util.misc.LocalizedStrings;
import com.cognos.metadataService.util.misc.MDSRVLocaleUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import java.net.URL;

public class UIHandler
extends BasicHandler {
    private String m_sInternalDispatcher;
    private String m_host;
    private String m_basePath;
    private int m_port;
    private DispatcherJSPDriver m_alpDriver;
    private UIJSPApplication m_jpfApplication;
    private Configuration m_initialConfiguration;

    public UIHandler() {
        super(null);
    }

    public ICCLConfiguration getConfiguration() {
        return this.m_initialConfiguration.getICCLConfiguration();
    }

    public Configuration getPdkConfiguration() {
        return this.m_initialConfiguration;
    }

    public String getInternalDispatcher() {
        return this.m_sInternalDispatcher;
    }

    public void start() {
        super.start();
        try {
            LogControl.GetInstance().uiHandlerStarted();
            if (this.m_jpfApplication == null) {
                this.m_jpfApplication = this.createApplicationInstance();
            }
            if (this.m_alpDriver == null) {
                this.m_alpDriver = DispatcherJSPDriver.getNewDispatcherDriver((IApplication)this.m_jpfApplication, (String)this.m_host, (int)this.m_port, (String)this.m_basePath, (String)"Dispatcher", (String)"p2pd");
            }
        }
        catch (Throwable th) {
            CCLRuntimeException cclRuntime = new CCLRuntimeException(th, "starting CPMS application");
            LogControl.GetInstance().runtimeError((Exception)cclRuntime, null);
            throw cclRuntime;
        }
    }

    public void dispose() {
        LogControl.GetInstance().uiHandlerDisposed();
        if (this.m_alpDriver != null) {
            this.m_alpDriver.dispose();
            this.m_alpDriver = null;
        }
    }

    private UIJSPApplication createApplicationInstance() {
        ICCLConfiguration icclConfig = this.m_initialConfiguration.getICCLConfiguration();
        return new UIJSPApplication(icclConfig, this.m_initialConfiguration.getValue("serverLocale"), this.m_basePath, this);
    }

    public void configure(Configuration configuration) {
        try {
            this.m_sInternalDispatcher = configuration.getICCLConfiguration().getValue("internalDispatcher", true);
            this.m_initialConfiguration = configuration;
            this.m_basePath = configuration.getICCLConfiguration().resolveEffectivePath("../webapps/p2pd");
            int port = 9300;
            String host = null;
            URL dispatcherURL = null;
            dispatcherURL = new URL(this.m_sInternalDispatcher);
            host = dispatcherURL.getHost();
            if (host == null) {
                host = "localhost";
            }
            if ((port = dispatcherURL.getPort()) < 0) {
                port = 9300;
            }
            this.m_host = host;
            this.m_port = port;
        }
        catch (Exception e) {
            CCLRuntimeException cclRuntime = new CCLRuntimeException((Throwable)e, e.getMessage());
            LogControl.GetInstance().runtimeError((Exception)cclRuntime, null);
        }
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    public void invokeImpl(MessageContext context) {
        UIPerfMarker marker = new UIPerfMarker("UIHandler.invokeImpl");
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)context.getProperty("request.envelope");
        BIBusEnvelope response = null;
        LogControl.GetInstance().startRequestUIHandler(requestEnvelope);
        context.setResponseName("response");
        try {
            response = (BIBusEnvelope)requestEnvelope.clone();
            context.setProperty("response.envelope", (Object)response);
        }
        catch (Exception e) {
            response = new BIBusEnvelope();
            context.setProperty("response.envelope", (Object)response);
        }
        try {
            MessageHelperImpl messageHelper = new MessageHelperImpl(MDSRVLocaleUtils.getLocale(context));
            UIRequestParams requestParams = new UIRequestParams(requestEnvelope, messageHelper, this.m_initialConfiguration);
            if ("meta-only".equals(requestParams.getFragDirective())) {
                requestEnvelope.setFormField("pid", "emptyfragment_pid");
                this.m_alpDriver.service(context);
                marker.endPerf("UIHandler.invokeImpl successfully completed");
                return;
            }
            if (requestParams.getPid() != null) {
                this.remapPidIfRequired(context, requestParams);
                try {
                    this.m_alpDriver.service(context);
                }
                catch (Exception t) {
                    String exc = MDSRVLocaleUtils.getUnknownErrorException(context);
                    RuntimeException cclRuntime = new RuntimeException(exc, t);
                    LogControl.GetInstance().runtimeError(cclRuntime, requestEnvelope);
                    InternalFault inF = new InternalFault(exc, t);
                    context.setFault((Fault)inF);
                }
                catch (Throwable t) {
                    CCLRuntimeException cr = new CCLRuntimeException(t, t.getMessage());
                    LogControl.GetInstance().runtimeError((Exception)cr, requestEnvelope);
                    String exc = MDSRVLocaleUtils.getUnknownErrorException(context);
                    InternalFault inF = new InternalFault(exc, (Exception)cr);
                    context.setFault((Fault)inF);
                }
            } else {
                RuntimeException cr = new RuntimeException("PID Expected for metadata ui service request");
                LogControl.GetInstance().runtimeError(cr, requestEnvelope);
                InterfaceFault fault = new InterfaceFault("PID Expected for metadata ui request", null);
                context.setFault((Fault)fault);
            }
        }
        catch (UIException ue) {
            String errorMsg = ue.getMessage();
            RuntimeException rt = new RuntimeException(errorMsg, ue);
            LogControl.GetInstance().runtimeError(rt, requestEnvelope);
            InternalFault inF = new InternalFault(errorMsg, rt);
            context.setFault((Fault)inF);
        }
        catch (Throwable th) {
            RuntimeException cr = new RuntimeException(th);
            LogControl.GetInstance().runtimeError(cr, requestEnvelope);
            InternalFault inF = new InternalFault(MDSRVLocaleUtils.getUnknownErrorException(context), cr);
            context.setFault((Fault)inF);
        }
        if (context.getFault() != null) {
            marker.endPerf("UIHandler.invokeImpl successfully completed");
        } else {
            marker.endPerf("UIHandler.invokeImpl faulted");
        }
        LogControl.GetInstance().endRequestUIHandler(response);
    }

    private void remapPidIfRequired(MessageContext context, UIRequestParams params) {
        String iis = params.getIIS();
        if (iis != null && !params.getLaunchPoint().equals("indirect")) {
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)context.getProperty("request.envelope");
            requestEnvelope.setFormField("pid", "iis_pid");
        }
    }

    private class MessageHelperImpl
    implements MessageHelper {
        private String m_locale;

        public MessageHelperImpl(String locale) {
            this.m_locale = locale;
        }

        @Override
        public String getMessage(String code) {
            LocalizedStrings localizedStrings = new LocalizedStrings(this.m_locale);
            String errorMsg = localizedStrings.getLocalizedValue(code);
            return errorMsg;
        }

        @Override
        public String getMessage(String code, String param) {
            LocalizedStrings localizedStrings = new LocalizedStrings(this.m_locale);
            Object[] arguments = new Object[]{param};
            return localizedStrings.getLocalizedValue(code, arguments);
        }
    }
}

