/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp;

import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.dispatcherJSP.api.IApplication;
import com.cognos.dispatcherJSP.api.IPageManager;
import com.cognos.dispatcherJSP.exceptions.DynamicException;
import com.cognos.dispatcherJSP.util.SystemUtil;
import com.cognos.metadataService.ui.UIHandler;
import com.cognos.metadataService.ui.exceptions.InternalFault;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.misc.MDSRVLocaleUtils;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UIJSPApplication
implements IApplication {
    private static final String PAGEMAP_FILE_NM = "masterPageMap.xml";
    private static final String PAGEMAP_PARENTFOLDER_NM = "mdsrv";
    private String m_pageMapPath;
    private UIHandler m_producer;

    public UIJSPApplication(ICCLConfiguration config, String serverLocale, String pageMapPath, UIHandler producer) {
        this.m_pageMapPath = pageMapPath + SystemUtil.FILE_SEPARATOR + "WEB-INF" + SystemUtil.FILE_SEPARATOR + PAGEMAP_PARENTFOLDER_NM + SystemUtil.FILE_SEPARATOR + "pagemap" + SystemUtil.FILE_SEPARATOR + PAGEMAP_FILE_NM;
        this.m_producer = producer;
    }

    public void initialize(IPageManager pageManager) throws CCLException {
    }

    public boolean isInitialized() {
        return false;
    }

    public String getPageMapPath() {
        return this.m_pageMapPath;
    }

    public void startRequest(HttpServletRequest request) {
        request.setAttribute("producer", (Object)this.m_producer);
    }

    public boolean processRequest(HttpServletRequest request, HttpServletResponse response) throws CCLException {
        return true;
    }

    public void endRequest(HttpServletRequest request) {
    }

    public int prepareForErrorPage(String originalPID, Throwable throwable, HttpServletRequest request, HttpServletResponse response) {
        String errorPid = request.getParameter("error_pid");
        if (errorPid != null && errorPid.length() > 0) {
            request.setAttribute("exception", (Object)throwable);
            return 1;
        }
        MessageContext context = (MessageContext)request.getAttribute("bibus.context");
        String errorMsg = throwable instanceof MDSRVException ? MDSRVLocaleUtils.getErrorMessage(throwable, context) : MDSRVLocaleUtils.getUnknownErrorException(context);
        Throwable dynamicException = null;
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (cause instanceof UIException) {
                errorMsg = cause.getMessage();
                throwable = cause;
                break;
            }
            if (!(cause instanceof DynamicException)) continue;
            dynamicException = throwable;
            break;
        }
        if (response.isCommitted()) {
            try {
                response.getWriter().write(errorMsg);
                return 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dynamicException != null) {
            try {
                this.dumpDynamicErrorPage(response, dynamicException);
                return 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        InternalFault inF = new InternalFault(errorMsg, new RuntimeException(errorMsg, throwable));
        context.setFault((Fault)inF);
        return 2;
    }

    public String getErrorPageID(HttpServletRequest request) throws CCLRuntimeException {
        String errorPid = request.getParameter("error_pid");
        if (errorPid != null && errorPid.length() > 0) {
            return errorPid;
        }
        return "error_pid";
    }

    public void close() {
    }

    private void dumpDynamicErrorPage(HttpServletResponse response, Throwable th) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("A dynamic compilation exception was encountered. Please ensure you have undertaken the following");
        writer.write("steps to enable dynamic compilation:");
        writer.write("<ol>");
        writer.write("<li>Replaced the tools.jar in tomcat\\common\\lib with a JDk1.5 tools.jar</li>");
        writer.write("<li>Deleted the jar file containing any precompiled JSP's, [compiledJSP.jar]</li>");
        writer.write("<li>Placed the dynamicJSP.jar in the webapps\\p2pd\\web-inf\\lib directory. This jar file can be obtained by running workflow -e compile, or from the mdsrv dev tar ball</li>");
        writer.write("<li>Placed the dispatcherJSP.properties in webapps\\p2pd\\web-inf\\classes and edited the property");
        writer.write("<i>dispatcherJSP.dev.jspc.source_root_dir.1</i>to point at the root directory of your where your");
        writer.write("jsp files are located. The value should be a fully qualifed path with slashes doubly escaped c:\\blah\\blah\\myjsps");
        writer.write("</li>");
        writer.write("<li>Ensure you have mapped the pid for your jsp in the pagemap file, and its value is a path relative to the");
        writer.write(" value of <i>dispatcherJSP.dev.jspc.source_root_dir.1</i>");
        writer.write("</ol>");
        writer.write("<br>");
        writer.write("Details:");
        writer.write("<br>");
        while (th != null) {
            writer.write(th.toString());
            StackTraceElement[] st = th.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                writer.write(st[i].toString());
                writer.write("<br>");
            }
            th = th.getCause();
            writer.write("<br>");
            writer.write("<br>");
        }
    }
}

