/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.base;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.ui.UIHandler;
import com.cognos.metadataService.ui.util.EncodingUtility;
import com.cognos.metadataService.util.misc.LocalizedStrings;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.CROneCookie;
import com.ibm.cognos.i18n.util.Bidi;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public class BaseHelper {
    protected MessageContext m_context;
    protected UIHandler m_producer;
    protected HttpServletRequest m_request;
    private Exception mSoapFault;
    private LocalizedStrings m_localizedStrings;
    private BIBusEnvelope m_BIBusRequestEnvelope;
    private String m_contentLocale = "en";
    private String m_productLocale = "en";

    public Exception getFault() {
        return this.mSoapFault;
    }

    public void setFault(Exception soapFault) {
        this.mSoapFault = soapFault;
    }

    BiBusHeader getHeaderFromEnvelope() {
        BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.getEnvelope());
        return header;
    }

    public boolean isFaulted() {
        return this.mSoapFault != null;
    }

    public void setRequest(HttpServletRequest request) {
        this.m_context = (MessageContext)request.getAttribute("bibus.context");
        this.m_producer = (UIHandler)((Object)request.getAttribute("producer"));
        this.m_request = request;
        this.m_BIBusRequestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
        CMQuery cmQuery = new CMQuery((Element)this.m_BIBusRequestEnvelope.getBIBusHeader().clone(), this.getRequestCookie());
        this.m_contentLocale = cmQuery.getContentLocale();
        this.m_productLocale = cmQuery.getProductLocale();
    }

    public CROneCookie getRequestCookie() {
        String cookieString = this.m_BIBusRequestEnvelope.getCookieValue("CRN");
        return cookieString == null ? null : new CROneCookie(cookieString);
    }

    public String getWebContent() {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
        String webContent = requestEnvelope.getEnvironmentValue("WEB_CONTENT_ROOT");
        return webContent;
    }

    public String getGateway() {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
        String gateway = requestEnvelope.getEnvironmentValue("SCRIPT_NAME");
        if (gateway == null || gateway.length() == 0) {
            try {
                gateway = this.m_producer.getConfiguration().getValue("gateway", true);
            }
            catch (CCLConfigurationException ccf) {
                throw new RuntimeException(ccf.getMessage(), ccf);
            }
        }
        return gateway;
    }

    public String getContentLocale() {
        return this.m_contentLocale;
    }

    public String getProductLocale() {
        return this.m_productLocale;
    }

    public boolean isLocaleBiDi() {
        String locale = this.getContentLocale();
        return Bidi.isLocaleRTL((String)locale);
    }

    public String getInternalDispatcher() {
        return this.m_producer.getInternalDispatcher();
    }

    protected MessageContext getContext() {
        return (MessageContext)this.m_request.getAttribute("bibus.context");
    }

    protected BIBusEnvelope getEnvelope() {
        return (BIBusEnvelope)this.getContext().getProperty("request.envelope");
    }

    public String getPassport() {
        return this.getEnvelope().getPassportID();
    }

    public String getMessage(String key) {
        if (this.m_localizedStrings == null) {
            this.m_localizedStrings = new LocalizedStrings(this.getProductLocale());
        }
        return this.m_localizedStrings.getLocalizedValue(key);
    }

    public String getMessageWithParams(String key, String ... params) {
        if (this.m_localizedStrings == null) {
            this.m_localizedStrings = new LocalizedStrings(this.getProductLocale());
        }
        return this.m_localizedStrings.getLocalizedValue(key, params);
    }

    public String getHtmlEscapedMessage(String key) {
        if (this.m_localizedStrings == null) {
            this.m_localizedStrings = new LocalizedStrings(this.getProductLocale());
        }
        String res = this.m_localizedStrings.getLocalizedValue(key);
        return EncodingUtility.htmlencode(res);
    }

    public String getHtmlEscapedParameterizedMessage(String key, String param1) {
        if (this.m_localizedStrings == null) {
            this.m_localizedStrings = new LocalizedStrings(this.getProductLocale());
        }
        Object[] params = new Object[]{param1};
        return this.m_localizedStrings.getLocalizedValue(key, params);
    }

    public boolean requiresPassportRefreshing() {
        return false;
    }
}

