/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.base;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.MetadataService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.metadataService.ui.jsp.LookAheadObjectInputStream;
import com.cognos.metadataService.ui.jsp.base.BaseHelper;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class BaseRequestHelper
extends BaseHelper {
    private String mResponse = null;
    protected String mResponseTwoLevels = null;

    public String getResponse() {
        return this.mResponse;
    }

    public String getResponseTwoLevels() {
        return this.mResponseTwoLevels;
    }

    @Override
    public String getMessage(String key) {
        return key;
    }

    public String decodeResultString(String strResult) {
        strResult = strResult.replaceAll("&gt;", ">");
        strResult = strResult.replaceAll("&lt;", "<");
        strResult = strResult.replaceAll("&quot;", "\"");
        return strResult;
    }

    public String encodeString(String strResult) {
        strResult = strResult.replaceAll(">", "&gt;");
        strResult = strResult.replaceAll("<", "&lt;");
        strResult = strResult.replaceAll("\"", "&quot;");
        return strResult;
    }

    public String doConversation(String seralizedHeaderFieldName, String actionFiledName) {
        try {
            String str = this.m_request.getParameter(seralizedHeaderFieldName);
            String sContext = str != null ? str.toString() : "";
            boolean alreadyInConversation = !"".equals(sContext) && sContext != null;
            MetadataService_PortType port = this.getMetadataServicePort();
            ParameterValue[] paramValues = new ParameterValue[]{};
            Option[] options = this.getOptions();
            boolean cancelRequested = "cancel".equals(this.m_request.getParameter(actionFiledName));
            AsynchReply reply = null;
            if (!cancelRequested && (sContext.equals("") || sContext.equals("null"))) {
                MetadataServiceLineageSpecification requestSpec = this.buildRequestBody();
                if (requestSpec != null) {
                    BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.getEnvelope());
                    ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                    reply = port.runSpecification((AsynchSpecification)requestSpec, paramValues, options);
                }
            } else if (alreadyInConversation) {
                byte[] decodedValue = base64.decode((int)0, (String)sContext);
                ByteArrayInputStream inStream = new ByteArrayInputStream(decodedValue);
                LookAheadObjectInputStream laoistream = new LookAheadObjectInputStream(inStream);
                BiBusHeader header = (BiBusHeader)laoistream.readObject();
                Stub stub = (Stub)port;
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            }
            boolean cancelled = false;
            if (reply == null || AsynchReplyStatusEnum.working == reply.getStatus() || AsynchReplyStatusEnum.stillWorking == reply.getStatus()) {
                if (cancelRequested) {
                    if (alreadyInConversation) {
                        AsynchRequest primary = reply != null ? reply.getPrimaryRequest() : null;
                        port.cancel(primary);
                    }
                    cancelled = true;
                } else {
                    SOAPHeaderElement responseHeader = ((Stub)port).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                    if (responseHeader != null) {
                        ((Stub)port).clearHeaders();
                        BiBusHeader bibus = (BiBusHeader)responseHeader.getObjectValue(BiBusHeader.class);
                        ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
                    }
                    AsynchRequest primary = reply != null ? reply.getPrimaryRequest() : null;
                    reply = port.wait(primary, paramValues, options);
                }
            }
            if (reply != null && AsynchReplyStatusEnum.working != reply.getStatus() && AsynchReplyStatusEnum.stillWorking != reply.getStatus()) {
                AsynchDetail[] details = reply.getDetails();
                InputStream ds = this.getResultStream(port, details[0]);
                this.mResponse = this.setResponse(ds);
            } else if (!cancelled) {
                Stub stub = (Stub)port;
                SOAPHeaderElement header = stub.getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                BiBusHeader bibus = (BiBusHeader)header.getObjectValue(BiBusHeader.class);
                ByteArrayOutputStream outArray = new ByteArrayOutputStream();
                ObjectOutputStream outStream = new ObjectOutputStream(outArray);
                outStream.writeObject(bibus);
                outStream.close();
                return base64.encode((int)0, (byte[])outArray.toByteArray());
            }
        }
        catch (RemoteException e) {
            this.handleMultipleConnectionsFault(e, this.m_context);
            super.setFault(e);
            return null;
        }
        catch (Exception e) {
            super.setFault(e);
            return null;
        }
        return null;
    }

    public abstract MetadataServiceLineageSpecification buildRequestBody();

    protected void handleMultipleConnectionsFault(RemoteException e, MessageContext context) {
    }

    protected String setResponse(InputStream strResponse) throws DocumentException {
        String strResult = null;
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            document = reader.read(strResponse);
        }
        catch (SAXException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        strResult = document.asXML();
        Element elmResponse = (Element)document.selectSingleNode("//metadata");
        if (elmResponse != null) {
            strResult = elmResponse.asXML();
        }
        return strResult;
    }

    private Option[] getOptions() {
        AsynchOptionEncoding encoding = new AsynchOptionEncoding();
        encoding.setName(AsynchOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIMECompressed);
        AsynchOptionInt primaryWaitThreshold = new AsynchOptionInt();
        primaryWaitThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWaitThreshold.setValue(2);
        Option[] options = new Option[]{encoding, primaryWaitThreshold};
        return options;
    }

    private MetadataService_PortType getMetadataServicePort() throws MalformedURLException, ServiceException {
        MetadataService_ServiceLocator serviceLocator = new MetadataService_ServiceLocator();
        MetadataService_PortType port = null;
        String dispatcherURL = this.getInternalDispatcher();
        port = serviceLocator.getmetadataService(new URL(dispatcherURL));
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    private InputStream getResultStream(MetadataService_PortType port, AsynchDetail detail) {
        try {
            Object[] attachments = ((Stub)port).getAttachments();
            if (attachments.length > 0) {
                AttachmentPart attach = (AttachmentPart)attachments[0];
                InputStream is = attach.getDataHandler().getInputStream();
                String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
                if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                    return new GZIPInputStream(is);
                }
                return is;
            }
            String result = new String(((AsynchDetailMIMEAttachment)detail).getData(), "UTF8");
            return new ByteArrayInputStream(result.getBytes("UTF8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
    }
}

