/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans;

import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class BusinessViewHelper {
    private LineageResponse m_lineageResponse;
    private Element m_rootElement;
    private List<Element> m_packageElements = new ArrayList<Element>();
    private Vector m_items;

    public BusinessViewHelper(Element lineageResponse, MessageHelper responseHelper) {
        this.m_lineageResponse = new LineageResponse(lineageResponse, responseHelper);
        this.initialize();
    }

    private void initialize() {
        this.m_items = new Vector();
        Iterator queryResults = this.m_lineageResponse.getQueryResults();
        boolean firstTime = true;
        while (queryResults.hasNext()) {
            Element result = (Element)queryResults.next();
            if (firstTime) {
                this.m_rootElement = this.m_lineageResponse.getRoot();
            }
            firstTime = false;
            this.m_items.addElement(result);
        }
        this.m_packageElements = this.m_lineageResponse.getPackages();
    }

    public List<Element> getPackages() {
        return this.m_packageElements;
    }

    public String getPackageName(Element packageElement) {
        return LineageResponse.getName(packageElement);
    }

    public String getPackageDescription(Element packageElement) {
        String descr = LineageResponse.getPropertyValue(packageElement, "description");
        if (descr == null) {
            return "";
        }
        return descr;
    }

    public boolean isRootReport() {
        return "baseReport".equals(LineageResponse.getType(this.m_rootElement));
    }

    public String getRootTitle() {
        return LineageResponse.getName(this.m_rootElement);
    }

    public String getRootContact() {
        String contact = LineageResponse.getPropertyValue(this.m_rootElement, "contact");
        if (contact == null && (contact = LineageResponse.getPropertyValue(this.m_rootElement, "contactEMail")) == null) {
            return "";
        }
        return contact;
    }

    public String getRootDescription() {
        String descr = LineageResponse.getPropertyValue(this.m_rootElement, "description");
        if (descr == null) {
            return "";
        }
        return descr;
    }

    public String getRootOwner() {
        String owner = LineageResponse.getPropertyValue(this.m_rootElement, "owner");
        if (owner == null) {
            return "";
        }
        return owner;
    }

    public String getPath(Element elem) {
        ArrayList<String> l = new ArrayList<String>();
        Element p = elem;
        StringBuffer b = new StringBuffer();
        while (p != null) {
            l.add(this.getName(p));
            p = this.m_lineageResponse.getParentRef(p);
        }
        for (int i = l.size() - 1; i >= 0; --i) {
            String t = (String)l.get(i);
            b.append(t);
            if (i - 1 < 0) continue;
            b.append(" > ");
        }
        return b.toString();
    }

    public String getIconImageName(Element elem) {
        String type = LineageResponse.getType(elem);
        String image = "unknown.gif";
        if ("querySubject".equals(type) || "query".equals(type)) {
            image = "query_subject.gif";
        } else if ("level".equals(type)) {
            image = "level.gif";
        } else if ("dataSource".equals(type)) {
            image = "data_source.gif";
        } else if ("queryItem".equals(type) || "dataItem".equals(type)) {
            image = "attribute.gif";
        } else if ("measure".equals(type)) {
            image = "measure.gif";
        } else if ("dimension".equals(type)) {
            image = "dimension.gif";
        } else if ("calculation".equals(type)) {
            String sCalcType = LineageResponse.getPropertyValue(elem, "calcType");
            image = sCalcType != null && sCalcType.equals("namedSet") ? "named_set.gif" : "calculation.gif";
        } else if ("hierarchy".equals(type)) {
            image = "hierarchy.gif";
        }
        return image;
    }

    public Iterator getItems() {
        return this.m_items.iterator();
    }

    public Iterator getPackageItemsForItem(Element item) {
        Element lineageObject = null;
        String sObjType = LineageResponse.getType(item);
        if (sObjType.equals("reportItem")) {
            Element objRef = null;
            Iterator refObjs = this.m_lineageResponse.getTransformationSources(item);
            if (refObjs.hasNext() && this.isObjectReferenceToFMObject(objRef = (Element)refObjs.next())) {
                lineageObject = objRef;
            }
        } else {
            lineageObject = item;
        }
        Vector<Element> vec = new Vector<Element>();
        if (lineageObject != null) {
            String expression;
            Element objRef;
            this.getPackageItemsForItemImpl(lineageObject, vec);
            String sTransType = LineageResponse.getTransformationType(lineageObject);
            if ("objectReference".equals(sTransType) && vec.size() > 1 && (objRef = this.m_lineageResponse.getLineageObject(expression = LineageResponse.getPropertyValue(lineageObject, "expression"))) != null) {
                vec.clear();
                vec.add(objRef);
            }
        }
        return vec.iterator();
    }

    public Iterator getDataSourcesForItem(Element elem) {
        HashSet dataSources = new HashSet();
        HashSet encountered = new HashSet();
        this.getDataSourcesForItem(elem, dataSources, encountered);
        return dataSources.iterator();
    }

    public boolean isObjectReferenceToFMObject(Element lineageObject) {
        Iterator ts;
        if ("objectReference".equals(LineageResponse.getTransformationType(lineageObject))) {
            Iterator ts2 = this.m_lineageResponse.getTransformationSources(lineageObject);
            if (ts2.hasNext()) {
                return this.isFMObject((Element)ts2.next());
            }
        } else if ("transformation".equals(LineageResponse.getTransformationType(lineageObject)) && (ts = this.m_lineageResponse.getTransformationSources(lineageObject)).hasNext()) {
            return this.isFMObject((Element)ts.next());
        }
        return false;
    }

    public boolean isObjectReferencesFMObjects(Element lineageObject) {
        Iterator ts = this.m_lineageResponse.getTransformationSources(lineageObject);
        while (ts.hasNext()) {
            if (!this.isFMObject((Element)ts.next())) continue;
            return true;
        }
        return false;
    }

    public String getName(Element elem) {
        return LineageResponse.getName(elem);
    }

    public String getExpression(Element elem) {
        String expr = LineageResponse.getPropertyValue(elem, "expression");
        if (expr == null) {
            return expr;
        }
        return expr;
    }

    public String getLastUpdated(Element dataSource) {
        String lastUpdated = LineageResponse.getPropertyValue(dataSource, "lastUpdated");
        return lastUpdated;
    }

    public String getDescription(Element elem) {
        HashSet set = new HashSet();
        return this.getDescription(elem, set);
    }

    private String getDescription(Element lineageObj, HashSet encountered) {
        Iterator it;
        String descr = LineageResponse.getPropertyValue(lineageObj, "description");
        if (descr != null) {
            return descr;
        }
        if (encountered.contains(lineageObj)) {
            return "";
        }
        encountered.add(lineageObj);
        String tType = LineageResponse.getTransformationType(lineageObj);
        if ("objectReference".equals(tType) && (it = this.m_lineageResponse.getTransformationSources(lineageObj)).hasNext()) {
            return this.getDescription((Element)it.next(), encountered);
        }
        return "";
    }

    private void getPackageItemsForItemImpl(Element elem, Vector vecResults) {
        Iterator transSources = this.m_lineageResponse.getTransformationSources(elem);
        while (transSources.hasNext()) {
            Element refObj = (Element)transSources.next();
            if (!this.isFMObject(refObj)) continue;
            vecResults.addElement(refObj);
        }
    }

    private boolean isFMObject(Element obj) {
        Element parentRef = this.m_lineageResponse.getParentRef(obj);
        while (parentRef != null) {
            Element parent = this.m_lineageResponse.getParentRef(parentRef);
            if ("package".equals(LineageResponse.getType(parentRef))) {
                return true;
            }
            if (parent == null) break;
            parentRef = parent;
        }
        return false;
    }

    private void getDataSourcesForItem(Element obj, HashSet dataSources, HashSet encountered) {
        block5: {
            String type = LineageResponse.getType(obj);
            if (type != null && "dataSource".equals(type)) {
                dataSources.add(obj);
            }
            if (encountered.contains(obj)) break block5;
            encountered.add(obj);
            Iterator transSources = this.m_lineageResponse.getTransformationSources(obj);
            if (!transSources.hasNext()) {
                Iterator children = this.m_lineageResponse.getChildRefs(obj);
                while (children.hasNext()) {
                    Element child = (Element)children.next();
                    this.getDataSourcesForItem(child, dataSources, encountered);
                }
            } else {
                while (transSources.hasNext()) {
                    Element dep = (Element)transSources.next();
                    this.getDataSourcesForItem(dep, dataSources, encountered);
                }
            }
        }
    }
}

