/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans;

import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.Transformation;
import com.cognos.metadataService.command.lineage.api.client.TransformationSource;
import com.cognos.metadataService.command.lineage.api.mdsrv.TransformationTypeEnum;
import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Element;

public class BusinessViewHelper2 {
    private LineageResponseHelper m_lineageResponse;
    private Vector m_items;
    MessageHelper m_Helper;

    public BusinessViewHelper2(Element responseRootElem, MessageHelper responseHelper) {
        this.m_Helper = responseHelper;
        this.m_lineageResponse = new LineageResponseHelper();
        this.m_lineageResponse.buildFromInstanceElem(responseRootElem);
        this.initialize();
    }

    public LineageResponseHelper getResponseHelper() {
        return this.m_lineageResponse;
    }

    private void initialize() {
        this.m_items = new Vector();
        for (QueryResult query : this.m_lineageResponse.getQueryResults()) {
            LineageObject objQuery = this.m_lineageResponse.getObject(query.getObjectRef());
            if (objQuery == null) {
                throw new UIException(this.m_Helper.getMessage("MSR_UI_ui_unexpected_lineageResponse"));
            }
            this.m_items.addElement(objQuery);
        }
    }

    public String getPackageName() {
        return this.m_lineageResponse.getPackage().getName();
    }

    public String getPackageDescription() {
        String descr = this.m_lineageResponse.getPackage().getPropertyValue("description");
        if (descr == null) {
            return "";
        }
        return descr;
    }

    public boolean isRootReport() {
        return this.m_lineageResponse.getRoot().getType().equals("baseReport");
    }

    public String getRootTitle() {
        return this.m_lineageResponse.getRoot().getName();
    }

    public String getRootContact() {
        String contact = this.m_lineageResponse.getRoot().getPropertyValue("contact");
        if (contact == null && (contact = this.m_lineageResponse.getRoot().getPropertyValue("contactEMail")) == null) {
            return "";
        }
        return contact;
    }

    public String getRootDescription() {
        String descr = this.m_lineageResponse.getRoot().getPropertyValue("description");
        if (descr == null) {
            return "";
        }
        return descr;
    }

    public String getRootOwner() {
        String owner = this.m_lineageResponse.getRoot().getPropertyValue("owner");
        if (owner == null) {
            return "";
        }
        return owner;
    }

    public String getPath(LineageObject elem) {
        ArrayList<String> l = new ArrayList<String>();
        LineageObject p = elem;
        StringBuffer b = new StringBuffer();
        while (p != null) {
            l.add(p.getName());
            p = this.m_lineageResponse.getObject(p.getParentRef());
        }
        for (int i = l.size() - 1; i >= 0; --i) {
            String t = (String)l.get(i);
            b.append(t);
            if (i - 1 < 0) continue;
            b.append(" > ");
        }
        return b.toString();
    }

    public String getIconImageName(LineageObject elem) {
        String type = elem.getType();
        String image = "unknown.gif";
        if ("querySubject".equals(type) || "query".equals(type)) {
            image = "query_subject.gif";
        } else if ("level".equals(type)) {
            image = "level.gif";
        } else if ("dataSource".equals(type)) {
            image = "data_source.gif";
        } else if ("queryItem".equals(type) || "dataItem".equals(type)) {
            image = "attribute.gif";
        } else if ("measure".equals(type)) {
            image = "measure.gif";
        } else if ("dimension".equals(type)) {
            image = "dimension.gif";
        } else if ("calculation".equals(type)) {
            String sCalcType = elem.getPropertyValue("calcType");
            image = sCalcType != null && sCalcType.equals("namedSet") ? "named_set.gif" : "calculation.gif";
        } else if ("hierarchy".equals(type)) {
            image = "hierarchy.gif";
        }
        return image;
    }

    public Iterator getItems() {
        return this.m_items.iterator();
    }

    public boolean isObjectReferenceToFMObject(LineageObject lineageObject) {
        Collection transSourses;
        Iterator ts;
        TransformationTypeEnum trType;
        Transformation tr = lineageObject.getTransformation();
        TransformationTypeEnum transformationTypeEnum = trType = tr != null ? lineageObject.getTransformation().getType() : null;
        if (trType != null && trType.getStringValue().equals(TransformationTypeEnum.ObjectReference.getStringValue()) && (ts = (transSourses = lineageObject.getTransformation().getTransformationSourceList()).iterator()).hasNext()) {
            return this.isFMObject((LineageObject)ts.next());
        }
        return false;
    }

    public String getExpression(LineageObject elem) {
        String expr = elem.getTransformation().getPropertyValue("expression");
        if (expr == null) {
            return expr;
        }
        return expr;
    }

    public String getLastUpdated(LineageObject dataSource) {
        String lastUpdated = dataSource.getPropertyValue("lastUpdated");
        return lastUpdated;
    }

    private void getPackageItemsForItemImpl(LineageObject elem, Vector results) {
        Collection transSourses = elem.getTransformation().getTransformationSourceList();
        for (TransformationSource objTransSource : transSourses) {
            LineageObject lo = this.m_lineageResponse.getObject(objTransSource.getObjectRef());
            if (!this.isFMObject(lo)) continue;
            results.addElement(lo);
        }
    }

    public LineageObject getParentObject(LineageObject lineageObject) {
        if (lineageObject.getParentRef() != null) {
            String parentID = lineageObject.getParentRef();
            return this.m_lineageResponse.getObject(parentID);
        }
        return null;
    }

    private boolean isFMObject(LineageObject obj) {
        LineageObject parentObj2;
        LineageObject parentObj = this.getParentObject(obj);
        while (parentObj != null && (parentObj2 = this.getParentObject(parentObj)) != null) {
            if ("package".equals(parentObj2.getType())) {
                return true;
            }
            parentObj = parentObj2;
        }
        return false;
    }
}

