/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans;

import com.cognos.metadataService.ui.jsp.beans.LineageBean;
import com.cognos.metadataService.ui.request.LineageUIParams;
import com.cognos.metadataService.ui.request.UIQueryItem;
import com.cognos.metadataService.ui.request.UIRequestParams;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceReferenceValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Vector;

public class IISRequestBean
extends LineageBean {
    private boolean m_debug = false;

    public String getIISURL() {
        UIRequestParams uiParms = this.getRequestParams();
        LineageUIParams lineageParams = uiParms.getLineageUIParams();
        return this.getIISURL(lineageParams, uiParms.getIIS());
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    String getIISURL(LineageUIParams lineageParams, String iis) {
        StringBuffer finalURL = new StringBuffer();
        boolean namespaces = true;
        if (iis.endsWith("?noNamespaceAndDebugIISURL")) {
            namespaces = false;
            this.m_debug = true;
            finalURL.append(iis.substring(0, iis.lastIndexOf("?noNamespaceAndDebugIISURL")));
        } else if (iis.endsWith("?noNamespace")) {
            namespaces = false;
            finalURL.append(iis.substring(0, iis.lastIndexOf("?noNamespace")));
        } else if (iis.endsWith("?debugIISURL")) {
            this.m_debug = true;
            finalURL.append(iis.substring(0, iis.lastIndexOf("?debugIISURL")));
        } else {
            finalURL.append(iis);
        }
        if (!finalURL.toString().endsWith("?")) {
            finalURL.append("?");
        }
        finalURL.append("autoLoadTarget=mainFrame&autoLoadURL=");
        try {
            StringBuffer lineageURL = new StringBuffer();
            this.addLineageURLParameter("runLineage.do?objectType", this.getObjectType(lineageParams), lineageURL);
            this.addLineageURLParameter("&objectName", this.getObjectName(lineageParams), lineageURL);
            if (namespaces) {
                this.addLineageURLParameter("&objectNS", this.getObjectNS(lineageParams), lineageURL);
            }
            if (lineageParams.getModelType() == 1) {
                this.populateIISParamsForReport(lineageParams, lineageURL);
            } else {
                this.populateIISParamsForPackage(lineageParams, namespaces, lineageURL);
            }
            lineageURL.append("&autoRun=true");
            finalURL.append(URLEncoder.encode(lineageURL.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException us) {
            throw new RuntimeException(us.getMessage(), us);
        }
        return finalURL.toString();
    }

    private void addLineageURLParameter(String key, String value, StringBuffer buffer) throws UnsupportedEncodingException {
        buffer.append(key);
        buffer.append("=");
        buffer.append(value);
    }

    private void populateIISParamsForReport(LineageUIParams lineageParams, StringBuffer finalURL) throws UnsupportedEncodingException {
        Vector items = lineageParams.getQueryItems();
        if (items.size() > 0) {
            UIQueryItem item = (UIQueryItem)items.get(0);
            this.addLineageURLParameter("&collectionName", item.getQuery(), finalURL);
            this.addLineageURLParameter("&memberName", item.getQueryItem(), finalURL);
        }
    }

    private String eliminateMUN(String objectId) {
        V5UniqueNamePieceReferenceValue identifier = new V5UniqueNamePieceReferenceValue(objectId);
        IV5UniqueNamePiece metadata = identifier.metadataPiece();
        return metadata.referenceValue();
    }

    private void populateIISParamsForPackage(LineageUIParams lineageParams, boolean namespaces, StringBuffer finalURL) throws UnsupportedEncodingException {
        Vector items = lineageParams.getQueryItems();
        if (items.size() > 0) {
            UIQueryItem item = (UIQueryItem)items.get(0);
            ArrayList list = new ArrayList();
            String objectId = item.getObjectID();
            objectId = this.eliminateMUN(objectId);
            MFWCrnIDHelper.parseID((String)objectId, list);
            if (list.size() > 1) {
                this.addLineageURLParameter("&collectionName", list.get(1).toString(), finalURL);
                if (namespaces) {
                    this.addLineageURLParameter("&collectionNS", list.get(0).toString(), finalURL);
                }
                if (list.size() > 2) {
                    this.addLineageURLParameter("&memberName", list.get(list.size() - 1).toString(), finalURL);
                }
                if (namespaces && list.size() > 3) {
                    StringBuffer pId = new StringBuffer();
                    for (int i = 0; i < list.size() - 1; ++i) {
                        if (i != 0) {
                            pId.append(".");
                        }
                        pId.append("[");
                        pId.append(list.get(i).toString());
                        pId.append("]");
                    }
                    this.addLineageURLParameter("&memberNS", pId.toString(), finalURL);
                }
            }
        }
    }

    private String getObjectType(LineageUIParams linParams) {
        if (linParams.getModelType() == 0) {
            return "olap";
        }
        return "report";
    }

    private String getObjectName(LineageUIParams linParms) {
        String path = this.getObjectNS(linParms);
        String name = null;
        if (linParms.getModelType() == 0) {
            int nameIdx = path.indexOf("package[@name='");
            int endIdx = path.indexOf("']", nameIdx);
            name = path.substring(nameIdx + "package[@name='".length(), endIdx);
        } else {
            int nameIdx = path.lastIndexOf("[@name='");
            int endIdx = path.indexOf("']", nameIdx);
            name = path.substring(nameIdx + "[@name='".length(), endIdx);
        }
        return name;
    }

    private String getObjectNS(LineageUIParams linParms) {
        String pkgPath;
        if (linParms.getModelType() == 0 && (pkgPath = linParms.getPackagePath()) != null && pkgPath.length() > 0) {
            return pkgPath;
        }
        return linParms.getReportPath();
    }
}

