/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans;

import com.cognos.caf.CAFValidator;
import com.cognos.caf.common.CAFException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.MetadataService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.lineage.api.client.LineageRequest;
import com.cognos.metadataService.command.lineage.api.client.RequestQuery;
import com.cognos.metadataService.ui.jsp.LookAheadObjectInputStream;
import com.cognos.metadataService.ui.jsp.beans.LineageBean;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponse;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponseHelper;
import com.cognos.metadataService.ui.log.LogControl;
import com.cognos.metadataService.ui.request.LineageUIParams;
import com.cognos.metadataService.ui.request.UIQueryItem;
import com.cognos.metadataService.ui.util.DOMUtil;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class LineageRequestBean
extends LineageBean {
    private Element m_elemLineageResponse;
    private Exception m_soapFault;
    private LineageRequest m_lineageRequest;
    private LineageResponseHelper m_reportLineageResponse;

    public String getRawLineageRequest() {
        DocumentFactory fac = new DocumentFactory();
        Element requestRootElem = fac.createElement("request");
        this.m_lineageRequest.dumpToParentElem(requestRootElem);
        return ((Element)requestRootElem.selectSingleNode("lineageRequest")).asXML();
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        this.buildLineageRequestFromParameters();
    }

    public boolean isDataRetrieved() {
        return this.m_elemLineageResponse != null;
    }

    public boolean isQFException() {
        if (this.isFaulted() && this.m_soapFault instanceof AxisFault) {
            AxisFault axisFault = (AxisFault)this.m_soapFault;
            SOAPFault fault = new SOAPFault(axisFault);
            try {
                Element dom4jFault = DOMUtil.toDOM4J(fault.getAsDOM());
                Element error = (Element)dom4jFault.selectSingleNode("//errorCode");
                if (error != null && error.getTextTrim().startsWith("QE-DEF")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isFaulted() {
        return this.m_soapFault != null;
    }

    public boolean isReportRequest() {
        LineageUIParams linRequest = this.m_requestParams.getLineageUIParams();
        return linRequest.getReportPath() != null && !"".equals(linRequest.getReportPath());
    }

    public String getSpecification() {
        try {
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType port = null;
            port = serviceLocator.getcontentManagerService(new URL(this.m_producer.getInternalDispatcher()));
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
            BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)requestEnvelope);
            ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            LineageUIParams linRequest = this.m_requestParams.getLineageUIParams();
            SearchPathMultipleObject sp = new SearchPathMultipleObject();
            sp.set_value(linRequest.getReportPath());
            PropEnum[] properties = new PropEnum[]{PropEnum.type, PropEnum.ancestors};
            BaseClass[] res = port.query(sp, properties, null, null);
            String reportPath = null;
            if (res != null) {
                for (int i = 0; i < res.length; ++i) {
                    BaseClass bc = res[i];
                    bc.getDefaultName();
                    if (bc instanceof Output) {
                        reportPath = LineageRequestBean.fetchReportPath(bc.getAncestors());
                        continue;
                    }
                    if (bc instanceof ReportVersion) {
                        reportPath = LineageRequestBean.fetchReportPath(bc.getAncestors());
                        continue;
                    }
                    if (!(bc instanceof Report)) continue;
                    reportPath = linRequest.getReportPath();
                }
            }
            PropEnum[] specProperties = new PropEnum[]{PropEnum.specification};
            SearchPathMultipleObject spec = new SearchPathMultipleObject();
            spec.set_value(reportPath);
            BaseClass[] specRes = port.query(spec, specProperties, null, null);
            String specStr = null;
            for (int i = 0; i < specRes.length; ++i) {
                if (!(specRes[i] instanceof Report)) continue;
                specStr = ((Report)specRes[i]).getSpecification().getValue();
                break;
            }
            return specStr;
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    static String fetchReportPath(AncestorInfoArrayProp ancestors) {
        AncestorInfo[] info = ancestors.getValue();
        for (int i = 0; i < info.length; ++i) {
            AncestorInfo inf = info[i];
            if (!inf.getObjectClass().equals((Object)ClassEnum.fromString((String)"report"))) continue;
            return inf.getSearchPath();
        }
        return null;
    }

    public void commitFault() {
        if (this.isFaulted()) {
            if (this.m_soapFault instanceof AxisFault) {
                AxisFault axisFault = (AxisFault)this.m_soapFault;
                SOAPFault fault = new SOAPFault(axisFault);
                try {
                    BIBusEnvelope responseEnvelope = (BIBusEnvelope)this.m_context.getProperty("response.envelope");
                    ArrayList al = axisFault.getHeaders();
                    for (int i = 0; i < al.size(); ++i) {
                        Attribute att;
                        Object obj = al.get(i);
                        if (!(obj instanceof SOAPHeaderElement)) continue;
                        String xml = obj.toString();
                        Element header = DOMUtil.parse(xml);
                        responseEnvelope.setBIBusHeader(header);
                        Element cam = responseEnvelope.getCAM();
                        Element exc = cam.element("exception");
                        if (exc == null || (att = exc.attribute("nil")) == null || !"true".equals(att.getValue())) continue;
                        cam.remove(exc);
                    }
                    Element dom4jFault = DOMUtil.toDOM4J(fault.getAsDOM());
                    dom4jFault.detach();
                    Element responseBody = responseEnvelope.getBody();
                    responseBody.add(dom4jFault);
                    Fault f = new Fault(axisFault.getMessage(), (SOAPEnvelope)responseEnvelope);
                    this.m_context.setFault(f);
                }
                catch (Exception e) {
                    Fault f = new Fault(axisFault.getMessage());
                    f.addDetail(axisFault.dumpToString());
                    this.m_context.setFault(f);
                }
            } else {
                Fault f = new Fault(this.m_soapFault.getMessage(), this.m_soapFault);
                this.m_context.setFault(f);
            }
        }
    }

    public String getFaultDetails() {
        if (this.m_soapFault != null) {
            return this.m_soapFault.toString();
        }
        return null;
    }

    public String getModelPath() {
        String sModelPath = "";
        if (this.m_requestParams.getLineageUIParams() != null) {
            String sPath = this.m_requestParams.getLineageUIParams().getPackagePath();
            if (sPath == null || sPath.length() == 0) {
                sPath = this.m_requestParams.getLineageUIParams().getReportPath();
            }
            if (sPath != null) {
                sModelPath = sPath.replace('\"', '\'');
            }
        }
        return sModelPath;
    }

    public String getPID() {
        return this.m_requestParams.getPid();
    }

    public String getFragmentDirective() {
        return this.m_requestParams.getFragDirective();
    }

    public String getQueryItem() {
        Vector items;
        if (this.m_requestParams.getLineageUIParams() != null && (items = this.m_requestParams.getLineageUIParams().getQueryItems()).size() > 0) {
            return items.elementAt(0).toString();
        }
        return "";
    }

    public String getRequestGateway() {
        return this.m_requestParams.getGateway();
    }

    public String getExtensionURL() {
        return this.m_requestParams.getIIS() != null ? this.m_requestParams.getIIS() : "";
    }

    public String getExtensionLaunchPoint() {
        return this.m_requestParams.getLaunchPoint();
    }

    public String getMetadataInformationURI() {
        ICCLConfiguration cclConfiguration = this.m_producer.getConfiguration();
        try {
            return cclConfiguration.getValue("metadataInformationURI", true);
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public String getRawLineageResponse() {
        if (this.m_elemLineageResponse != null) {
            String value = this.m_elemLineageResponse.asXML();
            value = value.replaceAll(">", "&gt;");
            value = value.replaceAll("<", "&lt;");
            return value;
        }
        return "";
    }

    public LineageResponseHelper getMergedLineageResponse() {
        LineageResponseHelper mergedLineageResponse = new LineageResponseHelper();
        if (this.isUsingReportLineage()) {
            if (this.m_reportLineageResponse == null) {
                this.m_reportLineageResponse = new LineageResponseHelper();
                this.m_reportLineageResponse.buildFromInstanceElem(this.getReportLineageResponseElem());
            }
            LineageResponseHelper modelLineageResponse = new LineageResponseHelper();
            modelLineageResponse.buildFromInstanceElem(this.getLineageResponseElem());
            mergedLineageResponse.addQueryResults(this.m_reportLineageResponse);
            mergedLineageResponse.addObjects(this.m_reportLineageResponse);
            mergedLineageResponse.addObjects(modelLineageResponse);
            this.m_reportLineageResponse.dumpToParentElem(null);
        } else {
            mergedLineageResponse.buildFromInstanceElem(this.getLineageResponseElem());
        }
        return mergedLineageResponse;
    }

    public Element getMergedLineageResponseElem() {
        if (this.isUsingReportLineage()) {
            LineageResponseHelper mergedLineageResponse = this.getMergedLineageResponse();
            Element elemMergedLineageResponse = mergedLineageResponse.dumpToParentElem(null);
            return elemMergedLineageResponse;
        }
        return this.getLineageResponseElem();
    }

    public Element getLineageResponseElem() {
        return this.m_elemLineageResponse;
    }

    public String decodeExecutionParameters() {
        String executionParams = this.m_requestParams.getExecutionParams();
        String result = null;
        if (executionParams != null && executionParams.startsWith("CAFS")) {
            try {
                String unsigned = CAFValidator.unwrapSignature((String)executionParams, null);
                result = CCLWeb64.decodeAndDecompress((String)unsigned);
            }
            catch (CAFException e) {
                result = null;
            }
        } else {
            result = executionParams;
        }
        return result;
    }

    public String getExecutionParametersString() {
        String sExecParams = this.decodeExecutionParameters();
        sExecParams = sExecParams.replace('\"', '\'');
        sExecParams = sExecParams.replace('\n', ' ');
        return sExecParams;
    }

    private Element getExecutionParameters() {
        String params = this.decodeExecutionParameters();
        if (params != null && !"".equals(params)) {
            try {
                return DOMUtil.parse(params);
            }
            catch (Throwable e) {
                try {
                    String straight64 = CCLWeb64.decodeAndDecompress((String)params);
                    return DOMUtil.parse(straight64);
                }
                catch (Throwable e2) {
                    LogControl.GetInstance().unexpectedHandledException("Failed to parse execution paramters", e);
                }
            }
        }
        return null;
    }

    private SimpleParmValueItem buildSimpleParmValueItem(Element item) {
        Node inlcusiveNode;
        Node useNode;
        SimpleParmValueItem vi = new SimpleParmValueItem();
        Node displayNode = item.selectSingleNode("./bus:display");
        if (displayNode != null) {
            String display = displayNode.getText();
            vi.setDisplay(display);
        }
        if ((useNode = item.selectSingleNode("./bus:use")) != null) {
            String use = useNode.getText();
            vi.setUse(use);
        }
        if ((inlcusiveNode = item.selectSingleNode("./bus:inclusive")) != null) {
            String inclusive = inlcusiveNode.getText();
            vi.setInclusive("true".equals(inclusive));
        }
        return vi;
    }

    private HierarchicalParmValueItem buildHierarchialParmValueItem(Element item) {
        HierarchicalParmValueItem hi = new HierarchicalParmValueItem();
        Element value = (Element)item.selectSingleNode("./*[local-name()='value' and @xsi:type='bus:simpleParmValueItem']");
        if (value != null) {
            hi.setValue(this.buildSimpleParmValueItem(value));
        }
        Element subNodes = (Element)item.selectSingleNode("subNodes");
        LinkedList<HierarchicalParmValueItem> subNodesList = new LinkedList<HierarchicalParmValueItem>();
        if (subNodes != null) {
            List items = subNodes.selectNodes("./*[local-name()='item' and @xsi:type='bus:hierarchicalParmValueItem']/");
            for (int itemIdx = 0; itemIdx < items.size(); ++itemIdx) {
                Element hiElement = (Element)items.get(itemIdx);
                subNodesList.add(this.buildHierarchialParmValueItem(hiElement));
            }
        }
        HierarchicalParmValueItem[] subNodesArray = new HierarchicalParmValueItem[subNodesList.size()];
        for (int i = 0; i < subNodesList.size(); ++i) {
            subNodesArray[i] = (HierarchicalParmValueItem)subNodesList.get(i);
        }
        hi.setSubNodes(subNodesArray);
        return hi;
    }

    private ParameterValue[] getParamterValues() {
        Element busParameters = this.getExecutionParameters();
        if (busParameters == null) {
            return new ParameterValue[0];
        }
        List items = busParameters.selectNodes("item");
        LinkedList<ParameterValue> parameterValues = new LinkedList<ParameterValue>();
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            String type = item.attributeValue("type");
            if (!"bus:parameterValue".equals(type)) continue;
            ParameterValue pv = new ParameterValue();
            Element name = (Element)item.selectSingleNode("./bus:name");
            pv.setName(name.getText());
            List values = item.selectNodes("./bus:value");
            LinkedList<SimpleParmValueItem> paramValues = new LinkedList<SimpleParmValueItem>();
            for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                Element spv;
                SimpleParmValueItem endVal;
                SimpleParmValueItem vi;
                Element value = (Element)values.get(valueIdx);
                Element busItem = (Element)value.selectSingleNode("item");
                if (busItem == null) continue;
                String valueType = busItem.attributeValue("type");
                if ("bus:simpleParmValueItem".equals(valueType)) {
                    vi = this.buildSimpleParmValueItem(busItem);
                    paramValues.add(vi);
                    continue;
                }
                if ("bus:boundRangeParmValueItem".equals(valueType)) {
                    vi = new BoundRangeParmValueItem();
                    Element endItem = (Element)busItem.selectSingleNode("./*[local-name()='end' and @xsi:type='bus:simpleParmValueItem']");
                    endVal = this.buildSimpleParmValueItem(endItem);
                    Element startItem = (Element)busItem.selectSingleNode("./*[local-name()='start' and @xsi:type='bus:simpleParmValueItem']");
                    SimpleParmValueItem startVal = this.buildSimpleParmValueItem(startItem);
                    vi.setStart(startVal);
                    vi.setEnd(endVal);
                    paramValues.add(vi);
                    continue;
                }
                if ("bus:hierarchicalParmValueItem".equals(valueType)) {
                    vi = this.buildHierarchialParmValueItem(busItem);
                    paramValues.add(vi);
                    continue;
                }
                if ("bus:unbounded\u00adEnd\u00adRange\u00adParm\u00adValue\u00adItem".equals(valueType)) {
                    vi = new UnboundedEndRangeParmValueItem();
                    spv = (Element)busItem.selectSingleNode("./*[local-name()='start' and @xsi:type='bus:simpleParmValueItem']");
                    if (spv != null) {
                        SimpleParmValueItem startVal = this.buildSimpleParmValueItem(spv);
                        vi.setStart(startVal);
                    }
                    paramValues.add(vi);
                    continue;
                }
                if (!"bus:unboundedStartRangeParmValueItem".equals(valueType)) continue;
                vi = new UnboundedStartRangeParmValueItem();
                spv = (Element)busItem.selectSingleNode("./*[local-name()='end' and @xsi:type='bus:simpleParmValueItem']");
                if (spv != null) {
                    endVal = this.buildSimpleParmValueItem(spv);
                    vi.setEnd(endVal);
                }
                paramValues.add(vi);
            }
            ParmValueItem[] pValues = new ParmValueItem[paramValues.size()];
            for (int vIdx = 0; vIdx < paramValues.size(); ++vIdx) {
                pValues[vIdx] = (ParmValueItem)paramValues.get(vIdx);
            }
            pv.setValue(pValues);
            parameterValues.add(pv);
        }
        ParameterValue[] array = new ParameterValue[parameterValues.size()];
        for (int i = 0; i < parameterValues.size(); ++i) {
            array[i] = (ParameterValue)parameterValues.get(i);
        }
        return array;
    }

    public void buildLineageRequestFromParameters() {
        LineageUIParams linRequest = this.m_requestParams.getLineageUIParams();
        if (linRequest != null) {
            if (this.m_requestParams.getReportLineageElem() != null) {
                if (this.m_reportLineageResponse == null) {
                    this.m_reportLineageResponse = new LineageResponseHelper();
                    this.m_reportLineageResponse.buildFromInstanceElem(this.m_requestParams.getReportLineageElem());
                    boolean bError = false;
                    if (this.m_reportLineageResponse.getQueryResults().size() == 0) {
                        bError = true;
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("RSVP lineage response does NOT contain query results.");
                    }
                    if (this.m_reportLineageResponse.getObjects().size() == 0 || this.m_reportLineageResponse.getObjects().size() <= this.m_reportLineageResponse.getQueryResults().size()) {
                        bError = true;
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("RSVP lineage response does NOT contain report lineage objects.");
                    }
                    if (bError) {
                        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "lineageResponse");
                    }
                }
                this.m_lineageRequest = this.m_reportLineageResponse.getQueryLineageRequest();
                this.m_lineageRequest.setQuerySet(this.m_requestParams.getQuerySetXml());
                Element bError = this.m_lineageRequest.dumpToParentElem(null);
            } else {
                this.m_lineageRequest = new LineageRequest();
                if (linRequest.getModelType() == 0 || linRequest.getModelType() == 2) {
                    this.m_lineageRequest.addConnectionParam(PropEnum.searchPath.getValue(), linRequest.getPackagePath());
                } else if (this.m_requestParams.getQuerySetXml() != null) {
                    this.m_lineageRequest.setQuerySet(this.m_requestParams.getQuerySetXml());
                } else {
                    this.m_lineageRequest.addConnectionParam(PropEnum.searchPath.getValue(), linRequest.getReportPath());
                }
                Vector queryItems = linRequest.getQueryItems();
                for (int i = 0; i < queryItems.size(); ++i) {
                    UIQueryItem uq = (UIQueryItem)queryItems.elementAt(i);
                    RequestQuery oq = new RequestQuery();
                    oq.setId(String.valueOf(i + 1));
                    if (uq.getObjectID() != null) {
                        oq.addParam("modelItemRef", uq.getObjectID());
                    } else {
                        oq.addParam("queryName", uq.getQuery());
                        oq.addParam("dataItemName", uq.getQueryItem());
                    }
                    this.m_lineageRequest.addObjectQuery(oq);
                }
            }
        }
    }

    public String encodeParameter(String paramName, String paramValue) {
        if (("selectioncontext".equals(paramName) || "lineagerequest".equals(paramName) || "querySet".equals(paramName) || "reportLineage".equals(paramName) || "executionParams".equals(paramName)) && paramValue != null && !paramValue.startsWith("BASE64:") && !paramValue.startsWith("CAFS")) {
            try {
                String base64Str = base64.encode((int)0, (byte[])paramValue.getBytes("UTF8"));
                paramValue = "BASE64:" + base64Str;
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException(ue);
            }
        }
        return paramValue;
    }

    public String decodeParameterValue(String paramName, String paramValue) {
        String retValue = paramValue;
        if (("selectioncontext".equals(paramName) || "lineagerequest".equals(paramName) || "querySet".equals(paramName) || "reportLineage".equals(paramName)) && paramValue != null && paramValue.startsWith("BASE64:")) {
            String subStr = paramValue.substring(7);
            try {
                retValue = new String(base64.decode((int)0, (String)subStr), "UTF8");
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException(ue);
            }
        }
        return retValue;
    }

    public String doConversation(String convoField, String actionField) {
        MetadataService_PortType port = null;
        try {
            BiBusHeader bibus;
            Stub stub;
            String str = this.m_request.getParameter(convoField);
            String convo = str != null ? str.toString() : "";
            boolean hasConvo = !"".equals(convo) && convo != null;
            AsynchReply reply = null;
            port = this.getMetadataServicePort();
            ParameterValue[] paramValues = this.getParamterValues();
            Option[] options = this.getOptions();
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
            boolean cancelRequested = "cancel".equals(this.m_request.getParameter(actionField));
            if (!cancelRequested && (convo.equals("") || convo.equals("null"))) {
                MetadataServiceLineageSpecification requestSpec = this.buildLineageSpecification();
                BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)requestEnvelope);
                ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                LogControl.GetInstance().logMDSRVRunSpec(requestEnvelope, requestSpec, paramValues, options);
                reply = port.runSpecification((AsynchSpecification)requestSpec, paramValues, options);
                LogControl.GetInstance().logMDSRVRunSpecReply(requestEnvelope, requestSpec, paramValues, options, reply);
            } else if (hasConvo) {
                BiBusHeader header = this.reconstructBiBusHeader(requestEnvelope, convo);
                stub = (Stub)port;
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            }
            boolean cancelled = false;
            if (reply == null || AsynchReplyStatusEnum.working == reply.getStatus() || AsynchReplyStatusEnum.stillWorking == reply.getStatus()) {
                AsynchRequest primary;
                if (cancelRequested) {
                    if (hasConvo) {
                        primary = reply != null ? reply.getPrimaryRequest() : null;
                        LogControl.GetInstance().logMDSRVCancel(requestEnvelope);
                        port.cancel(primary);
                        LogControl.GetInstance().logMDSRVCancelEnd(requestEnvelope);
                    }
                    cancelled = true;
                } else {
                    primary = reply != null ? reply.getPrimaryRequest() : null;
                    LogControl.GetInstance().logMDSRVWait(requestEnvelope, primary, paramValues, options);
                    SOAPHeaderElement responseHeader = ((Stub)port).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                    if (responseHeader != null) {
                        ((Stub)port).clearHeaders();
                        bibus = (BiBusHeader)responseHeader.getObjectValue(BiBusHeader.class);
                        ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
                    }
                    reply = port.wait(primary, paramValues, options);
                    LogControl.GetInstance().logMDSRVWaitReply(requestEnvelope, primary, paramValues, options, reply);
                }
            }
            if (reply != null && AsynchReplyStatusEnum.working != reply.getStatus() && AsynchReplyStatusEnum.stillWorking != reply.getStatus()) {
                AsynchDetail[] details = reply.getDetails();
                InputStream ds = this.getResultStream(port, details[0]);
                SAXReader reader = new SAXReader();
                try {
                    reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    Document document = reader.read(ds);
                    this.setLineageResponse((Element)document.selectSingleNode("lineageResponse"));
                }
                catch (SAXException e) {
                    throw new CCLRuntimeException((Throwable)e, e.getMessage());
                }
                return null;
            }
            if (!cancelled) {
                stub = (Stub)port;
                SOAPHeaderElement header = stub.getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                bibus = (BiBusHeader)header.getObjectValue(BiBusHeader.class);
                return this.serializeTracking(bibus);
            }
        }
        catch (RemoteException e) {
            this.m_soapFault = e;
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private BiBusHeader reconstructBiBusHeader(BIBusEnvelope requestEnvelope, String convo) throws IOException, ClassNotFoundException {
        byte[] decodedValue = base64.decode((int)0, (String)convo);
        ByteArrayInputStream inStream = new ByteArrayInputStream(decodedValue);
        LookAheadObjectInputStream laoistream = new LookAheadObjectInputStream(inStream);
        Tracking tracking = (Tracking)laoistream.readObject();
        BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)requestEnvelope);
        header.setTracking(tracking);
        return header;
    }

    private String serializeTracking(BiBusHeader header) throws IOException {
        Tracking tracking = header.getTracking();
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outArray);
        outStream.writeObject(tracking);
        outStream.close();
        return base64.encode((int)0, (byte[])outArray.toByteArray());
    }

    private InputStream getResultStream(MetadataService_PortType port, AsynchDetail detail) {
        try {
            Object[] attachments = ((Stub)port).getAttachments();
            int x2 = 3;
            if (attachments.length > 0) {
                AttachmentPart attach = (AttachmentPart)attachments[0];
                InputStream is = attach.getDataHandler().getInputStream();
                String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
                if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                    return new GZIPInputStream(is);
                }
                return is;
            }
            String result = new String(((AsynchDetailMIMEAttachment)detail).getData(), "UTF8");
            return new ByteArrayInputStream(result.getBytes("UTF8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
    }

    private Option[] getOptions() {
        AsynchOptionEncoding encoding = new AsynchOptionEncoding();
        encoding.setName(AsynchOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIMECompressed);
        AsynchOptionInt primaryWaitThreshold = new AsynchOptionInt();
        primaryWaitThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWaitThreshold.setValue(2);
        Option[] options = new Option[]{encoding, primaryWaitThreshold};
        return options;
    }

    private MetadataService_PortType getMetadataServicePort() throws MalformedURLException, ServiceException {
        MetadataService_ServiceLocator serviceLocator = new MetadataService_ServiceLocator();
        MetadataService_PortType port = null;
        String dispatcherURL = this.m_producer.getInternalDispatcher();
        port = serviceLocator.getmetadataService(new URL(dispatcherURL));
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    private MetadataServiceLineageSpecification buildLineageSpecification() {
        MetadataServiceLineageSpecification requestSpec = new MetadataServiceLineageSpecification();
        DocumentFactory fac = new DocumentFactory();
        Element elem = fac.createElement("response");
        if (this.m_lineageRequest != null) {
            this.m_lineageRequest.dumpToParentElem(elem);
            Element root = (Element)elem.selectSingleNode("lineageRequest");
            String lineageSpec = root.asXML();
            requestSpec.setValue(new Specification(lineageSpec));
        }
        return requestSpec;
    }

    private void setLineageResponse(Element lineageResponse) {
        LineageUIParams linRequest = this.m_requestParams.getLineageUIParams();
        if (linRequest.getModelType() == 2) {
            String reportPath = linRequest.getReportPath();
            int idx = reportPath.indexOf("/report[@name='");
            String reportName = reportPath.substring(idx + 15, reportPath.indexOf("']", idx));
            LineageResponse response = new LineageResponse(lineageResponse, this);
            Element packageElm = response.getPackages().get(0);
            Element parentRef = packageElm.addElement("parentRef");
            parentRef.addText(reportPath);
            String owner = LineageResponse.getPropertyValue(packageElm, "owner");
            Element objElm = lineageResponse.addElement("object");
            objElm.addAttribute("id", reportPath);
            Element typeElm = objElm.addElement("type");
            typeElm.addText("baseReport");
            Element nameElm = objElm.addElement("name");
            nameElm.addText(reportName);
            Element childRefElm = objElm.addElement("childRef");
            childRefElm.addText(linRequest.getPackagePath());
            Element propertyElm = objElm.addElement("property");
            propertyElm.addText("report");
            propertyElm.addAttribute("name", "objectType");
            propertyElm.addAttribute("displayName", "Type");
            propertyElm.addAttribute("displayValue", "Report");
            Element propertyElm2 = objElm.addElement("property");
            propertyElm2.addText(owner);
            propertyElm2.addAttribute("name", "owner");
            propertyElm2.addAttribute("displayName", "Owner");
        }
        this.m_elemLineageResponse = lineageResponse;
    }

    public boolean isTechViewAvailable() {
        return this.canUserLaunchReportStudio();
    }

    private boolean canUserLaunchReportStudio() {
        ICCLConfiguration cclConfiguration = this.m_producer.getConfiguration();
        boolean canLaunch = false;
        try {
            LineageResponse response = new LineageResponse(this.m_elemLineageResponse, this);
            List<Element> elemPackages = response.getPackages();
            if (elemPackages.isEmpty()) {
                canLaunch = true;
            }
            for (Element elemPackage : elemPackages) {
                canLaunch = false;
                String pkgPath = LineageResponse.getPackagePath(elemPackage);
                BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.m_context.getProperty("request.envelope");
                String cmURL = cclConfiguration.getValue("sdk", true);
                ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
                ContentManagerService_PortType port = cmServiceLocator.getcontentManagerService(new URL(cmURL));
                BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)requestEnvelope);
                ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                PropEnum[] properties = new PropEnum[]{PropEnum.objectClass, PropEnum.effectiveUserCapabilities};
                BaseClass[] results = port.query(new SearchPathMultipleObject(pkgPath), properties, new Sort[0], new QueryOptions(EncodingEnum.MIME, null, null, null, null, false, null, null));
                UserCapabilityEnum[] requiredCapabilities = new UserCapabilityEnum[]{UserCapabilityEnum.canUseReportStudio, UserCapabilityEnum.canUseQueryStudio, UserCapabilityEnum.canUseAnalysisStudio};
                for (int i = 0; i < results.length; ++i) {
                    BaseClass obj = results[i];
                    UserCapabilityEnumArrayProp uceaProp = null;
                    if (obj.getObjectClass().getValue().equals((Object)ClassEnum.fromValue((String)Session.getTypeDesc().getXmlType().getLocalPart()))) {
                        uceaProp = ((Session)obj).getUserCapabilities();
                    } else if (obj.getObjectClass().getValue().equals((Object)ClassEnum.fromValue((String)_package.getTypeDesc().getXmlType().getLocalPart()))) {
                        uceaProp = ((_package)obj).getEffectiveUserCapabilities();
                    }
                    if (uceaProp == null) continue;
                    UserCapabilityEnum[] ucE = uceaProp.getValue();
                    for (int capIdx = 0; capIdx < ucE.length; ++capIdx) {
                        for (int reqCapIdx = 0; reqCapIdx < requiredCapabilities.length; ++reqCapIdx) {
                            if (!ucE[capIdx].equals((Object)requiredCapabilities[reqCapIdx])) continue;
                            canLaunch = true;
                        }
                    }
                }
                if (canLaunch) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        return canLaunch;
    }
}

