/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans.response;

import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.exceptions.UIException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;

public class LineageResponse {
    private List m_queryResults;
    private HashMap m_lineageObjects;
    private MessageHelper m_pageHelper;

    public LineageResponse(Element elem, MessageHelper pageHelper) {
        int i;
        this.m_pageHelper = pageHelper;
        List queryResults = elem.selectNodes("queryResult/objectRef");
        if (queryResults.size() == 0) {
            throw new UIException(pageHelper.getMessage("MSR_UI_ui_unexpected_lineageResponse"));
        }
        List objects = elem.selectNodes("object");
        this.m_lineageObjects = new HashMap();
        this.m_queryResults = new LinkedList();
        for (i = 0; i < objects.size(); ++i) {
            Element obj = (Element)objects.get(i);
            this.m_lineageObjects.put(obj.attributeValue("id"), obj);
        }
        for (i = 0; i < queryResults.size(); ++i) {
            Element objRef = (Element)queryResults.get(i);
            Element obj = this.getLineageObject(objRef.getText());
            this.m_queryResults.add(obj);
        }
    }

    public Element getRoot() {
        if (this.m_queryResults.size() > 0) {
            Element parent;
            Element parentRef = this.getParentRef((Element)this.m_queryResults.get(0));
            while (parentRef != null && (parent = this.getParentRef(parentRef)) != null) {
                parentRef = parent;
            }
            return parentRef;
        }
        return null;
    }

    public List<Element> getPackages() {
        ArrayList<Element> packageElements = new ArrayList<Element>();
        for (Element obj : this.m_lineageObjects.values()) {
            if (!"package".equals(LineageResponse.getType(obj))) continue;
            packageElements.add(obj);
        }
        return packageElements;
    }

    public Element getReport() {
        Element reportElement = null;
        for (Element obj : this.m_lineageObjects.values()) {
            if (!"baseReport".equals(LineageResponse.getType(obj))) continue;
            reportElement = obj;
            break;
        }
        return reportElement;
    }

    public void validateReportID() {
        String sReportID;
        Element elemReport = this.getReport();
        if (elemReport != null && (sReportID = elemReport.attributeValue("id")).equals("[Report]")) {
            Iterator childs = this.getChildRefs(elemReport);
            while (childs.hasNext()) {
                Element childObj = (Element)childs.next();
                Element parentRef = (Element)childObj.selectSingleNode("parentRef");
                if (parentRef == null) continue;
                String sParentID = parentRef.getText();
                parentRef.setText(sReportID);
            }
        }
    }

    public static String getPackagePath(Element packageLineageObj) {
        return packageLineageObj.attributeValue("id");
    }

    public Iterator getQueryResults() {
        return this.m_queryResults.iterator();
    }

    public Element getLineageObject(String id) {
        return (Element)this.m_lineageObjects.get(id);
    }

    public Element getParentRef(Element lineageObject) {
        if (lineageObject == null) {
            return null;
        }
        Element parentRef = (Element)lineageObject.selectSingleNode("parentRef");
        if (parentRef != null) {
            String parentID = parentRef.getText();
            return (Element)this.m_lineageObjects.get(parentID);
        }
        return null;
    }

    public Iterator getChildRefs(Element lineageObject) {
        List childRefs = lineageObject.selectNodes("childRef");
        LinkedList<Element> l = new LinkedList<Element>();
        for (int i = 0; i < childRefs.size(); ++i) {
            Element child = (Element)childRefs.get(i);
            Element lo = (Element)this.m_lineageObjects.get(child.getText());
            l.add(lo);
        }
        return l.iterator();
    }

    public static Iterator getProperties(Element lineageObject) {
        List c = lineageObject.selectNodes("property");
        return c.iterator();
    }

    public static String getType(Element lineageObject) {
        if (lineageObject == null) {
            return null;
        }
        Element type = (Element)lineageObject.selectSingleNode("type");
        if (type != null) {
            return type.getText();
        }
        return null;
    }

    public static String getPropertyValue(Element lineageObject, String propertyName) {
        Element prop;
        String sPropValue = null;
        if (lineageObject != null && (prop = (Element)lineageObject.selectSingleNode("property[@name='" + propertyName + "']")) != null) {
            sPropValue = prop.getText();
        }
        return sPropValue;
    }

    public static String getPropertyDisplayValue(Element lineageObject, String propertyName) {
        if (lineageObject == null) {
            return null;
        }
        Element prop = (Element)lineageObject.selectSingleNode("property[@name='" + propertyName + "']");
        if (prop != null) {
            return prop.attributeValue("displayValue");
        }
        return null;
    }

    public static String getPropertyDisplayName(Element lineageObject, String propertyName) {
        if (lineageObject == null) {
            return null;
        }
        Element prop = (Element)lineageObject.selectSingleNode("property[@name='" + propertyName + "']");
        if (prop != null) {
            return prop.attributeValue("displayName");
        }
        return null;
    }

    public static String getName(Element lineageObject) {
        Element type;
        String sName = null;
        if (lineageObject != null && (type = (Element)lineageObject.selectSingleNode("name")) != null) {
            sName = type.getText();
        }
        return sName;
    }

    public Iterator getTransformationSources(Element lineageObject) {
        List objRefs = lineageObject.selectNodes("transformation/objectRef");
        LinkedList<Element> ll = new LinkedList<Element>();
        for (int i = 0; i < objRefs.size(); ++i) {
            Element ref = (Element)objRefs.get(i);
            Element obj = (Element)this.m_lineageObjects.get(ref.getText());
            if (obj == null) continue;
            ll.add(obj);
        }
        return ll.iterator();
    }

    public static String getTransformationType(Element lineageObject) {
        if (lineageObject == null) {
            return null;
        }
        Element tType = (Element)lineageObject.selectSingleNode("transformation/type");
        if (tType != null) {
            return tType.getText();
        }
        return null;
    }

    public static String getTransformationExpression(Element lineageObject) {
        if (lineageObject == null) {
            return null;
        }
        Element tType = (Element)lineageObject.selectSingleNode("transformation/expression");
        if (tType != null) {
            return tType.getText();
        }
        return null;
    }
}

