/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans.response;

import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.LineageRequest;
import com.cognos.metadataService.command.lineage.api.client.LineageResponse;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.client.RequestQuery;
import com.cognos.metadataService.command.lineage.api.client.TransformationSource;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponseObject;
import com.cognos.metadataService.ui.jsp.beans.response.LineageResponseQuery;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class LineageResponseHelper
extends LineageResponse {
    private LineageResponseObject m_ReportObject;
    private LineageResponseObject m_PackageObject;

    @Override
    public void buildFromInstanceElem(Element responseRootElem) {
        List childElems = responseRootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element currentChildElem = (Element)childElemsIter.next();
            String elemName = currentChildElem.getName();
            if (elemName.equals("queryResult")) {
                LineageResponseQuery queryResult = new LineageResponseQuery();
                queryResult.buildFromInstanceElem(currentChildElem);
                this.addQueryResult(queryResult);
                continue;
            }
            if (!elemName.equals("object")) continue;
            LineageResponseObject lineageObject = new LineageResponseObject();
            lineageObject.buildFromInstanceElem(currentChildElem);
            this.addObject(lineageObject);
            if (lineageObject.getType().equals("baseReport")) {
                this.m_ReportObject = lineageObject;
                this.setReportPath(lineageObject.getId());
                continue;
            }
            if (!lineageObject.getType().equals("package")) continue;
            this.m_PackageObject = lineageObject;
            this.setPackagePath(lineageObject.getId());
        }
    }

    public LineageResponseObject getPackage() {
        return this.m_PackageObject;
    }

    public LineageResponseObject getReport() {
        return this.m_ReportObject;
    }

    public LineageResponseObject getRoot() {
        return this.m_ReportObject != null ? this.m_ReportObject : this.m_PackageObject;
    }

    public String toJavascript() {
        StringBuffer bufferJS = new StringBuffer(1024000);
        bufferJS.append("{");
        Collection<QueryResult> queryResults = this.getQueryResults();
        Iterator<QueryResult> queries = queryResults.iterator();
        int nQuery = 1;
        while (queries.hasNext()) {
            LineageResponseQuery lo = (LineageResponseQuery)queries.next();
            bufferJS.append(lo.toJavascript(nQuery++));
            bufferJS.append(",");
        }
        Iterator<LineageObject> objects = this.getObjects().values().iterator();
        int nObject = 1;
        while (objects.hasNext()) {
            LineageResponseObject lo = (LineageResponseObject)objects.next();
            bufferJS.append(lo.toJavascript(nObject++));
            if (!objects.hasNext()) continue;
            bufferJS.append(",");
        }
        bufferJS.append("}");
        return bufferJS.toString();
    }

    public void split(LineageResponseHelper response1, LineageResponseHelper response2) {
        response1.setReportPath(this.getReportPath());
        response2.setReportPath(this.getReportPath());
        response1.setPackagePath(this.getPackagePath());
        response2.setPackagePath(this.getPackagePath());
        response1.addQueryResults(this);
        for (LineageResponseObject lineageResponseObject : this.getObjects().values()) {
            String sType = lineageResponseObject.getType();
            if (sType.equals("baseReport") || sType.equals("dataItem") || sType.equals("dataItemRef")) {
                response1.addObject(lineageResponseObject);
                continue;
            }
            response2.addObject(lineageResponseObject);
        }
    }

    public void clear() {
        this.getQueryResults().clear();
        this.getObjects().clear();
    }

    public LineageResponseObject getReportObject() {
        LineageResponseObject objReport = null;
        for (LineageResponseObject lineageResponseObject : this.getObjects().values()) {
            String sType = lineageResponseObject.getType();
            if (!sType.equals("baseReport")) continue;
            objReport = lineageResponseObject;
            break;
        }
        return objReport;
    }

    public void validateReportID() {
        String sReportID;
        LineageResponseObject objReport = this.getReportObject();
        if (objReport != null && (sReportID = objReport.getId()).equals("[Report]")) {
            Collection coll = objReport.getChildRefs();
            for (String childRef : coll) {
                LineageObject objChild = this.getObject(childRef);
                String sParentID = objChild.getParentRef();
                objChild.setParentRef(sReportID);
            }
        }
    }

    public LineageRequest getQueryLineageRequest() {
        Collection<String> requestedObjectRefs = this.getRequestedObjectRefs();
        LineageRequest request = new LineageRequest();
        for (String sObjId : requestedObjectRefs) {
            LineageObject lineageObject = this.getObjects().get(sObjId);
            if (lineageObject != null) {
                if (lineageObject.getType().equals("dataItem")) {
                    RequestQuery objQuery = this.createDataItemRequestQuery(request, lineageObject);
                    request.addObjectQuery(objQuery);
                    continue;
                }
                if (!lineageObject.getType().equals("reportItem")) continue;
                for (TransformationSource trSource : lineageObject.getTransformation().getTransformationSourceList()) {
                    String sObjectRef = trSource.getObjectRef();
                    String[] nameParts = QuerySetIDHelper.parseNameParts(sObjectRef);
                    RequestQuery objQuery = this.createDataItemRequestQuery(request, nameParts[1], nameParts[2]);
                    request.addObjectQuery(objQuery);
                }
                continue;
            }
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("The requested object '" + sObjId + "' not found in the Lineage Response.");
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "lineageResponse");
        }
        if (request.getObjectQueryList().size() == 0) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("RSVP lineage response does NOT contain referenced data items.");
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "lineageResponse");
        }
        return request;
    }

    private RequestQuery createDataItemRequestQuery(LineageRequest request, LineageObject lineageObject) {
        String sQueryName = "";
        LineageObject lineageObjectParent = this.getObjects().get(lineageObject.getParentRef());
        sQueryName = lineageObjectParent != null ? lineageObjectParent.getName() : QuerySetIDHelper.parseNameParts(lineageObject.getParentRef())[1];
        RequestQuery objQuery = this.createDataItemRequestQuery(request, sQueryName, lineageObject.getName());
        return objQuery;
    }

    private RequestQuery createDataItemRequestQuery(LineageRequest request, String sQueryName, String sItemName) {
        RequestQuery objQuery = new RequestQuery();
        objQuery.setId(Integer.toString(request.getObjectQueryList().size() + 1));
        objQuery.addParam("queryName", sQueryName);
        objQuery.addParam("dataItemName", sItemName);
        return objQuery;
    }
}

