/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.beans.response;

import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.LineageProperty;
import com.cognos.metadataService.command.lineage.api.client.LineagePropertyList;
import com.cognos.metadataService.command.lineage.api.client.Transformation;
import com.cognos.metadataService.command.lineage.api.client.TransformationSource;
import com.cognos.metadataService.ui.util.EncodingUtility;
import java.util.Collection;
import java.util.Iterator;

public class LineageResponseObject
extends LineageObject {
    public String toJavascript(int nObject) {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append("object");
        buffer.append(nObject);
        buffer.append(":{name:'");
        buffer.append(EncodingUtility.escapeString(this.getName()));
        buffer.append("', type:'");
        buffer.append(EncodingUtility.escapeString(this.getType()));
        buffer.append("', id:'");
        buffer.append(EncodingUtility.escapeString(this.getId()));
        buffer.append("', parent_ref:'");
        buffer.append(EncodingUtility.escapeString(this.getParentRef()));
        buffer.append("'");
        this.appendChildRefs(buffer, this);
        buffer.append(",");
        this.appendProperties(buffer, this);
        buffer.append(",");
        this.appendTransformation(buffer, this);
        buffer.append("}");
        return buffer.toString();
    }

    private void appendChildRefs(StringBuffer buffer, LineageObject lo) {
        Collection children = this.getChildRefs();
        if (children != null) {
            Iterator childIter = children.iterator();
            int childRefIdx = 1;
            while (childIter.hasNext()) {
                buffer.append(", child_ref");
                buffer.append(childRefIdx);
                buffer.append(":'");
                buffer.append(EncodingUtility.escapeString((String)childIter.next()));
                buffer.append("'");
                ++childRefIdx;
            }
        }
    }

    private void appendTransformation(StringBuffer buffer, LineageObject lo) {
        buffer.append("transformation:{");
        Transformation tr = this.getTransformation();
        if (tr != null) {
            Collection sources = tr.getTransformationSourceList();
            Iterator sourcesIter = sources.iterator();
            int i = 0;
            while (sourcesIter.hasNext()) {
                TransformationSource src = (TransformationSource)sourcesIter.next();
                buffer.append("source");
                buffer.append(++i);
                buffer.append(":{objRef:'");
                buffer.append(EncodingUtility.escapeString(src.getObjectRef()));
                buffer.append("'}");
                if (!sourcesIter.hasNext()) continue;
                buffer.append(",");
            }
        }
        buffer.append("}");
    }

    private void appendProperties(StringBuffer buffer, LineageObject lo) {
        buffer.append("properties:{");
        LineagePropertyList props = this.getProperties();
        if (props != null) {
            Iterator params = props.getEntriesCollection().iterator();
            int nParam = 0;
            while (params.hasNext()) {
                LineageProperty prop = (LineageProperty)params.next();
                if (prop.getName().equals("sql") || prop.getEffectiveDisplayValue() == null || prop.getEffectiveDisplayValue().equals("")) continue;
                if (nParam > 0) {
                    buffer.append(",");
                }
                buffer.append("param");
                buffer.append(++nParam);
                buffer.append(":{name:'");
                buffer.append(EncodingUtility.escapeString(prop.getName()));
                buffer.append("', dispName:'");
                buffer.append(EncodingUtility.escapeString(prop.getEffectiveDisplayName()));
                buffer.append("', value:'");
                buffer.append(EncodingUtility.escapeString(prop.getEffectiveDisplayValue()));
                buffer.append("'}");
            }
        }
        buffer.append("}");
    }
}

