/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.metadataService.ui.jsp.base.BaseHelper;
import com.cognos.metadataService.ui.util.EncodingUtility;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public class CheckPackage
extends BaseHelper {
    private ContentManagerService_PortType getCMService() {
        try {
            String url = this.getInternalDispatcher();
            ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType cmService = cmServiceLocator.getcontentManagerService(new URL(url));
            BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.getEnvelope());
            ((Stub)cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            return cmService;
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mu) {
            throw new RuntimeException(mu.getMessage(), mu);
        }
    }

    public boolean checkIfPackageExists() {
        String strPackageLocation = this.m_request.getParameter("packageLocation");
        String strPackageName = this.m_request.getParameter("packageName");
        return this.checkIfPackageExists(strPackageName, strPackageLocation);
    }

    private void checkPackageNameValidity(String pkgName) {
        if (pkgName.indexOf("\"") != -1 && pkgName.indexOf("'") != -1) {
            throw new UIException(this.getMessageWithParams("MSR_SAP_invalidPackageName", pkgName));
        }
    }

    public boolean checkIfPackageExists(String strPackageName, String strPackageLocation) {
        this.checkPackageNameValidity(strPackageName);
        String strEnquotedPackageName = EncodingUtility.encloseInQuotes(strPackageName);
        String searchPath = strPackageLocation + "/package[@name=" + strEnquotedPackageName + "]";
        boolean packageFound = false;
        try {
            PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName};
            QueryOptions queryOpts = new QueryOptions();
            queryOpts.setPermission("read");
            queryOpts.setSchemaInfo(false);
            queryOpts.setMaxObjects(BigInteger.valueOf(0L));
            queryOpts.setSkipObjects(BigInteger.valueOf(0L));
            queryOpts.setDataEncoding(EncodingEnum.base64);
            queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
            queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
            ContentManagerService_PortType cmService = this.getCMService();
            BaseClass[] packages = cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            packageFound = packages.length > 0;
        }
        catch (RemoteException re) {
            super.setFault(re);
        }
        return packageFound;
    }
}

