/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.ccl4j.exceptions.ICCLExceptionHandling;
import com.cognos.ccl4j.resource.CCLResource;
import com.cognos.ccl4j.util.CCLExceptionHelper;
import com.cognos.metadataService.ui.jsp.importWizard.QFFaultHelper;
import com.cognos.metadataService.ui.util.EncodingUtility;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfw4j.utilities.QFException;
import com.ibm.json.java.JSONObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.AxisFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExceptionHandler {
    public static String getExceptionString(Throwable exception, QFFaultHelper faultHelper) {
        return ExceptionHandler.BuildJsonExceptionString(exception, faultHelper);
    }

    private static String getCAMNamespace(AxisFault fault) {
        try {
            Element errorCodeString;
            Element exc;
            SOAPHeaderElement she;
            Element dom;
            Element cam;
            ArrayList headers = fault.getHeaders();
            if (headers != null && headers.size() > 0 && (cam = (Element)(dom = DocumentHelper.parseText((String)(she = (SOAPHeaderElement)headers.get(0)).getAsString()).getRootElement()).selectSingleNode("//*[local-name()='CAM']")) != null && (exc = (Element)cam.selectSingleNode("//*[local-name()='exception']")) != null && (errorCodeString = (Element)exc.selectSingleNode("//*[local-name()='errorCodeString']")) != null && "camAuthUserRecoverable".equals(errorCodeString.getText())) {
                List items = exc.selectNodes("//*[local-name()='item']");
                for (Object o : items) {
                    Element curItem = (Element)o;
                    Element name = curItem.element("name");
                    if (name == null || !"CAMNamespace".equals(name.getText())) continue;
                    Element value = curItem.element("value");
                    return value.getText();
                }
            }
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    private static String BuildJsonExceptionString(Throwable exception, QFFaultHelper faultHelper) {
        String jsonMessage = null;
        JSONObject jsonExceptionObj = new JSONObject();
        jsonExceptionObj.put((Object)"messageString", (Object)exception.getMessage());
        String strTrace = ExceptionHandler.throwableToString(null, exception, 0, true, null);
        jsonExceptionObj.put((Object)"stackTrace", (Object)strTrace);
        if (exception instanceof AxisFault) {
            String namespace = ExceptionHandler.getCAMNamespace((AxisFault)exception);
            if (namespace != null) {
                jsonExceptionObj.put((Object)"isCAM", (Object)true);
                jsonExceptionObj.put((Object)"namespace", (Object)namespace);
            } else {
                try {
                    QFException.checkQF((AxisFault)((AxisFault)exception));
                }
                catch (QFException qf) {
                    Element dom = qf.getDOM();
                    if (dom != null) {
                        jsonExceptionObj.put((Object)"isQF", (Object)true);
                        jsonExceptionObj.put((Object)"faultDom", (Object)dom.asXML());
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        jsonMessage = jsonExceptionObj.toString();
        return jsonMessage;
    }

    public static String throwableToString(String msg, Throwable throwable, int maxLen, boolean htmlEncode, CCLResource res) {
        int len;
        String string = null;
        if (throwable != null) {
            ICCLExceptionHandling icclex;
            Throwable th;
            if (throwable instanceof ICCLExceptionHandling && (th = (icclex = (ICCLExceptionHandling)throwable).getRootException()) != null) {
                throwable = th;
            }
            StringWriter stringWriter = new StringWriter(6000);
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            if (msg != null) {
                printWriter.println(msg);
            }
            CCLExceptionHelper.printLocalizedStackTrace((Throwable)throwable, (CCLResource)res, (PrintWriter)printWriter);
            string = stringWriter.toString();
        }
        if (string == null) {
            string = "null";
        }
        if (maxLen > 0 && (len = string.length()) > maxLen) {
            string = string.substring(0, maxLen);
            string = string + "...";
        }
        if (htmlEncode) {
            string = EncodingUtility.htmlencode(string);
            string = MFWStringHelper.replaceAll((String)string, (String)"\n", (String)"<br>");
        }
        return string;
    }
}

