/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.metadataService.ui.jsp.base.BaseMARequestHelper;
import com.cognos.metadataService.ui.util.EncodingUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtractImportSpec
extends BaseMARequestHelper {
    @Override
    protected String buildMetadataRequest() {
        String strPackageLocation = this.m_request.getParameter("packageLocation");
        String strPackageName = this.m_request.getParameter("packageName");
        String strEnquotedPackageName = EncodingUtility.encloseInQuotes(strPackageName);
        String sModel = strPackageLocation + "/package[@name=" + strEnquotedPackageName + "]";
        sModel = StringEscapeUtils.escapeXml((String)sModel);
        StringBuffer strActionBuffer = new StringBuffer();
        strActionBuffer.append("<metadataRequest connection=\"");
        strActionBuffer.append(sModel);
        strActionBuffer.append("\">");
        strActionBuffer.append("<Metadata Depth=\"2\" authoringLocale=\"en-us\" start_at=\"\" showHidden=\"true\">");
        strActionBuffer.append("<Properties>");
        strActionBuffer.append("<Property name=\"./namespace\" /> ");
        strActionBuffer.append("<Property name=\"./property\" /> ");
        strActionBuffer.append("<Property name=\"*/@name\" /> ");
        strActionBuffer.append("<Property name=\"*/@value\" />");
        strActionBuffer.append("</Properties>");
        strActionBuffer.append("</Metadata>");
        strActionBuffer.append("</metadataRequest>");
        return strActionBuffer.toString();
    }

    public String getJSONImportSpec() {
        String response = super.getResponse();
        InputSource is = new InputSource(new StringReader(response));
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read(is);
            Node property = document.selectSingleNode("//property[@name='importSpec']");
            if (property != null) {
                String importSpec = ((Element)property).attributeValue("value");
                return this.convertImportSpecToBrowseSpec(importSpec);
            }
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        throw new RuntimeException("Package does not support edit");
    }

    private String convertImportSpecToBrowseSpec(String str) {
        String strResults = null;
        JSONObject rootnode = new JSONObject();
        try {
            InputSource is = new InputSource(new StringReader(str));
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read(is);
            JSONObject obj = this.buildItemJsonString(document.getRootElement());
            JSONArray arr = this.buildElementJSONString(document.getRootElement());
            obj.put((Object)"children", (Object)arr);
            rootnode.put((Object)"node", (Object)obj);
            strResults = rootnode.toString();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strResults;
    }

    private JSONArray buildElementJSONString(Element elm) {
        JSONArray obj = null;
        Iterator itrElement = elm.elementIterator();
        while (itrElement.hasNext()) {
            Element elm2 = (Element)itrElement.next();
            if (obj == null) {
                obj = new JSONArray();
            }
            JSONObject objItem = this.buildItemJsonString(elm2);
            obj.add((Object)objItem);
            JSONArray objChildren = this.buildElementJSONString(elm2);
            if (objChildren == null || objChildren.size() <= 0) continue;
            objItem.put((Object)"children", (Object)objChildren);
        }
        return obj;
    }

    private JSONObject buildItemJsonString(Element elm) {
        Iterator itr = elm.attributes().iterator();
        JSONObject nodeObj = new JSONObject();
        while (itr.hasNext()) {
            Attribute attr = (Attribute)itr.next();
            nodeObj.put((Object)attr.getName(), (Object)attr.getValue());
            if (attr.getName() != "Value") continue;
            nodeObj.put((Object)"Selected", (Object)attr.getValue());
        }
        return nodeObj;
    }
}

