/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.metadataService.ui.jsp.base.BaseRequestHelper;
import com.cognos.metadataService.ui.jsp.importWizard.QFFaultHelper;
import com.cognos.metadataService.ui.jsp.importWizard.UtilitiesHelper;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.DocumentException;

public abstract class ImportPublishHelper
extends BaseRequestHelper
implements QFFaultHelper {
    protected String m_strPackageName = null;
    protected String m_strPkgDesc = null;
    protected String m_strPkgScreepTip = null;
    protected String m_strPackageLocation = null;

    @Override
    public String getCredentials() {
        String strCredentials = this.m_request.getParameter("dataSourceCredentials");
        return UtilitiesHelper.decodeCredentials(strCredentials);
    }

    protected String buildImportSpec() {
        String importSpec = this.m_request.getParameter("importSpec");
        String strVal = null;
        try {
            JSONObject sobj = JSONObject.parse((String)importSpec);
            JSONArray arr = (JSONArray)sobj.get((Object)"node");
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject jobj = (JSONObject)arr.get(i);
                String nName = StringEscapeUtils.escapeXml((String)((String)jobj.get((Object)"Name")));
                String nDualStructures = (String)jobj.get((Object)"dualStructures");
                String nType = (String)jobj.get((Object)"Type");
                String nIsSystem = (String)jobj.get((Object)"isSystem");
                String nDBType = (String)jobj.get((Object)"dbType");
                String nValue = (String)jobj.get((Object)"Value");
                strVal = "<item Name=\"" + nName + "\" Type=\"" + nType + "\" Value=\"" + nValue + "\" dbType=\"" + nDBType + "\" dualStructures=\"" + nDualStructures + "\" storeSpec=\"true\"" + " origin=\"portal\"" + " isSystem=\"" + nIsSystem + "\">";
                JSONArray arrChildren = (JSONArray)jobj.get((Object)"children");
                for (int j = 0; j < arrChildren.size(); ++j) {
                    JSONObject jobj1 = (JSONObject)arrChildren.get(j);
                    if (jobj1 == null) continue;
                    String strItem = this.buildItemString(jobj1);
                    strVal = strVal + strItem;
                }
                strVal = strVal + "</item>";
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strVal;
    }

    @Override
    public String getDataSource() {
        String importSpec = this.m_request.getParameter("importSpec");
        String strDataSource = null;
        try {
            JSONObject sobj = JSONObject.parse((String)importSpec);
            JSONArray arr = (JSONArray)sobj.get((Object)"node");
            int i = 0;
            if (i < arr.size()) {
                JSONObject jobj = (JSONObject)arr.get(i);
                strDataSource = StringEscapeUtils.escapeXml((String)((String)jobj.get((Object)"Name")));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strDataSource;
    }

    protected ArrayList<String> buildArrayImportSpec(ArrayList<String> strCubeNameArray) {
        ArrayList<String> strImportArray = new ArrayList<String>();
        String importSpec = this.m_request.getParameter("importSpec");
        try {
            JSONObject jdbObj;
            String nValue;
            JSONObject sobj = JSONObject.parse((String)importSpec);
            JSONArray arr = (JSONArray)sobj.get((Object)"node");
            if (!arr.isEmpty() && ((nValue = (String)(jdbObj = (JSONObject)arr.get(0)).get((Object)"Value")).equals("partial") || nValue.equals("true"))) {
                String nName = StringEscapeUtils.escapeXml((String)((String)jdbObj.get((Object)"Name")));
                String nType = (String)jdbObj.get((Object)"Type");
                String nDBType = (String)jdbObj.get((Object)"dbType");
                StringBuffer strDatabase = new StringBuffer();
                strDatabase.append("<item Name=\"");
                strDatabase.append(nName);
                strDatabase.append("\" Type=\"");
                strDatabase.append(nType);
                strDatabase.append("\" Value=\"");
                strDatabase.append(nValue);
                strDatabase.append("\" dbType=\"");
                strDatabase.append(nDBType);
                strDatabase.append("\" storeSpec=\"true\" origin=\"portal\">");
                JSONArray catalogs = (JSONArray)jdbObj.get((Object)"children");
                for (int j = 0; j < catalogs.size(); ++j) {
                    JSONObject jcatObj = (JSONObject)catalogs.get(j);
                    if (jcatObj == null || !(nValue = (String)jcatObj.get((Object)"Value")).equals("partial") && !nValue.equals("true")) continue;
                    nName = (String)jcatObj.get((Object)"Name");
                    nType = (String)jcatObj.get((Object)"Type");
                    String nUniqueName = (String)jcatObj.get((Object)"uniqueName");
                    StringBuffer strCat = new StringBuffer();
                    strCat.append("<item Name=\"");
                    strCat.append(nName);
                    strCat.append("\" Type=\"");
                    strCat.append(nType);
                    strCat.append("\" Value=\"");
                    strCat.append(nValue);
                    strCat.append("\" uniqueName=\"");
                    strCat.append(nUniqueName);
                    strCat.append("\">");
                    JSONArray cubes = (JSONArray)jcatObj.get((Object)"children");
                    for (int k = 0; k < cubes.size(); ++k) {
                        JSONObject jcubeObj = (JSONObject)cubes.get(k);
                        if (jcubeObj == null || !(nValue = (String)jcubeObj.get((Object)"Value")).equals("partial") && !nValue.equals("true")) continue;
                        nName = (String)jcubeObj.get((Object)"Name");
                        String uName = MFWStringHelper.makeUnique((String)nName, strCubeNameArray, (boolean)false);
                        strCubeNameArray.add(uName);
                        String strCube = this.buildItemString(jcubeObj);
                        StringBuffer strVal = new StringBuffer();
                        strVal.append(strDatabase);
                        strVal.append(strCat);
                        strVal.append(strCube);
                        strVal.append("</item></item>");
                        strImportArray.add(strVal.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strImportArray;
    }

    protected String buildItemString(JSONObject jobj) {
        String strSpec = null;
        String nName = (String)jobj.get((Object)"Name");
        String nType = (String)jobj.get((Object)"Type");
        String nValue = (String)jobj.get((Object)"Value");
        String nUniqueName = (String)jobj.get((Object)"uniqueName");
        String nAttributeDimensionsAsProperties = (String)jobj.get((Object)"attributeDimensionsAsProperties");
        String nAttribDimAsProp = "";
        if (nAttributeDimensionsAsProperties != null) {
            nAttribDimAsProp = "\" attributeDimensionsAsProperties=\"" + nAttributeDimensionsAsProperties;
        }
        strSpec = "<item Name=\"" + nName + "\" Type=\"" + nType + "\" Value=\"" + nValue + "\" uniqueName=\"" + nUniqueName + nAttribDimAsProp + "\">";
        if (jobj.containsKey((Object)"children")) {
            JSONArray arrChildren = (JSONArray)jobj.get((Object)"children");
            for (int j = 0; j < arrChildren.size(); ++j) {
                JSONObject jobj1 = (JSONObject)arrChildren.get(j);
                if (jobj1 == null) continue;
                String strItem = this.buildItemString(jobj1);
                strSpec = strSpec + strItem;
            }
        }
        strSpec = strSpec + "</item>";
        return strSpec;
    }

    protected String buildPackageLocales(String designLocale) {
        String parameters = this.m_request.getParameter("parameters");
        try {
            JSONObject sobj = JSONObject.parse((String)parameters);
            JSONObject sobj1 = (JSONObject)sobj.get((Object)"params");
            JSONArray locales = (JSONArray)sobj1.get((Object)"languages");
            StringBuilder sb = new StringBuilder();
            sb.append("<param seq=\"2\" type=\"i18nstring\">");
            sb.append("<value>");
            sb.append(designLocale);
            sb.append("</value>");
            sb.append("</param>");
            for (int i = 0; i < locales.size(); ++i) {
                sb.append("<param seq=\"");
                int seqNo = 3 + i;
                sb.append(seqNo);
                sb.append("\" type=\"i18nstring\">");
                sb.append("<value>");
                sb.append(locales.get(i).toString());
                sb.append("</value>");
                sb.append("</param>");
            }
            return sb.toString();
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    protected String buildImportParameters() {
        StringBuffer strImportSpec = new StringBuffer();
        String parameters = this.m_request.getParameter("parameters");
        try {
            JSONObject sobj = JSONObject.parse((String)parameters);
            JSONObject sobj1 = (JSONObject)sobj.get((Object)"params");
            String objectName = (String)sobj1.get((Object)"ObjectName");
            String objectLayout = (String)sobj1.get((Object)"ObjectLayout");
            if (objectName != null && objectLayout != null) {
                Integer objectSelction = 0;
                if (objectName.compareToIgnoreCase("ShortName") == 0) {
                    objectSelction = 0;
                } else if (objectName.compareToIgnoreCase("TechnicalName") == 0) {
                    objectSelction = 1;
                } else if (objectName.compareToIgnoreCase("LongName") == 0) {
                    objectSelction = 2;
                }
                Integer objectValue = objectLayout.compareToIgnoreCase("true") == 0 ? 0 : 1;
                JSONArray arr = (JSONArray)sobj1.get((Object)"languages");
                String strCollection = "<stringCollection>";
                String strLang = "";
                for (int i = 0; i < arr.size(); ++i) {
                    strLang = strLang + "<item>" + (String)arr.get(i) + "</item>";
                }
                String designLocale = (String)sobj1.get((Object)"designLocale");
                strLang = strLang + "<item>" + designLocale + "</item>";
                strCollection = strCollection + strLang;
                strCollection = strCollection + "</stringCollection>";
                strImportSpec.append("<param seq=\"3\" type=\"integer\">");
                strImportSpec.append("<value>");
                strImportSpec.append(objectSelction.toString());
                strImportSpec.append("</value>");
                strImportSpec.append("</param>");
                strImportSpec.append("<param seq=\"4\" type=\"integer\">");
                strImportSpec.append("<value>");
                strImportSpec.append(objectValue.toString());
                strImportSpec.append("</value>");
                strImportSpec.append("</param>");
                strImportSpec.append("<param seq=\"5\" type=\"stringCollection\">");
                strImportSpec.append("<value>");
                strImportSpec.append(this.encodeString(strCollection));
                strImportSpec.append("</value>");
                strImportSpec.append("</param>");
                strImportSpec.append("<param seq=\"6\" type=\"integer\">");
                strImportSpec.append("<value>0</value>");
                strImportSpec.append("</param>");
                strImportSpec.append("<param seq=\"7\" type=\"integer\">");
                strImportSpec.append("<value>0</value>");
                strImportSpec.append("</param>");
                strImportSpec.append("<param seq=\"8\" type=\"integer\">");
                strImportSpec.append("<value>1</value>");
                strImportSpec.append("</param>");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strImportSpec.toString();
    }

    protected void buildPackageInfo() {
        String pkgInfo = this.m_request.getParameter("packageInfo");
        try {
            JSONObject sobj = JSONObject.parse((String)pkgInfo);
            JSONObject jsonPkgInfo = (JSONObject)sobj.get((Object)"pkgInfo");
            this.m_strPackageLocation = (String)jsonPkgInfo.get((Object)"Location");
            this.m_strPackageName = (String)jsonPkgInfo.get((Object)"Name");
            this.m_strPkgDesc = jsonPkgInfo.containsKey((Object)"Description") ? (String)jsonPkgInfo.get((Object)"Description") : "";
            this.m_strPkgScreepTip = jsonPkgInfo.containsKey((Object)"ScreenTip") ? (String)jsonPkgInfo.get((Object)"ScreenTip") : "";
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected String escapeIdString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ']') {
                sb.append("]]");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected abstract String buildImportPublishAction();

    @Override
    protected String setResponse(InputStream strResponse) throws DocumentException {
        String strResult = super.setResponse(strResponse);
        return this.ParseReturnValue(strResult);
    }

    private String ParseReturnValue(String strResult) {
        return strResult;
    }

    @Override
    public MetadataServiceLineageSpecification buildRequestBody() {
        MetadataServiceLineageSpecification requestSpec = new MetadataServiceLineageSpecification();
        String sRequestSpec = this.buildImportPublishAction();
        requestSpec.setValue(new Specification(sRequestSpec));
        return requestSpec;
    }

    @Override
    public boolean requiresPassportRefreshing() {
        return true;
    }
}

