/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.metadataService.ui.jsp.base.BaseMARequestHelper;
import com.cognos.metadataService.ui.util.EncodingUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class SAPVariablesHelper
extends BaseMARequestHelper {
    @Override
    protected String buildMetadataRequest() {
        String strPackageLocation = this.m_request.getParameter("packageLocation");
        String strPackageName = this.m_request.getParameter("packageName");
        String strEnquotedPackageName = EncodingUtility.encloseInQuotes(strPackageName);
        String sModel = strPackageLocation + "/package[@name=" + strEnquotedPackageName + "]";
        sModel = StringEscapeUtils.escapeXml((String)sModel);
        StringBuffer strActionBuffer = new StringBuffer();
        strActionBuffer.append("<metadataRequest connection=\"");
        strActionBuffer.append(sModel);
        strActionBuffer.append("\">");
        strActionBuffer.append("<Metadata Depth='' no_collections='1'>");
        strActionBuffer.append("<Properties>");
        strActionBuffer.append("<Property name=\"*/@name\"/>");
        strActionBuffer.append("<Property name=\"*/@cube\"/>");
        strActionBuffer.append("<Property name=\"*/@catalog\"/>");
        strActionBuffer.append("<Property name=\"property/@type\"/>");
        strActionBuffer.append("<Property name=\"property/@value\"/>");
        strActionBuffer.append("<Property name=\"./dataSource\"/>");
        strActionBuffer.append("<Property name=\"./property\"/>");
        strActionBuffer.append("</Properties>");
        strActionBuffer.append("</Metadata>");
        strActionBuffer.append("</metadataRequest>");
        return strActionBuffer.toString();
    }

    @Override
    protected String setResponse(String strResult) throws DocumentException {
        String strResponse = null;
        Document oDom = null;
        try {
            String sMetaData = strResult.substring(strResult.indexOf("?>") + 2);
            SAXReader xmlReader = new SAXReader();
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            ByteArrayInputStream bais = new ByteArrayInputStream(sMetaData.getBytes("UTF-8"));
            oDom = xmlReader.read((InputStream)bais);
            strResponse = this.buildJsonString(oDom);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return strResponse;
    }

    private JSONObject addVariableProperty(Element elmnodeVar, String strXPath) {
        JSONObject varObj = null;
        List lstVariables = elmnodeVar.selectNodes(strXPath);
        for (Element elmnodeVar1 : lstVariables) {
            varObj = this.buildAttribute(elmnodeVar1, true);
        }
        return varObj;
    }

    private JSONObject buildAttribute(Element elmnode, boolean bAddLocalizedString) {
        JSONObject varObj = new JSONObject();
        Iterator itrAttrib = elmnode.attributeIterator();
        while (itrAttrib.hasNext()) {
            String strLocalizedName;
            Attribute attr = (Attribute)itrAttrib.next();
            varObj.put((Object)attr.getName(), (Object)attr.getValue());
            if (!bAddLocalizedString || attr.getName().compareTo("name") != 0 || (strLocalizedName = this.getMessage("MSR_SAP_" + attr.getValue())) == null) continue;
            varObj.put((Object)"displayName", (Object)strLocalizedName);
        }
        return varObj;
    }

    private String buildJsonString(Document oDom) {
        String strResponse = null;
        JSONObject rootnode = new JSONObject();
        JSONArray rootChildren = new JSONArray();
        rootnode.put((Object)"dataSource", (Object)rootChildren);
        List lst = oDom.selectNodes("//dataSource");
        for (Element elmnode : lst) {
            List lstVariables = elmnode.selectNodes(".//property[@name='SAP BW Variables']");
            Iterator itrVar = lstVariables.iterator();
            JSONObject varDatasource = this.buildAttribute(elmnode, false);
            rootChildren.add((Object)varDatasource);
            JSONArray arrayNodes = new JSONArray();
            varDatasource.put((Object)"variables", (Object)arrayNodes);
            while (itrVar.hasNext()) {
                Element elmnodeVar = (Element)itrVar.next();
                Iterator itrElement = elmnodeVar.elementIterator();
                while (itrElement.hasNext()) {
                    Element elmnodeVar1 = (Element)itrElement.next();
                    JSONObject varObj = this.buildAttribute(elmnodeVar1, false);
                    ArrayList<String> arrSearch = new ArrayList<String>();
                    arrSearch.add(".//property[@name='defaultLow']");
                    arrSearch.add(".//property[@name='defaultHigh']");
                    arrSearch.add(".//property[@name='promptType']");
                    arrSearch.add(".//property[@name='showKeyAndCaption']");
                    arrSearch.add(".//property[@name='isKeyDate']");
                    JSONArray arrayChildren = new JSONArray();
                    JSONObject jsonObj = null;
                    for (int i = 0; i < arrSearch.size(); ++i) {
                        jsonObj = this.addVariableProperty(elmnodeVar1, (String)arrSearch.get(i));
                        if (jsonObj == null) continue;
                        arrayChildren.add((Object)jsonObj);
                    }
                    varObj.put((Object)"children", (Object)arrayChildren);
                    arrayNodes.add((Object)varObj);
                }
            }
        }
        strResponse = rootnode.toString();
        return strResponse;
    }
}

