/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.importWizard;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.metadataService.ui.UIHandler;
import com.cognos.metadataService.ui.jsp.base.BaseHelper;
import com.cognos.metadataService.ui.jsp.base.CmHelper;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.XPathExpr;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UtilitiesHelper
extends BaseHelper {
    private static final int MAX_CUBES_DEFAULT = 2;
    private static final int MAX_INFOQUERIES_DEFAULT = 5;
    public static final String testDataSourceAction = "<action seq=\"{ACT}\" type=\"DoQueryServicesRequest4MFWA4J\"><inputparams><param seq=\"1\" type=\"cclnode\"><value><![CDATA[<command><connection><dataSourceType value=\"QueryFrameworkService\"/><connection><dataSource value=\"{DS}\"/><dataSourceType value=\"Database\"/><connectionString value=\"\"/></connection></connection><testConnection/></command>]]></value></param></inputparams><domchanges/><result success=\"t\"><outputparams><param seq=\"0\" type=\"cclnode\"><value/></param></outputparams></result></action>";

    public int getMaxCubes() {
        UIHandler handler = (UIHandler)((Object)this.m_request.getAttribute("producer"));
        ICCLConfiguration config = handler.getConfiguration();
        try {
            String value = config.getValue("com.ibm.cognos.metadatauiservice.sap.maxcubes", false);
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 2;
    }

    public int getMaxInfoQueries() {
        UIHandler handler = (UIHandler)((Object)this.m_request.getAttribute("producer"));
        ICCLConfiguration config = handler.getConfiguration();
        try {
            String value = config.getValue("com.ibm.cognos.metadatauiservice.sap.maxInfoQueries", false);
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 5;
    }

    public boolean getOlapDQMFlag() {
        UIHandler handler = (UIHandler)((Object)this.m_request.getAttribute("producer"));
        ICCLConfiguration config = handler.getConfiguration();
        try {
            String value = config.getValue("com.ibm.cognos.metadataservice.olap.disable.classic", false);
            if (value != null && value != "") {
                return value.toLowerCase().equals("yes") || value.toLowerCase().equals("true");
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static String encodeCredentials(String credentials) {
        try {
            CAMFactory factory = CryptoFacility.getCAMFactory();
            EncryptingSession session = factory.createEncryptingSession();
            byte[] data = session.encryptData(credentials.getBytes("UTF-8"));
            String res = base64.encode((int)0, (byte[])data);
            return res;
        }
        catch (CAMCryptoException cce) {
            throw new RuntimeException(cce.getMessage(), cce);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.getMessage(), use);
        }
    }

    static String decodeCredentials(String sCredentials) {
        try {
            CAMFactory factory = CryptoFacility.getCAMFactory();
            EncryptingSession session = factory.createEncryptingSession();
            if (sCredentials != null && sCredentials.length() > 0) {
                byte[] decoded = base64.decode((int)0, (String)sCredentials);
                byte[] unencoded = session.decryptData(decoded);
                sCredentials = new String(unencoded, "UTF-8");
            }
            return sCredentials;
        }
        catch (CAMCryptoException crypto) {
            throw new RuntimeException(crypto.getMessage(), crypto);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.getMessage(), use);
        }
    }

    public String updateCredentials() {
        String currentCredentials = this.m_request.getParameter("current_credentials");
        String newCredentials = this.m_request.getParameter("newcredentials_password");
        try {
            byte[] unencoded;
            byte[] decoded;
            CAMFactory factory = CryptoFacility.getCAMFactory();
            EncryptingSession session = factory.createEncryptingSession();
            if (currentCredentials != null && currentCredentials.length() > 0) {
                decoded = base64.decode((int)0, (String)currentCredentials);
                unencoded = session.decryptData(decoded);
                currentCredentials = new String(unencoded, "UTF-8");
            }
            if (newCredentials != null && newCredentials.length() > 0) {
                decoded = base64.decode((int)0, (String)newCredentials);
                unencoded = session.decryptData(decoded);
                newCredentials = new String(unencoded, "UTF-8");
            }
            String credentials = this.mergeCredentials(currentCredentials, newCredentials);
            this.saveCredentials(credentials);
            return credentials;
        }
        catch (CAMCryptoException crypto) {
            throw new RuntimeException(crypto.getMessage(), crypto);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.getMessage(), use);
        }
    }

    private String mergeCredentials(String current, String newCredentials) {
        return newCredentials;
    }

    public static String buildCredentialAction(String strCredentials, String strDataSource) {
        try {
            strCredentials = UtilitiesHelper.decodeCredentials(strCredentials);
            InputSource is = new InputSource(new StringReader(strCredentials));
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read(is);
            Node node = document.selectSingleNode(".//dataSourceConnection");
            String strConnection = node.getStringValue();
            if (strConnection != null && strConnection.length() > 0) {
                int nIndexStart = strConnection.lastIndexOf("@name='");
                int nIndexEnd = strConnection.lastIndexOf("'");
                strConnection = strConnection.substring(nIndexStart + 7, nIndexEnd);
            }
            Node nodeUserName = document.selectSingleNode(".//username");
            Node nodePassword = document.selectSingleNode(".//password");
            String strAction = strConnection != null && strConnection.length() > 0 && nodeUserName.getStringValue().length() == 0 ? UtilitiesHelper.BuildSelectDataSourceConnectionAction(strDataSource, strConnection) : UtilitiesHelper.BuildSelectDataSourceCredentials(strDataSource, strConnection, nodeUserName.getStringValue(), nodePassword.getStringValue());
            return strAction;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String BuildSelectDataSourceCredentials(String strDataSource, String strConnection, String userName, String userPasswd) {
        StringBuffer buff = new StringBuffer();
        buff.append("<action seq=\"5\" type=\"SelectDataSourceCredentials\">");
        buff.append("<inputparams>");
        buff.append("<param seq=\"1\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(strDataSource);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("<param seq=\"2\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(strConnection);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("<param seq=\"3\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(userName);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("<param seq=\"4\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(userPasswd);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("</inputparams>");
        buff.append("<domchanges/>");
        buff.append("<result success=\"t\">");
        buff.append("<outputparams/>");
        buff.append("</result>");
        buff.append("</action>");
        return buff.toString();
    }

    private static String BuildSelectDataSourceConnectionAction(String strDataSource, String strConnection) {
        StringBuffer buff = new StringBuffer();
        buff.append("<action seq=\"3\" type=\"SelectDataSourceConnection\">");
        buff.append("<inputparams>");
        buff.append("<param seq=\"1\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(strDataSource);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("<param seq=\"2\" type=\"i18nstring\">");
        buff.append("<value>");
        buff.append(strConnection);
        buff.append("</value>");
        buff.append("</param>");
        buff.append("</inputparams>");
        buff.append("<domchanges/>");
        buff.append("<result success=\"t\">");
        buff.append("<outputparams/>");
        buff.append("</result>");
        buff.append("</action>");
        return buff.toString();
    }

    private void saveCredentials(String credentials) {
        CmHelper cmHelper = new CmHelper();
        cmHelper.setRequest(this.m_request);
        try {
            InputSource is = new InputSource(new StringReader(credentials));
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read(is);
            Element root = (Element)document.selectSingleNode(".//credential");
            if ("true".equals(root.attributeValue("persist"))) {
                Node node = document.selectSingleNode(".//dataSourceConnection");
                String dsConnection = node.getStringValue();
                String[] arr = new String[2];
                this.solvePathForDataSourceAndConnection(dsConnection, arr);
                String dataSourceName = arr[0];
                String connectionName = arr[1];
                Node usr = document.selectSingleNode(".//username");
                Node pswd = document.selectSingleNode(".//password");
                cmHelper.addCredential("~", dataSourceName, connectionName, usr.getText(), pswd.getText());
            }
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (SAXException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    private void solvePathForDataSourceAndConnection(String xpathStr, String[] outValue) {
        try {
            XPathReader xpathReader = XPathReaderFactory.createReader();
            JaxenHandler handler = new JaxenHandler();
            xpathReader.setXPathHandler((XPathHandler)handler);
            xpathReader.parse(xpathStr);
            XPathExpr xpath = handler.getXPathExpr();
            PathExpr expr = (PathExpr)xpath.getRootExpr();
            List steps = expr.getLocationPath().getSteps();
            for (Object step : steps) {
                EqualityExpr ex;
                Expr rhs;
                Predicate pred;
                NameStep nameStep = (NameStep)step;
                if ("dataSource".equals(nameStep.getLocalName())) {
                    pred = (Predicate)nameStep.getPredicates().get(0);
                    if (!(pred.getExpr() instanceof EqualityExpr) || (rhs = (ex = (EqualityExpr)pred.getExpr()).getRHS()) == null || !(rhs instanceof LiteralExpr)) continue;
                    outValue[0] = ((LiteralExpr)rhs).getLiteral();
                    continue;
                }
                if (!"dataSourceConnection".equals(nameStep.getLocalName()) || !((pred = (Predicate)nameStep.getPredicates().get(0)).getExpr() instanceof EqualityExpr) || (rhs = (ex = (EqualityExpr)pred.getExpr()).getRHS()) == null || !(rhs instanceof LiteralExpr)) continue;
                outValue[1] = ((LiteralExpr)rhs).getLiteral();
            }
        }
        catch (SAXPathException spe) {
            throw new RuntimeException(spe.getMessage(), spe);
        }
    }

    public boolean GetPackageProperty_UseV5DataServer(String passport, String searchPath) {
        MFWContentHelper helper = MFWContentHelper.create((String)passport, (String)"en", (String)"en", (BIBusEnvelope)this.getEnvelope());
        String[] props = new String[]{"options"};
        List objectProperties = helper.getObjectProperties(searchPath, props);
        List opts = (List)objectProperties.get(0);
        boolean bIsV5DataServer = MFWContentHelper.getQueryStack((List)opts) == "queryService";
        return bIsV5DataServer;
    }

    public void SetModelOption(String searchPath, String propertyName, String propertyValue) {
        try {
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType cmService = serviceLocator.getcontentManagerService(new URL(this.getInternalDispatcher()));
            BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.getEnvelope());
            ((Stub)cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            GenericOptionAnyURI[] values = new GenericOptionAnyURI[]{new GenericOptionAnyURI()};
            values[0].setName(propertyName);
            values[0].setValue(propertyValue);
            OptionArrayProp options = new OptionArrayProp();
            options.setValue((Option[])values);
            StringProp searchPathStrProp = new StringProp();
            searchPathStrProp.setValue(searchPath);
            Model m = new Model();
            m.setSearchPath(searchPathStrProp);
            m.setOptions(options);
            BaseClass[] models = new BaseClass[]{m};
            cmService.update(models, null);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (RemoteException re) {
            throw new RuntimeException(re.getMessage(), re);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
    }
}

