/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.personalDataBeans;

import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.MetadataService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.metadataService.ui.UIHandler;
import com.cognos.metadataService.ui.jsp.LookAheadObjectInputStream;
import com.cognos.metadataService.ui.jsp.personalDataBeans.AddDataBean;
import com.cognos.metadataService.ui.jsp.personalDataBeans.GetDataBean;
import com.cognos.metadataService.ui.jsp.personalDataBeans.GetQuerySubjectDataBean;
import com.cognos.metadataService.ui.jsp.personalDataBeans.ProcessDataBean;
import com.cognos.metadataService.ui.jsp.personalDataBeans.ProcessExtractReportBean;
import com.cognos.metadataService.ui.util.DOMUtil;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class BasePersonalDataBean {
    protected HttpServletRequest mRequest;
    private String mResponse = null;
    protected Exception mSoapFault = null;

    protected BasePersonalDataBean() {
    }

    public static BasePersonalDataBean create(String commandName) {
        if ("processPersonalData".equals(commandName)) {
            return new ProcessDataBean();
        }
        if ("addPersonalData".equals(commandName)) {
            return new AddDataBean();
        }
        if ("getPersonalData".equals(commandName)) {
            return new GetDataBean();
        }
        if ("processExtractReport".equals(commandName)) {
            return new ProcessExtractReportBean();
        }
        if ("getQuerySubjectData".equals(commandName)) {
            return new GetQuerySubjectDataBean();
        }
        return null;
    }

    protected abstract MetadataServiceLineageSpecification buildRequestBody();

    public void setRequest(HttpServletRequest request) {
        this.mRequest = request;
    }

    public Exception getFault() {
        return this.mSoapFault;
    }

    private UIHandler getProducer() {
        return (UIHandler)((Object)this.mRequest.getAttribute("producer"));
    }

    protected MessageContext getContext() {
        return (MessageContext)this.mRequest.getAttribute("bibus.context");
    }

    protected BIBusEnvelope getEnvelope() {
        return (BIBusEnvelope)this.getContext().getProperty("request.envelope");
    }

    public String getResponse() {
        return this.mResponse;
    }

    public String doConversation(String seralizedHeaderFieldName, String actionFieldName) {
        try {
            BiBusHeader bibus;
            String str = this.mRequest.getParameter(seralizedHeaderFieldName);
            String sContext = str != null ? str.toString() : "";
            boolean alreadyInConversation = !"".equals(sContext) && sContext != null;
            MetadataService_PortType port = this.getMetadataServicePort();
            ParameterValue[] paramValues = new ParameterValue[]{};
            Option[] options = this.getOptions();
            boolean cancelRequested = "cancel".equals(this.mRequest.getParameter(actionFieldName));
            AsynchReply reply = null;
            if (!cancelRequested && (sContext.equals("") || sContext.equals("null"))) {
                MetadataServiceLineageSpecification requestSpec = this.buildRequestBody();
                BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.getEnvelope());
                ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                reply = port.runSpecification((AsynchSpecification)requestSpec, paramValues, options);
            } else if (alreadyInConversation) {
                byte[] decodedValue = base64.decode((int)0, (String)sContext);
                ByteArrayInputStream inStream = new ByteArrayInputStream(decodedValue);
                LookAheadObjectInputStream laoistream = new LookAheadObjectInputStream(inStream);
                BiBusHeader header = (BiBusHeader)laoistream.readObject();
                Stub stub = (Stub)port;
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            }
            boolean cancelled = false;
            if (reply == null || AsynchReplyStatusEnum.working == reply.getStatus() || AsynchReplyStatusEnum.stillWorking == reply.getStatus()) {
                AsynchRequest primary;
                if (cancelRequested) {
                    if (alreadyInConversation) {
                        primary = reply != null ? reply.getPrimaryRequest() : null;
                        port.cancel(primary);
                    }
                    cancelled = true;
                } else {
                    while (!reply.getStatus().equals((Object)AsynchReplyStatusEnum.complete) && !reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                        primary = reply.getPrimaryRequest();
                        SOAPHeaderElement responseHeader = ((Stub)port).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                        if (responseHeader != null) {
                            ((Stub)port).clearHeaders();
                            bibus = (BiBusHeader)responseHeader.getObjectValue(BiBusHeader.class);
                            ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
                        }
                        reply = port.wait(primary, paramValues, options);
                    }
                }
            }
            if (reply != null && AsynchReplyStatusEnum.working != reply.getStatus() && AsynchReplyStatusEnum.stillWorking != reply.getStatus()) {
                AsynchDetail[] details = reply.getDetails();
                InputStream ds = this.getResultStream(port, details[0]);
                this.setResponse(ds);
                return null;
            }
            if (!cancelled) {
                Stub stub = (Stub)port;
                SOAPHeaderElement header = stub.getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                bibus = (BiBusHeader)header.getObjectValue(BiBusHeader.class);
                ByteArrayOutputStream outArray = new ByteArrayOutputStream();
                ObjectOutputStream outStream = new ObjectOutputStream(outArray);
                outStream.writeObject(bibus);
                outStream.close();
                return base64.encode((int)0, (byte[])outArray.toByteArray());
            }
        }
        catch (RemoteException e) {
            this.mSoapFault = e;
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void commitFault() {
        MessageContext myContext = (MessageContext)this.mRequest.getAttribute("bibus.context");
        if (this.mSoapFault != null) {
            if (this.mSoapFault instanceof AxisFault) {
                AxisFault axisFault = (AxisFault)this.mSoapFault;
                SOAPFault fault = new SOAPFault(axisFault);
                try {
                    BIBusEnvelope responseEnvelope = (BIBusEnvelope)myContext.getProperty("response.envelope");
                    ArrayList al = axisFault.getHeaders();
                    for (int i = 0; i < al.size(); ++i) {
                        Attribute att;
                        Object obj = al.get(i);
                        if (!(obj instanceof SOAPHeaderElement)) continue;
                        String xml = obj.toString();
                        Element header = DOMUtil.parse(xml);
                        responseEnvelope.setBIBusHeader(header);
                        Element cam = responseEnvelope.getCAM();
                        Element exc = cam.element("exception");
                        if (exc == null || (att = exc.attribute("nil")) == null || !"true".equals(att.getValue())) continue;
                        cam.remove(exc);
                    }
                    Element dom4jFault = DOMUtil.toDOM4J(fault.getAsDOM());
                    dom4jFault.detach();
                    Element responseBody = responseEnvelope.getBody();
                    responseBody.add(dom4jFault);
                    Fault f = new Fault(axisFault.getMessage(), (SOAPEnvelope)responseEnvelope);
                    myContext.setFault(f);
                }
                catch (Exception e) {
                    Fault f = new Fault(axisFault.getMessage());
                    f.addDetail(axisFault.dumpToString());
                    myContext.setFault(f);
                }
            } else {
                Fault f = new Fault(this.mSoapFault.getMessage(), this.mSoapFault);
                myContext.setFault(f);
            }
        }
    }

    private void setResponse(InputStream strResponse) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            document = reader.read(strResponse);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Element elmResponse = (Element)document.selectSingleNode("output");
        if (elmResponse == null) {
            elmResponse = (Element)document.selectSingleNode("html");
        }
        this.mResponse = elmResponse.asXML();
    }

    protected void setResponse(String strResponse) {
        this.mResponse = strResponse;
    }

    private Option[] getOptions() {
        AsynchOptionEncoding encoding = new AsynchOptionEncoding();
        encoding.setName(AsynchOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIMECompressed);
        AsynchOptionInt primaryWaitThreshold = new AsynchOptionInt();
        primaryWaitThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWaitThreshold.setValue(7);
        Option[] options = new Option[]{encoding, primaryWaitThreshold};
        return options;
    }

    private MetadataService_PortType getMetadataServicePort() throws MalformedURLException, ServiceException {
        MetadataService_ServiceLocator serviceLocator = new MetadataService_ServiceLocator();
        MetadataService_PortType port = null;
        String dispatcherURL = this.getProducer().getInternalDispatcher();
        port = serviceLocator.getmetadataService(new URL(dispatcherURL));
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    private InputStream getResultStream(MetadataService_PortType port, AsynchDetail detail) {
        try {
            Object[] attachments = ((Stub)port).getAttachments();
            if (attachments.length > 0) {
                AttachmentPart attach = (AttachmentPart)attachments[0];
                InputStream is = attach.getDataHandler().getInputStream();
                String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
                if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                    return new GZIPInputStream(is);
                }
                return is;
            }
            String result = new String(((AsynchDetailMIMEAttachment)detail).getData(), "UTF8");
            return new ByteArrayInputStream(result.getBytes("UTF8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
    }

    private ByteArrayOutputStream readHeaderContent(InputStream isPart) {
        try {
            int len;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = isPart.read(buf)) > 0) {
                bOut.write(buf, 0, len);
            }
            isPart.close();
            return bOut;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, ByteArrayOutputStream> getInputFields(MessageContext messageContext, StringBuffer filePath) {
        HashMap<String, ByteArrayOutputStream> outMap = new HashMap<String, ByteArrayOutputStream>();
        try {
            Iterator it = (Iterator)messageContext.getProperty("request.attachments");
            while (it != null && it.hasNext()) {
                int fn;
                int idx;
                InputStream isPart = (InputStream)it.next();
                InternetHeaders headers = new InternetHeaders(isPart);
                String hValues = headers.getHeader("Content-Disposition", "%%");
                String name = hValues.substring(idx = hValues.indexOf("name=\"") + 6, hValues.indexOf("\"", idx + 1));
                if (name != null) {
                    outMap.put(name, this.readHeaderContent(isPart));
                }
                if ((fn = hValues.indexOf("filename=")) < 0 || filePath == null) continue;
                filePath.append(hValues.substring(fn + 10, hValues.lastIndexOf("\"")));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return outMap;
    }
}

