/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.personalDataBeans;

import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.ui.jsp.personalDataBeans.BasePersonalDataBean;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ProcessDataBean
extends BasePersonalDataBean {
    ProcessDataBean() {
    }

    @Override
    protected MetadataServiceLineageSpecification buildRequestBody() {
        Element dsName;
        MetadataServiceLineageSpecification requestSpec = new MetadataServiceLineageSpecification();
        StringBuffer req = new StringBuffer("<processPersonalData>");
        StringBuffer fileName = new StringBuffer();
        Map<String, ByteArrayOutputStream> inFields = this.getInputFields(this.getContext(), fileName);
        ByteArrayOutputStream inSpec = inFields.get("inSpec");
        String strInSpec = null;
        try {
            if (inSpec != null) {
                strInSpec = inSpec.toString("UTF8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        if (strInSpec != null) {
            req.append(strInSpec);
        } else {
            req.append("<input><dataSet><sourcePath>");
            req.append(fileName);
            req.append("</sourcePath></dataSet></input>");
        }
        req.append("</processPersonalData>");
        Element elmReq = this.parseRequest(req.toString());
        Element elmDataSet = (Element)elmReq.selectSingleNode(".//dataSet");
        Element elmSrcPath = (Element)elmReq.selectSingleNode(".//dataSet/sourcePath");
        ByteArrayOutputStream inFile = inFields.get("pdsContent");
        String dsType = elmDataSet.attributeValue("type");
        if (dsType == null || dsType.length() == 0) {
            elmDataSet.addAttribute("type", PersonalDataConvertor.getDefaultPDSType(elmSrcPath.getText()));
        }
        if ((dsName = (Element)elmDataSet.selectSingleNode("./name")) == null) {
            elmDataSet.addElement("name").setText(this.getDefaultPDSName(elmSrcPath.getText()));
        } else if (dsName.getText() == null || dsName.getText().length() == 0) {
            dsName.setText(this.getDefaultPDSName(elmSrcPath.getText()));
        }
        elmDataSet.addElement("content").addCDATA(base64.encode((int)0, (byte[])inFile.toByteArray()));
        String sRequestSpec = elmReq.asXML();
        requestSpec.setValue(new Specification(sRequestSpec));
        return requestSpec;
    }

    private Element parseRequest(String sReq) {
        try {
            StringReader myReader = new StringReader(sReq);
            SAXReader myParser = new SAXReader();
            myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = myParser.read((Reader)myReader);
            return document.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        catch (SAXException de) {
            throw new RuntimeException(de);
        }
    }

    protected String getDefaultPDSName(String uploadedFileName) {
        return uploadedFileName.substring(uploadedFileName.lastIndexOf("\\") + 1, uploadedFileName.lastIndexOf("."));
    }
}

