/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.jsp.personalDataBeans;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.metadataService.command.personalData.CommandGetData;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataGovernors;
import com.cognos.metadataService.command.personalData.ReportRunner;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.misc.XMLHelper;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class XMLDataStreamHandler {
    protected HttpServletRequest mRequest;
    static String ADDVANCED_SETTING_NAME = "ExternalDataAlwaysPromptForFile";
    static String ADDVANCED_SETTING_VALUE1 = "true";
    static String ADDVANCED_SETTING_VALUE2 = "yes";

    public XMLDataStreamHandler(HttpServletRequest request) {
        this.mRequest = request;
    }

    protected MessageContext getContext() {
        return (MessageContext)this.mRequest.getAttribute("bibus.context");
    }

    public String getData() {
        String sourceType = this.mRequest.getParameter("st");
        if ("s".equals(sourceType)) {
            return this.querySession();
        }
        if ("r".equals(sourceType)) {
            return this.reportExtract();
        }
        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, "st", sourceType);
    }

    private String querySession() {
        String advancedSetting = this.configurationAdvancedSettings();
        boolean overrideAccessDirect = this.findAdvancedSetting(advancedSetting, ADDVANCED_SETTING_NAME);
        String sSourceXML = this.lookupSourceInSession();
        if (sSourceXML == null || sSourceXML.length() == 0) {
            PersonalDataInfo infoPD = this.getDataSourceInfo();
            sSourceXML = infoPD.mAccessDirect && !overrideAccessDirect ? this.getAndConvertFile(infoPD) : this.makeFault(infoPD);
        }
        return sSourceXML;
    }

    private String lookupSourceInSession() {
        try {
            Output cmOutput;
            Base64BinaryMIMEProp mimeProp;
            StringBuffer searchPath = new StringBuffer("~~/output[@name='");
            searchPath.append(this.mRequest.getParameter("pds"));
            searchPath.append("']");
            PropEnum[] propArray = new PropEnum[2];
            propArray[1] = PropEnum.name;
            propArray[0] = PropEnum.data;
            QueryOptions queryOpts = new QueryOptions(EncodingEnum.MIME, null, null, null, null, false, null, null);
            queryOpts.setPermission("read");
            queryOpts.setSchemaInfo(false);
            queryOpts.setDataEncoding(EncodingEnum.base64);
            BaseClass[] results = this.getContentManagerServicePort().query(new SearchPathMultipleObject(searchPath.toString()), propArray, null, queryOpts);
            if (results != null && results.length > 0 && results[0] instanceof Output && (mimeProp = (cmOutput = (Output)results[0]).getData()) != null) {
                byte[] bytes = mimeProp.getValue();
                return new String(bytes, "UTF8");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    private BaseClass[] getObjectsForSearchPath(String searchPath) {
        BaseClass[] myCMObjects;
        SearchPathMultipleObject cmSearchPath = new SearchPathMultipleObject(searchPath);
        try {
            PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.objectClass, PropEnum.hasChildren};
            myCMObjects = this.getContentManagerServicePort().query(cmSearchPath, properties, new Sort[0], new QueryOptions());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return myCMObjects;
    }

    private String getConfigurationObjectValue(BaseClass myCMObject, String methodName) {
        BaseClass ResCMObject;
        String returnValue = "";
        Class<?> cmObjectClass = myCMObject.getClass();
        Method[] cmObjectMethods = cmObjectClass.getMethods();
        HashMap<Method, PropEnum> objectProperties = new HashMap<Method, PropEnum>();
        for (int i = 0; i < cmObjectMethods.length; ++i) {
            String methodNameCurrent = cmObjectMethods[i].getName();
            try {
                PropEnum theProperty = PropEnum.fromString((String)this.propertyFromGetMethod(methodNameCurrent));
                objectProperties.put(cmObjectMethods[i], theProperty);
                continue;
            }
            catch (IllegalArgumentException isEx) {
                cmObjectMethods[i] = null;
            }
        }
        PropEnum[] allTheProps = new PropEnum[objectProperties.size()];
        int j = 0;
        for (int i = 0; i < cmObjectMethods.length; ++i) {
            if (cmObjectMethods[i] == null) continue;
            try {
                allTheProps[j++] = PropEnum.fromString((String)((PropEnum)objectProperties.get(cmObjectMethods[i])).getValue());
                continue;
            }
            catch (IllegalArgumentException isEx) {
                --j;
            }
        }
        try {
            SearchPathMultipleObject cmObjPath = new SearchPathMultipleObject();
            cmObjPath.set_value(myCMObject.getSearchPath().getValue());
            BaseClass[] ResCMObjects = this.getContentManagerServicePort().query(cmObjPath, allTheProps, new Sort[0], new QueryOptions());
            if (ResCMObjects.length <= 0) {
                return returnValue;
            }
            ResCMObject = ResCMObjects[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Method[] objectMethods = ResCMObject.getClass().getMethods();
        if (objectMethods.length <= 0) {
            return returnValue;
        }
        Method method = null;
        for (int i = 0; i < objectMethods.length; ++i) {
            if (!objectMethods[i].getName().equals(methodName)) continue;
            if (objectMethods[i].getName().indexOf("get") != 0 || objectMethods[i].getParameterTypes().length != 0) break;
            method = objectMethods[i];
            break;
        }
        Object propertyValue = null;
        if (method != null) {
            block18: {
                try {
                    propertyValue = method.invoke((Object)ResCMObject, new Object[0]);
                    if (propertyValue == null) break block18;
                    Class<?> propertyValueClass = propertyValue.getClass();
                    Method[] propertyValueMethods = propertyValueClass.getMethods();
                    for (int i = 0; i < propertyValueMethods.length; ++i) {
                        if (propertyValueMethods[i].getName().compareTo("getValue") != 0) continue;
                        propertyValue = propertyValueMethods[i].invoke(propertyValue, new Object[0]);
                        break;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (propertyValue != null) {
                returnValue = (String)propertyValue;
            }
        }
        return returnValue;
    }

    private String configurationAdvancedSettings() {
        String advancedSetting = "";
        BaseClass[] myCMObjects = this.getObjectsForSearchPath("/configuration/dispatcher");
        for (int i = 0; i < myCMObjects.length; ++i) {
            BaseClass myCMObject = myCMObjects[i];
            String dispather = this.getConfigurationObjectValue(myCMObject, "getDispatcherPath");
            String searchPath = "/configuration/dispatcher[@name='" + dispather + "']/metadataService[@name='MetadataService']";
            BaseClass[] metadataServiceObjects = this.getObjectsForSearchPath(searchPath);
            if (metadataServiceObjects.length <= 0) continue;
            advancedSetting = this.getConfigurationObjectValue(metadataServiceObjects[0], "getAdvancedSettings");
            break;
        }
        return advancedSetting;
    }

    private boolean findAdvancedSetting(String settings, String setName) {
        if (settings.isEmpty() || setName.isEmpty()) {
            return false;
        }
        String settingName = setName.toLowerCase();
        String addvancedSettings = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + settings;
        SAXReader settingsReader = new SAXReader();
        Document settingsDoc = null;
        try {
            settingsReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            settingsReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            settingsReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            settingsDoc = settingsReader.read((Reader)new StringReader(addvancedSettings));
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (settingsDoc != null) {
            Element rootElem = settingsDoc.getRootElement();
            List nodes = rootElem.selectNodes("setting");
            for (Node node : nodes) {
                Element elem;
                String name;
                String nameLowCase;
                if (node.getNodeType() != 1 || !(nameLowCase = (name = (elem = (Element)node).attributeValue("name")).toLowerCase().trim()).equals(settingName)) continue;
                String value = elem.getText().toLowerCase().trim();
                if (value.equals(ADDVANCED_SETTING_VALUE1)) {
                    return true;
                }
                if (!value.equals(ADDVANCED_SETTING_VALUE2)) continue;
                return true;
            }
        }
        return false;
    }

    private String propertyFromGetMethod(String methodName) {
        String propertyName = null;
        if (methodName.indexOf("get") == 0) {
            propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        return propertyName;
    }

    private String getAndConvertFile(PersonalDataInfo infoPD) {
        try {
            File aFile;
            String sPDFileType = PersonalDataConvertor.getDefaultPDSType(infoPD.mSourcePath);
            PersonalDataGovernors myGovernor = new PersonalDataGovernors(this.mRequest.getParameter("m_passportID"), infoPD.mBaseModel);
            String sName = infoPD.mSourcePath;
            String OS = System.getProperty("os.name").toLowerCase();
            if (!OS.contains("windows")) {
                sName = sName.replace("\\\\", "/");
                sName = sName.replace('\\', '/');
            }
            if (!(aFile = new File(sName)).exists()) {
                return this.makeFault(infoPD);
            }
            long length = aFile.length();
            myGovernor.enforceMaxDataFileSize((int)length);
            FileInputStream stContent = new FileInputStream(aFile);
            PersonalDataConvertor myConvertor = PersonalDataConvertor.create(this.mRequest.getParameter("pds"), sPDFileType, this.getContext(), infoPD.mMetadata);
            Element elmDataset = myConvertor.convert(stContent);
            myGovernor.enforceMaxDataRowCount(elmDataset);
            String sSourceXML = elmDataset.asXML();
            if (sSourceXML == null || sSourceXML.length() == 0) {
                return this.makeFault(infoPD);
            }
            PersonalDataConvertor.persistInSession(this.getContentManagerServicePort(), this.mRequest.getParameter("pds"), sSourceXML);
            return sSourceXML;
        }
        catch (FileNotFoundException e) {
            return this.makeFault(infoPD);
        }
    }

    private String manipulateReportResult(String aResultPage, ArrayList<ArrayList<String>> metadataMap) {
        try {
            ByteArrayInputStream iStream = new ByteArrayInputStream(aResultPage.getBytes("UTF-8"));
            PersonalDataConvertor Convertor = PersonalDataConvertor.create("reportOutput", "XML", this.getContext(), metadataMap);
            Element elmRoot = Convertor.convert(iStream);
            return elmRoot.asXML();
        }
        catch (UnsupportedEncodingException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    private String reportExtract() {
        String sSourceXML = this.lookupSourceInSession();
        if (sSourceXML != null && sSourceXML.length() != 0) {
            return sSourceXML;
        }
        PersonalDataInfo infoPD = this.getDataSourceInfo();
        if (infoPD == null || infoPD.mSourcePath == null || infoPD.mSourcePath.length() == 0) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_MissingParameter, "dataSource/sourcePath");
        }
        ReportRunner myRunner = new ReportRunner(this.mRequest.getParameter("m_passportID"), this.mRequest.getParameter("contentLocale"));
        String[] outPages = myRunner.runReport(infoPD.mSourcePath);
        if (outPages == null || outPages.length == 0) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_FailedRunReport, infoPD.mSourcePath);
        }
        String outResult = this.manipulateReportResult(outPages[0], null);
        PersonalDataConvertor.persistInSession(this.getContentManagerServicePort(), this.mRequest.getParameter("pds"), outResult);
        return outResult;
    }

    private String makeFault(PersonalDataInfo infoPD) {
        Document document = DocumentHelper.createDocument();
        Element elmDataset = document.addElement("xd:dataset");
        elmDataset.addNamespace("xd", "http://developer.cognos.com/schemas/xmldata/1/");
        elmDataset.addNamespace("xs", "http://www.w3.org/2001/XMLSchema-instance");
        Element elmFault = elmDataset.addElement("xd:Fault");
        StringBuffer cData = new StringBuffer("<personalData><name value=\"");
        cData.append(MFWStringHelper.escapeXMLChars((String)this.mRequest.getParameter("pds")));
        cData.append("\"/><defaultPath value=\"");
        cData.append(MFWStringHelper.escapeXMLChars((String)infoPD.mSourcePath));
        cData.append("\"/><baseModelSearchPath value=\"");
        cData.append(XMLHelper.escapeXMLCharacters(infoPD.mBaseModel));
        cData.append("\"/></personalData>");
        elmFault.addCDATA(cData.toString());
        Element elmMD = elmDataset.addElement("xd:metadata");
        Element elmItem = elmMD.addElement("xd:item");
        elmItem.addAttribute("name", "dummy");
        elmItem.addAttribute("type", "xs:integer");
        elmDataset.addElement("xd:data");
        return elmDataset.asXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersonalDataInfo getDataSourceInfo() {
        String modelPath;
        PersonalDataInfo outInfo = new PersonalDataInfo();
        outInfo.mExternalPackage = modelPath = this.mRequest.getParameter("model");
        MFWRequestContext myReqContext = MFWRequestContext.create((String)"en", (String)"en", (String)this.mRequest.getParameter("m_passportID"));
        CommandGetData.addNoLWM2RequestContext(myReqContext);
        MFWMetadataSource myMDSource = MFWMetadataSource.create((String)"modelFM");
        myMDSource.addConnectionItem("cmSearchPath", (Object)modelPath);
        MFWModelRes gRes = MFWModelRes.getInstance();
        MFWGateway aGW = null;
        try {
            String sourceType;
            MFWQuerySpec dsQuerySpec;
            MFWNodeHandle[] hDataSrcs;
            outInfo = new PersonalDataInfo();
            aGW = MFWGateway.open((String)"XMLDataStream", (MFWRequestContext)myReqContext, (MFWMetadataSource)myMDSource);
            MFWQuerySpec baseQuerySpec = MFWQuerySpec.create((String)"/project/namespace[0]/property[name='personalDataBaseModel']");
            MFWNodeHandle[] hBase = aGW.query(baseQuerySpec);
            if (hBase.length > 0) {
                outInfo.mBaseModel = aGW.getObjectPropertyValue(hBase[0], gRes.RID__Value);
            }
            if ((hDataSrcs = aGW.query(dsQuerySpec = MFWQuerySpec.create((String)("/project/dataSource[name='" + this.mRequest.getParameter("pds") + "']")))).length > 0) {
                outInfo.mSourcePath = aGW.getObjectPropertyValue(hDataSrcs[0], gRes.getResourceID("sourcePath"));
                MFWNodeHandle[] hCustProps = aGW.queryObject(hDataSrcs[0], MFWQuerySpec.create((String)"property[name='directAccess']"));
                if (hCustProps.length > 0) {
                    outInfo.mAccessDirect = "true".equals(aGW.getObjectPropertyValue(hCustProps[0], gRes.RID__Value));
                }
            }
            if ((sourceType = this.mRequest.getParameter("st")).equals("s")) {
                ArrayList<String> externalNames = new ArrayList<String>();
                ArrayList<String> datatypes = new ArrayList<String>();
                ArrayList<String> precisions = new ArrayList<String>();
                ArrayList<String> scales = new ArrayList<String>();
                String pdsName = this.mRequest.getParameter("pds");
                String namespaceID = MFWCrnIDHelper.addEntryToID((String)"", (String)pdsName);
                MFWNodeHandle[] hQSAncestry = aGW.resolveCrnID(namespaceID);
                if (hQSAncestry.length > 0) {
                    MFWNodeHandle[] hMDDataScale;
                    MFWNodeHandle[] hMDDataPrecision;
                    MFWNodeHandle[] hMDDataTypes;
                    MFWNodeHandle[] hMDNames;
                    MFWNodeHandle ns = hQSAncestry[hQSAncestry.length - 1];
                    String nsName = aGW.getObjectPropertyValue(ns, MFWModelRes.getInstance().RID_ID);
                    for (MFWNodeHandle h : hMDNames = aGW.queryObject(ns, MFWQuerySpec.create((String)"querySubject[0]/queryItem/externalName"))) {
                        if (!h.isProperty()) continue;
                        String value = aGW.getPropertyValue(h);
                        externalNames.add(value);
                    }
                    for (MFWNodeHandle h : hMDDataTypes = aGW.queryObject(ns, MFWQuerySpec.create((String)"querySubject[0]/queryItem/datatype"))) {
                        if (!h.isProperty()) continue;
                        String value = aGW.getPropertyValue(h);
                        datatypes.add(value);
                    }
                    for (MFWNodeHandle h : hMDDataPrecision = aGW.queryObject(ns, MFWQuerySpec.create((String)"querySubject[0]/queryItem/precision"))) {
                        if (!h.isProperty()) continue;
                        String value = aGW.getPropertyValue(h);
                        precisions.add(value);
                    }
                    for (MFWNodeHandle h : hMDDataScale = aGW.queryObject(ns, MFWQuerySpec.create((String)"querySubject[0]/queryItem/scale"))) {
                        if (!h.isProperty()) continue;
                        String value = aGW.getPropertyValue(h);
                        scales.add(value);
                    }
                }
                if (externalNames.size() == datatypes.size()) {
                    for (int i = 0; i < externalNames.size(); ++i) {
                        ArrayList row = new ArrayList();
                        row.add(externalNames.get(i));
                        row.add(datatypes.get(i));
                        row.add(precisions.get(i));
                        row.add(scales.get(i));
                        outInfo.mMetadata.add(row);
                    }
                }
            }
        }
        finally {
            if (aGW != null) {
                aGW.close();
            }
        }
        return outInfo;
    }

    private ContentManagerService_PortType getContentManagerServicePort() {
        String sPassport = this.mRequest.getParameter("m_passportID");
        if (sPassport == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_MissingParameter, "m_passportID=CAMPAssport()");
        }
        try {
            CAMPassport pp = new CAMPassport();
            pp.setId(sPassport);
            CAM mycam = new CAM();
            mycam.setCAMPassport(pp);
            BiBusHeader header = new BiBusHeader();
            header.setCAM(mycam);
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType port = null;
            port = serviceLocator.getcontentManagerService(this.getDispatcherURL());
            ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            return port;
        }
        catch (ServiceException mue) {
            throw new RuntimeException(mue);
        }
    }

    private URL getDispatcherURL() {
        try {
            ICCLConfiguration x = CCLConfigurationFactory.getInstance();
            x.init();
            String value = x.getValue("internalDispatcher", false);
            return new URL(value);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        catch (CCLConfigurationException mue) {
            throw new RuntimeException(mue);
        }
    }

    private class PersonalDataInfo {
        String mBaseModel = null;
        String mSourcePath = null;
        boolean mAccessDirect = false;
        ArrayList<ArrayList<String>> mMetadata = new ArrayList();
        String mExternalPackage = null;

        private PersonalDataInfo() {
        }
    }
}

