/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.log;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.metadataService.util.misc.MDSRVVersionInfo;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import java.util.List;
import org.dom4j.Element;

public final class LogControl {
    private static LogTypedLogger AUDIT_LOGGER_UI_HANDLER = null;
    private static LogTypedLogger AUDIT_LOGGER_RTUSAGE_UI_HANDLER = null;
    private static LogTypedLogger TRACE_LOGGER_UI_HANDLER = null;
    private static LogControl M_INSTANCE = null;
    private static boolean ERROR_ON_INIT = false;

    public static LogControl GetInstance() {
        return M_INSTANCE;
    }

    private LogControl() {
    }

    public void uiHandlerStarted() {
    }

    public void uiHandlerDisposed() {
    }

    public void startRequestUIHandler(BIBusEnvelope request) {
        LogAuditIndication li2;
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Request", 30000, "", AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            String parametersXML = this.buildParametersValueForUIHandlerRequest(request);
            this.setLogData(parametersXML, (LogAuditIndication)li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
        if ((li2 = this.createLogAuditIndication("Request", request, 20000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER)) != null) {
            String requestBody = this.getSoapBody(request);
            this.setLogData(requestBody, li2);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li2);
        }
    }

    public void endRequestUIHandler(BIBusEnvelope response) {
        LogAuditIndication li2;
        String fault = response.getFaultCode();
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Response", 30000, fault != null ? "Failure" : "Success", AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            this.populateRequestParameters((LogAuditIndication)li, response);
            String parametersXML = this.buildParametersValueForUIHandlerRequest(response);
            this.setLogData(parametersXML, (LogAuditIndication)li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
        if ((li2 = this.createLogAuditIndication("Response", response, 20000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER)) != null) {
            String responseBody = this.getSoapBody(response);
            this.setLogData(responseBody, li2);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li2);
        }
    }

    public void runtimeError(Exception e, BIBusEnvelope envelope) {
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Execute", 50000, "Failure", AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer errors = new StringBuffer();
            errors.append("<messages><message><messageString>");
            errors.append(e.getMessage());
            errors.append("</messageString></message></messages>");
            li.setErrorMessage(errors.toString());
            this.populateRequestParameters((LogAuditIndication)li, envelope);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVRunSpec(BIBusEnvelope request, MetadataServiceLineageSpecification requestSpec, ParameterValue[] paramValues, Option[] options) {
        LogAuditIndication li = this.createLogAuditIndication("CallStart", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.runSpecification\">");
            params.append("<returnValue/>");
            this.appendParameters(params, (AsynchSpecification)requestSpec, paramValues);
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVRunSpecReply(BIBusEnvelope request, MetadataServiceLineageSpecification requestSpec, ParameterValue[] paramValues, Option[] options, AsynchReply reply) {
        LogAuditIndication li = this.createLogAuditIndication("CallEnd", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.runSpecification\">");
            params.append("<returnValue><![CDATA[");
            AsynchReplyStatusEnum res = reply.getStatus();
            params.append(res != null ? res.toString() : "null");
            params.append("]]</returnValue>");
            this.appendParameters(params, (AsynchSpecification)requestSpec, paramValues);
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVWait(BIBusEnvelope request, AsynchRequest primary, ParameterValue[] paramValues, Option[] options) {
        LogAuditIndication li = this.createLogAuditIndication("CallStart", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.wait\">");
            params.append("<returnValue/>");
            if (primary != null && primary.getSpecification() != null && primary.getSpecification().length > 0) {
                this.appendParameters(params, primary.getSpecification()[0], paramValues);
            }
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVWaitReply(BIBusEnvelope request, AsynchRequest primary, ParameterValue[] paramValues, Option[] options, AsynchReply reply) {
        LogAuditIndication li = this.createLogAuditIndication("CallEnd", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.wait\">");
            params.append("<returnValue><![CDATA[");
            AsynchReplyStatusEnum res = reply.getStatus();
            params.append(res != null ? res.toString() : "null");
            params.append("]]</returnValue>");
            if (primary != null && primary.getSpecification() != null && primary.getSpecification().length > 0) {
                this.appendParameters(params, primary.getSpecification()[0], paramValues);
            }
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVCancel(BIBusEnvelope request) {
        LogAuditIndication li = this.createLogAuditIndication("CallStart", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.cancel\">");
            params.append("</returnValue>");
            params.append("</parameters>");
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void logMDSRVCancelEnd(BIBusEnvelope request) {
        LogAuditIndication li = this.createLogAuditIndication("CallEnd", request, 10000, AUDIT_LOGGER_RTUSAGE_UI_HANDLER);
        if (li != null) {
            StringBuffer params = new StringBuffer();
            params.append("<function name=\"MetadataService_Port.cancel\">");
            params.append("</returnValue>");
            params.append("</parameters>");
            params.append("</function>");
            this.setLogData(params.toString(), li);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER.log((Object)li);
        }
    }

    public void unexpectedHandledException(String message, Throwable th) {
        LogTraceIndication li = this.createLogTraceIndication(50000, (byte)11, "");
        if (li != null) {
            StringBuffer res = new StringBuffer();
            res.append(message);
            res.append("\n");
            this.appendThrowable(res, th);
            li.setMessage(res.toString());
            TRACE_LOGGER_UI_HANDLER.log((Object)li);
        }
    }

    private LogTraceIndication createLogTraceIndication(int level, byte action, String message) {
        LogTraceIndication ind = null;
        if (!ERROR_ON_INIT && TRACE_LOGGER_UI_HANDLER.isEnabled(level)) {
            ind = new LogTraceIndication("MDSRV", MDSRVVersionInfo.getBuildNumber());
            ind.setAction(action);
            ind.setLevel(level);
            ind.setMessage(message);
        }
        return ind;
    }

    private void appendThrowable(StringBuffer out, Throwable th) {
        StackTraceElement[] st = th.getStackTrace();
        out.append(th.getMessage());
        out.append("\n");
        for (int i = 0; i < st.length; ++i) {
            out.append(st[i].toString());
            out.append("\n");
        }
    }

    private LogAuditAccessIndication createLogAuditAccessIndication(String operation, int level, String success, LogTypedLogger logger) {
        LogAuditAccessIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditAccessIndication("MDSRV", MDSRVVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            ind.setStatus(success);
        }
        return ind;
    }

    private LogAuditIndication createLogAuditIndication(String operation, BIBusEnvelope requestEnvelope, int level, LogTypedLogger logger) {
        LogAuditIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditIndication("MDSRV", MDSRVVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            this.populateRequestParameters(ind, requestEnvelope);
        }
        return ind;
    }

    private void populateRequestParameters(LogAuditIndication li, BIBusEnvelope requestEnvelope) {
        Element tracking;
        if (requestEnvelope != null && (tracking = requestEnvelope.getTracking()) != null) {
            Element sessionContextElement;
            Element requestContextElement = tracking.element("requestContext");
            if (requestContextElement != null) {
                li.setRequestID(requestContextElement.getText());
            }
            if ((sessionContextElement = tracking.element("sessionContext")) != null) {
                li.setSessionID(sessionContextElement.getText());
            }
        }
    }

    private String buildParametersValueForUIHandlerRequest(BIBusEnvelope request) {
        StringBuffer params = new StringBuffer();
        params.append("<parameters>");
        List pairs = request.getFormFieldValues();
        for (int i = 0; i < pairs.size(); ++i) {
            params.append("<item name=\"");
            NameValuePair np = (NameValuePair)pairs.get(i);
            params.append(np.getName());
            params.append("\"");
            params.append("<![CDATA[");
            params.append(np.getValue());
            params.append("]]</item>");
        }
        params.append("</parameters>");
        return params.toString();
    }

    private String getSoapBody(BIBusEnvelope envelope) {
        Element body = envelope.getBody();
        if (body != null) {
            return body.asXML();
        }
        return "";
    }

    private void appendParameters(StringBuffer params, AsynchSpecification requestSpec, ParameterValue[] paramValues) {
        params.append("<parameters>");
        for (int i = 0; i < paramValues.length; ++i) {
            params.append("<item name=\"");
            params.append(paramValues[i].getName());
            params.append("<![CDATA[");
            params.append(paramValues[i].getClass());
            params.append("]]></item>");
        }
        Specification spec = requestSpec.getValue();
        params.append("<item name=\"spec\"><![CDATA[");
        params.append(spec.get_value().toString());
        params.append("]]></item>");
        params.append("</parameters>");
    }

    private void setLogData(String data, LogAuditIndication li) {
        if (data != null) {
            data = data.replaceAll("(\n|\r)", "");
            data = data.replaceAll("\t", " ");
        }
        li.setLogData(data);
    }

    static {
        try {
            M_INSTANCE = new LogControl();
            AUDIT_LOGGER_UI_HANDLER = LogTypedLogger.getInstance((String)"Audit.MDSRV.UIHANDLER", LogAuditIndication.class);
            AUDIT_LOGGER_RTUSAGE_UI_HANDLER = LogTypedLogger.getInstance((String)"Audit.RTUsage.MDSRV.UIHANDLER", LogAuditIndication.class);
            TRACE_LOGGER_UI_HANDLER = LogTypedLogger.getInstance((String)"Trace.MDSRV.UIHANDLER", LogTraceIndication.class);
        }
        catch (Throwable th) {
            ERROR_ON_INIT = true;
            th.printStackTrace();
        }
    }
}

