/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.request;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.metadataService.ui.request.LineageUIParams;
import com.cognos.metadataService.ui.request.UIQueryItem;
import com.cognos.metadataService.ui.util.DOMUtil;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LineageUIParamsLineageRequest
extends LineageUIParams {
    public LineageUIParamsLineageRequest(String formFieldValue) {
        this.processLineageXML(formFieldValue);
    }

    protected void processLineageXML(String linageXML) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document d = builder.parse(new ByteArrayInputStream(linageXML.getBytes("UTF8")));
            Node lineageInfo = d.getFirstChild();
            for (Node currentChild = lineageInfo.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                StringBuffer buffer;
                if (!(currentChild instanceof Element)) continue;
                Element elem = (Element)currentChild;
                if ("reportPath".equals(elem.getTagName())) {
                    this.setModelType(1);
                    buffer = new StringBuffer();
                    DOMUtil.toString(elem, false, buffer);
                    this.setReportPath(buffer.toString());
                    continue;
                }
                if ("packagePath".equals(elem.getTagName())) {
                    this.setModelType(0);
                    buffer = new StringBuffer();
                    DOMUtil.toString(elem, false, buffer);
                    this.setPackagePath(buffer.toString());
                    continue;
                }
                if (!"item".equals(elem.getTagName())) continue;
                this.addItem(elem);
            }
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    private void addItem(Element elem) {
        StringBuffer buffer;
        String queryRef = elem.getAttribute("queryRef");
        int type = -1;
        String query = null;
        String queryItem = null;
        String objectId = null;
        if (queryRef != null && !"".equals(queryRef)) {
            type = 0;
            query = queryRef;
            buffer = new StringBuffer();
            DOMUtil.toString(elem, false, buffer);
            queryItem = buffer.toString();
        } else {
            buffer = new StringBuffer();
            DOMUtil.toString(elem, false, buffer);
            objectId = buffer.toString();
        }
        UIQueryItem uiItem = new UIQueryItem(type, query, queryItem, objectId);
        this.getQueryItems().addElement(uiItem);
    }
}

