/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.request;

import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.metadataService.ui.request.LineageUIParams;
import com.cognos.metadataService.ui.request.UIQueryItem;
import com.cognos.metadataService.ui.util.DOMUtil;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.xpath.DefaultXPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class LineageUIParamsSelectionContext
extends LineageUIParams {
    private MessageHelper m_messageHelper;

    public LineageUIParamsSelectionContext(String formFieldValue, MessageHelper helper) {
        this.m_messageHelper = helper;
        this.processSelectionContext(formFieldValue);
    }

    protected void processSelectionContext(String selectionContext) {
        Element root = DOMUtil.parse(selectionContext);
        String model = root.attributeValue("rModel");
        String selectedCells = root.attributeValue("rSelectedCells");
        if (selectedCells == null || "".equals(selectedCells)) {
            throw new UIException(this.m_messageHelper.getMessage("MSR_UI_ui_nometadata_in_selection"));
        }
        SimpleNamespaceContext context = new SimpleNamespaceContext();
        context.addNamespace("s", "http://developer.cognos.com/schemas/selection/1/");
        context.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        DefaultXPath path = new DefaultXPath("./*[local-name()='strings']/*[local-name()='s' and @xml:id='" + model + "']");
        String strpath = path.getText();
        Pattern p = Pattern.compile("(document|evaluate)\\s*\\(");
        Matcher m = p.matcher(strpath);
        if (m.find()) {
            throw new UIException(this.m_messageHelper.getMessage("MSR_LIN_MaliciousXPath"));
        }
        path.setNamespaceContext((NamespaceContext)context);
        Node node = path.selectSingleNode((Object)root);
        if (node != null) {
            String cmPath = node.getText();
            this.setReportPath(cmPath);
        }
        this.setModelType(1);
        StringTokenizer tokenizer = new StringTokenizer(selectedCells, " ");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            path = new DefaultXPath("./s:cells/s:cell[@xml:id='" + token + "']");
            path.setNamespaceContext((NamespaceContext)context);
            Node cell = path.selectSingleNode((Object)root);
            String metadataCellRef = ((Element)cell).attributeValue("rMetadataCell");
            path = new DefaultXPath("./s:metadataCells/s:metadataCell[@xml:id='" + metadataCellRef + "']");
            path.setNamespaceContext((NamespaceContext)context);
            Node metadataCell = path.selectSingleNode((Object)root);
            String queryItemNameRef = ((Element)metadataCell).attributeValue("rName");
            String query = ((Element)metadataCell).attributeValue("rQueryName");
            if (query == null) continue;
            path = new DefaultXPath("./*[local-name()='strings']/*[local-name()='s' and @xml:id='" + queryItemNameRef + "']");
            path.setNamespaceContext((NamespaceContext)context);
            Node stringNode = path.selectSingleNode((Object)root);
            String queryItemName = stringNode.getText();
            path = new DefaultXPath("./*[local-name()='strings']/*[local-name()='s' and @xml:id='" + query + "']");
            path.setNamespaceContext((NamespaceContext)context);
            Node sNode = path.selectSingleNode((Object)root);
            String queryName = sNode.getText();
            this.addItem(queryName, queryItemName);
        }
        if (this.getQueryItems().size() == 0) {
            path = new DefaultXPath("./s:cells/s:cell");
            List selNodes = path.selectNodes((Object)root);
            if (selNodes.size() > 1) {
                for (Node cell : selNodes) {
                    String metadataCellRef = ((Element)cell).attributeValue("rMetadataCell");
                    path = new DefaultXPath("./s:metadataCells/s:metadataCell[@xml:id='" + metadataCellRef + "']");
                    path.setNamespaceContext((NamespaceContext)context);
                    Node metadataCell = path.selectSingleNode((Object)root);
                    String queryItemNameRef = ((Element)metadataCell).attributeValue("rName");
                    String query = ((Element)metadataCell).attributeValue("rQueryName");
                    if (query == null) continue;
                    path = new DefaultXPath("./*[local-name()='strings']/*[local-name()='s' and @xml:id='" + queryItemNameRef + "']");
                    path.setNamespaceContext((NamespaceContext)context);
                    Node stringNode = path.selectSingleNode((Object)root);
                    String queryItemName = stringNode.getText();
                    path = new DefaultXPath("./*[local-name()='strings']/*[local-name()='s' and @xml:id='" + query + "']");
                    path.setNamespaceContext((NamespaceContext)context);
                    Node sNode = path.selectSingleNode((Object)root);
                    String queryName = sNode.getText();
                    this.addItem(queryName, queryItemName);
                }
            }
            if (this.getQueryItems().size() == 0) {
                throw new UIException(this.m_messageHelper.getMessage("MSR_UI_ui_nometadata_in_selection"));
            }
        }
    }

    private void addItem(String query, String queryItem) {
        UIQueryItem uiItem = new UIQueryItem(0, query, queryItem, null);
        this.getQueryItems().addElement(uiItem);
    }
}

