/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.request;

import com.cognos.cclcfgapi.base64;
import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.request.LineageUIParams;
import com.cognos.metadataService.ui.request.LineageUIParamsLineageRequest;
import com.cognos.metadataService.ui.request.LineageUIParamsSelectionContext;
import com.cognos.metadataService.ui.util.DOMUtil;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class UIRequestParams {
    public static final int LINEAGE_UI_REQUEST = 0;
    public static final int UNKNOWN_REQUEST = -1;
    public static final String META_ONLY = "meta-only";
    private int m_requestType = -1;
    private LineageUIParams m_lineageUIParam;
    private MessageHelper m_messageHelper;
    private String m_pid;
    private String m_fragDirective;
    private String m_executionParams;
    private Element m_elemQuerySet;
    private Element m_elemReportLineage;
    private String m_sQuerySet;
    private String m_sReportLineage;
    private String m_lineageRequest;
    private String m_selectionContext;
    private String m_sGateway;
    private String m_iis;
    private String m_sLaunchPoint = "direct";
    private Configuration m_configuration;

    public UIRequestParams(BIBusEnvelope envelope, MessageHelper messageHelper, Configuration config) {
        this.m_messageHelper = messageHelper;
        this.m_sGateway = envelope.getEnvironmentValue("SCRIPT_NAME");
        this.m_configuration = config;
        this.extractFormFieldParams(envelope);
    }

    public String getLineageRequest() {
        return this.m_lineageRequest;
    }

    public String getSelectionContext() {
        return this.m_selectionContext;
    }

    public String getGateway() {
        return this.m_sGateway;
    }

    public LineageUIParams getLineageUIParams() {
        return this.m_lineageUIParam;
    }

    protected int getRequestType() {
        return this.m_requestType;
    }

    public String getFragDirective() {
        return this.m_fragDirective;
    }

    public String getPid() {
        return this.m_pid;
    }

    public String getIIS() {
        return this.m_iis;
    }

    public String getLaunchPoint() {
        return this.m_sLaunchPoint;
    }

    public String getExecutionParams() {
        return this.m_executionParams;
    }

    public Element getReportLineageElem() {
        return this.m_elemReportLineage;
    }

    public String getReportLineageXml() {
        return this.m_sReportLineage;
    }

    public String getQuerySetXml() {
        return this.m_sQuerySet;
    }

    private void extractFormFieldParams(BIBusEnvelope envelope) {
        Element formFields;
        Element node = envelope.getFormFieldVars();
        if (node != null && (formFields = node) != null) {
            List items = formFields.selectNodes("item");
            for (int i = 0; i < items.size(); ++i) {
                Element elemItem = (Element)items.get(i);
                Node name = elemItem.selectSingleNode("name");
                Node value = elemItem.selectSingleNode("value");
                if (name == null || value == null) continue;
                String sNameValue = ((Element)name).getTextTrim();
                String sValueValue = ((Element)value).getTextTrim();
                if (sValueValue != null && sValueValue.startsWith("BASE64:")) {
                    String subStr = sValueValue.substring(7);
                    byte[] result = base64.decode((int)0, (String)subStr);
                    try {
                        sValueValue = new String(result, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("lineagerequest".equals(sNameValue)) {
                    this.m_lineageRequest = sValueValue;
                    this.m_lineageUIParam = new LineageUIParamsLineageRequest(sValueValue);
                    this.m_requestType = 0;
                    continue;
                }
                if ("selectioncontext".equals(sNameValue)) {
                    this.m_selectionContext = sValueValue;
                    this.m_lineageUIParam = new LineageUIParamsSelectionContext(sValueValue, this.m_messageHelper);
                    this.m_requestType = 0;
                    continue;
                }
                if ("pid".equals(sNameValue)) {
                    this.m_pid = sValueValue;
                    continue;
                }
                if ("frag-directive".equals(sNameValue)) {
                    this.m_fragDirective = sValueValue;
                    continue;
                }
                if ("executionParams".equals(sNameValue)) {
                    this.m_executionParams = sValueValue;
                    continue;
                }
                if ("querySet".equals(sNameValue)) {
                    this.m_sQuerySet = sValueValue;
                    continue;
                }
                if ("reportLineage".equals(sNameValue)) {
                    if (sValueValue == null) {
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("extractFormFieldParams: reportLineage param equals null !");
                        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "querySet");
                    }
                    try {
                        Element elemReportResponse = DOMUtil.parse(sValueValue);
                        String sRootElem = elemReportResponse.getName();
                        if (sRootElem.equals("lineageResponse")) {
                            this.m_elemReportLineage = elemItem;
                            this.m_sReportLineage = sValueValue;
                            continue;
                        }
                        if (!sRootElem.equals("reportLineageResponse")) continue;
                        this.m_elemQuerySet = elemReportResponse.element("querySet");
                        this.m_elemReportLineage = elemReportResponse.element("lineageResponse");
                        this.m_sQuerySet = this.m_elemQuerySet.asXML();
                        this.m_sReportLineage = this.m_elemReportLineage.asXML();
                        continue;
                    }
                    catch (Exception e) {
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("extractFormFieldParams: reportLineage param: " + e.getMessage());
                        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
                    }
                }
                if ("iis".equals(sNameValue)) {
                    if (sValueValue.indexOf(64) != -1) {
                        this.m_iis = this.getIISFromConfiguration();
                        String otherParams = sValueValue.substring(sValueValue.indexOf(64));
                        int iLaunchPoint = otherParams.indexOf("launchPoint=");
                        if (iLaunchPoint == -1) continue;
                        this.m_sLaunchPoint = otherParams.substring(iLaunchPoint + "launchPoint=".length());
                        continue;
                    }
                    this.m_iis = this.getIISFromConfiguration();
                    continue;
                }
                if (!"launchPoint".equals(sNameValue)) continue;
                this.m_sLaunchPoint = sValueValue;
            }
        }
        if (this.m_pid == null) {
            this.m_pid = "lineageMain";
        }
    }

    private String getIISFromConfiguration() {
        String configURL = this.m_configuration.getValue("metadataInformationURI");
        if (configURL.indexOf("iis=") != -1) {
            String url = configURL.substring(configURL.indexOf("iis=") + 4);
            int endOfURL = url.indexOf(38);
            if (endOfURL == -1) {
                return url;
            }
            return url.substring(0, endOfURL);
        }
        return null;
    }
}

