/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMUtil {
    public static org.dom4j.Element parse(String xml) {
        try {
            return DOMUtil.parse(new ByteArrayInputStream(xml.getBytes("UTF8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static org.dom4j.Element parse(InputStream stream) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document resultsDoc = saxReader.read(stream);
            return resultsDoc.getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static org.dom4j.Element toDOM4J(Element element) {
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(element.getOwnerDocument());
        return doc2.getRootElement();
    }

    public static String toStringViaJDOM(Element element) {
        try {
            DOMReader reader = new DOMReader();
            Document doc2 = reader.read(element.getOwnerDocument());
            return doc2.asXML();
        }
        catch (Exception e) {
            e.toString();
            return "";
        }
    }

    public static void toString(Element domElem, boolean includeSelf, StringBuffer buffer) {
        if (includeSelf) {
            buffer.append("<");
            buffer.append(domElem.getTagName());
            buffer.append(">");
        }
        for (Node child = domElem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text) {
                Text t = (Text)child;
                buffer.append(t.getNodeValue());
                continue;
            }
            if (!(child instanceof Element)) continue;
            DOMUtil.toString((Element)child, true, buffer);
        }
        if (includeSelf) {
            buffer.append("</");
            buffer.append(domElem.getTagName());
            buffer.append(">");
        }
    }
}

