/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.ui.util;

import com.cognos.mfw4j.utilities.MFWStringHelper;

public class EncodingUtility {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";

    public static String htmlencode(String value) {
        if (value != null) {
            int rsize = value.length() * 4;
            StringBuffer sbuf = new StringBuffer(rsize);
            block6: for (int i = 0; i < value.length(); ++i) {
                char x = value.charAt(i);
                switch (x) {
                    case '<': {
                        sbuf.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sbuf.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        sbuf.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        sbuf.append("&quot;");
                        continue block6;
                    }
                    default: {
                        sbuf.append(x);
                    }
                }
            }
            return sbuf.toString();
        }
        return "";
    }

    public static String escapeString(String str) {
        if (str != null) {
            str = str.replaceAll(SINGLE_QUOTE, "&apos;");
            str = str.replaceAll(DOUBLE_QUOTE, "&quot;");
            str = str.replaceAll("\n", " ");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = MFWStringHelper.replaceAll((String)str, (String)"\\", (String)"\\\\");
            return str;
        }
        return null;
    }

    public static String safeJavaScriptStringLiteral(String str) {
        if (str != null) {
            str = str.replace("\\", "\\\\");
            str = str.replace(SINGLE_QUOTE, "\\'");
            str = str.replace(DOUBLE_QUOTE, "\\\"");
            str = str.replace("<", "\\<");
            str = str.replace(">", "\\>");
            str = str.replace("/", "\\/");
            return str;
        }
        return null;
    }

    public static String encloseInQuotes(String str) {
        String quote = SINGLE_QUOTE;
        if (str.contains(SINGLE_QUOTE)) {
            quote = DOUBLE_QUOTE;
        }
        return quote + str + quote;
    }
}

