/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.misc.MDSRVLocaleUtils;
import com.cognos.metadataService.util.misc.MDSRVVersionInfo;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.dom4j.Element;

public final class MDSRVLogUtil {
    private static final String COMPONENT_NAME = "MDSRV";
    private static LogTypedLogger MDSRV_AUDIT_USAGE_LOGGER = null;
    private static LogTypedLogger MDSRV_TRACE_LOGGER = null;
    private static MDSRVLogUtil M_INSTANCE = null;
    private static boolean ERROR_ON_INIT = false;
    public static final int IPF_LEVEL_DEBUG = 10000;
    public static final int IPF_LEVEL_INFO = 20000;
    public static final int IPF_LEVEL_WARN = 30000;
    public static final int IPF_LEVEL_ERROR = 40000;
    public static final int IPF_LEVEL_FATAL = 50000;
    private static final String LOB = "LOB";
    private static final String TRACE_PREFIX = "Trace.MDSRV.";
    public static final String TRACE_MDSRV_LOB = "Trace.MDSRV.LOB";

    public static final MDSRVLogUtil getLogUtilInstance() {
        return M_INSTANCE;
    }

    private MDSRVLogUtil() {
    }

    public void startMDSRVRequest(BIBusEnvelope request) {
        LogAuditIndication li2;
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Request", 30000, "", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
        if ((li2 = this.createLogAuditIndication("Request", request, 20000, MDSRV_AUDIT_USAGE_LOGGER)) != null) {
            String requestBody = this.getSoapBody(request);
            this.setLogData(requestBody, li2);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li2);
        }
    }

    public void endMDSRVRequest(BIBusEnvelope response) {
        LogAuditIndication li2;
        if (response == null) {
            return;
        }
        String fault = response.getFaultCode();
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Response", 30000, fault != null ? "Failure" : "Success", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            this.populateRequestParameters((LogAuditIndication)li, response);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
        if ((li2 = this.createLogAuditIndication("Response", response, 20000, MDSRV_AUDIT_USAGE_LOGGER)) != null) {
            String responseBody = this.getSoapBody(response);
            this.setLogData(responseBody, li2);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li2);
        }
    }

    public void runtimeError(Throwable e, BIBusEnvelope envelope) {
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Execute", 50000, "Failure", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            StringBuffer errors = new StringBuffer();
            errors.append("<messages><message><messageString>");
            errors.append(e.getMessage());
            errors.append("</messageString></message></messages>");
            li.setErrorMessage(errors.toString());
            this.populateRequestParameters((LogAuditIndication)li, envelope);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
    }

    public void logExceptionsToAudit(Throwable e, MessageContext mc) {
        this.logExceptionsToAudit(e, 50000, mc);
    }

    public void logExceptionsToAudit(Throwable e, int level, MessageContext mc) {
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Execute", level, "Failure", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            StringBuffer sb = new StringBuffer(1024);
            while (e != null) {
                sb.append(MDSRVLocaleUtils.getErrorMessage(e, mc));
                sb.append("\n");
                StackTraceElement[] stack = e.getStackTrace();
                for (int i = 0; i < stack.length; ++i) {
                    sb.append(stack[i].toString());
                    sb.append("\n");
                }
                e = e.getCause();
            }
            li.setErrorMessage(sb.toString());
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
    }

    public void logTraceText(String sCategory, int nLevel, String sMsgText, Throwable ex, MessageContext mc) {
        LogTraceIndication li;
        LogTypedLogger TRACE_LOGGER = null;
        try {
            TRACE_LOGGER = LogTypedLogger.getInstance((String)sCategory, LogTraceIndication.class);
        }
        catch (Exception e) {
            this.logExceptionsToAudit(e, mc);
        }
        if (TRACE_LOGGER != null && TRACE_LOGGER.isEnabled(nLevel) && (li = new LogTraceIndication(COMPONENT_NAME, MDSRVVersionInfo.getBuildNumber())) != null) {
            li.setAction((byte)11);
            li.setLevel(nLevel);
            StringBuffer res = new StringBuffer();
            res.append(sMsgText);
            res.append("\n");
            if (ex != null) {
                this.appendThrowable(res, ex);
            }
            li.setMessage(res.toString());
            TRACE_LOGGER.log((Object)li);
        }
    }

    public void logAuditText(MDSRVErrorCode errCode, String[] args, MessageContext mc) {
        this.logAuditText(errCode, args, 50000, "Warning", mc);
    }

    public void logAuditText(MDSRVErrorCode errCode, String[] args, int level, String status, MessageContext mc) {
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Execute", level, status, MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            String sErrCode = errCode.getCode();
            String errMsg = MDSRVLocaleUtils.getErrorMessage(mc, sErrCode, args);
            li.setErrorMessage(errMsg);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
    }

    public void promptException(QFException qfException, BIBusEnvelope envelope) {
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Execute", 50000, "Failure", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            StringBuffer errors = new StringBuffer();
            errors.append("<messages><message><messageString>");
            errors.append(qfException.getMessage());
            errors.append("</messageString></message>");
            errors.append("<promptDom>");
            errors.append(qfException.getDOM().asXML());
            errors.append("</promptDom>");
            errors.append("</messages>");
            li.setErrorMessage(errors.toString());
            this.populateRequestParameters((LogAuditIndication)li, envelope);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
    }

    public boolean isMethodTraceEnabled() {
        return MDSRV_TRACE_LOGGER.isEnabled(20000);
    }

    public void methodStart(String method) {
        LogTraceIndication li = this.createLogTraceIndication(20000, (byte)5, method);
        MDSRV_TRACE_LOGGER.log((Object)li);
    }

    public void methodEnd(String method) {
        LogTraceIndication li = this.createLogTraceIndication(20000, (byte)6, method);
        if (li != null) {
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void rethrownException(String message, Throwable th) {
        LogTraceIndication li = this.createLogTraceIndication(50000, (byte)11, "");
        if (li != null) {
            StringBuffer res = new StringBuffer();
            res.append("Unhandled exception being rethrown: " + message);
            res.append("\n");
            this.appendThrowable(res, th);
            li.setMessage(res.toString());
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void unexpectedHandledException(String message, Throwable th) {
        LogTraceIndication li = this.createLogTraceIndication(50000, (byte)11, "");
        if (li != null) {
            StringBuffer res = new StringBuffer();
            res.append(message);
            res.append("\n");
            this.appendThrowable(res, th);
            li.setMessage(res.toString());
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void unexpectedSituation(String message) {
        LogTraceIndication li = this.createLogTraceIndication(40000, (byte)11, message);
        MDSRV_TRACE_LOGGER.log((Object)li);
    }

    public boolean isTraceInformativeEnabled() {
        return MDSRV_TRACE_LOGGER.isEnabled(10000);
    }

    public void traceInformative(String message) {
        LogTraceIndication li = this.createLogTraceIndication(10000, (byte)11, message);
        MDSRV_TRACE_LOGGER.log((Object)li);
    }

    public void logEnv() {
        if (this.isTraceInformativeEnabled()) {
            StringBuffer buf = new StringBuffer();
            String[] env = MDSRVLogUtil.getEnv();
            if (env != null) {
                for (int i = 0; i < env.length; ++i) {
                    buf.append("ENV VAR: ");
                    buf.append(env[i]);
                }
                this.traceInformative(buf.toString());
            }
        }
    }

    private LogAuditAccessIndication createLogAuditAccessIndication(String operation, int level, String success, LogTypedLogger logger) {
        LogAuditAccessIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditAccessIndication(COMPONENT_NAME, MDSRVVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            ind.setStatus(success);
        }
        return ind;
    }

    private LogAuditIndication createLogAuditIndication(String operation, BIBusEnvelope envelope, int level, LogTypedLogger logger) {
        LogAuditIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditIndication(COMPONENT_NAME, MDSRVVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            this.populateRequestParameters(ind, envelope);
        }
        return ind;
    }

    private static String[] getEnv() {
        String[] env = null;
        Process nativeProcess = null;
        try {
            nativeProcess = System.getProperty("os.name").startsWith("Windows") ? Runtime.getRuntime().exec("set") : Runtime.getRuntime().exec("env");
        }
        catch (Exception e) {
            return env;
        }
        if (nativeProcess == null) {
            return env;
        }
        String[] env1 = new String[100];
        int size = 0;
        try {
            BufferedReader aReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
            try {
                String line;
                while ((line = aReader.readLine()) != null && line.length() != 0) {
                    env1[size++] = line;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            aReader.close();
            nativeProcess.getErrorStream().close();
            env = new String[size];
            for (int i = 0; i < size; ++i) {
                env[i] = env1[i];
            }
        }
        catch (Exception e) {
            return env;
        }
        return env;
    }

    private LogTraceIndication createLogTraceIndication(int level, byte action, String message) {
        LogTraceIndication ind = null;
        if (!ERROR_ON_INIT && MDSRV_TRACE_LOGGER.isEnabled(level)) {
            ind = new LogTraceIndication(COMPONENT_NAME, MDSRVVersionInfo.getBuildNumber());
            ind.setAction(action);
            ind.setLevel(level);
            ind.setMessage(message);
        }
        return ind;
    }

    private void appendThrowable(StringBuffer out, Throwable th) {
        StackTraceElement[] st = th.getStackTrace();
        out.append(th.getMessage());
        out.append("\n");
        for (int i = 0; i < st.length; ++i) {
            out.append(st[i].toString());
            out.append("\n");
        }
    }

    private String getSoapBody(BIBusEnvelope envelope) {
        Element body = envelope.getBody();
        if (body != null) {
            return body.asXML();
        }
        return "";
    }

    private void setLogData(String data, LogAuditIndication li) {
        if (data != null) {
            data = data.replaceAll("(\n|\r)", "");
            data = data.replaceAll("\t", " ");
        }
        li.setLogData(data);
    }

    private void populateRequestParameters(LogAuditIndication li, BIBusEnvelope requestEnvelope) {
        Element tracking = requestEnvelope.getTracking();
        if (tracking != null) {
            Element sessionContextElement;
            Element requestContextElement = tracking.element("requestContext");
            if (requestContextElement != null) {
                li.setRequestID(requestContextElement.getText());
            }
            if ((sessionContextElement = tracking.element("sessionContext")) != null) {
                li.setSessionID(sessionContextElement.getText());
            }
        }
    }

    static {
        try {
            M_INSTANCE = new MDSRVLogUtil();
            MDSRV_AUDIT_USAGE_LOGGER = LogTypedLogger.getInstance((String)"Audit.RTUsage.MDSRV", LogAuditIndication.class);
            MDSRV_TRACE_LOGGER = LogTypedLogger.getInstance((String)"Trace.MDSRV", LogTraceIndication.class);
        }
        catch (Exception e) {
            ERROR_ON_INIT = true;
            e.printStackTrace();
        }
    }
}

