/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.logging;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.metadataService.util.misc.MDSRVVersionInfo;

public abstract class PerfMarker {
    private LogPerfIndication m_overallPerfIndication = null;
    private CCLResourceCounterSet m_overallCntSet = null;
    private LogTypedLogger m_logger = null;

    public PerfMarker(String message, String status, LogTypedLogger logger) {
        this.m_logger = logger;
        this.startPerf(status, 10000, message);
    }

    public PerfMarker(String message, LogTypedLogger logger) {
        this(message, "BEGIN", logger);
        this.m_logger = logger;
    }

    public void endPerf(String message) {
        this.endPerf(message, "FINISH");
    }

    protected String getStatus() {
        return this.m_overallPerfIndication.getStatus();
    }

    protected void endPerf(String message, String status) {
        boolean isEnabled = this.isEnabled();
        if (isEnabled) {
            this.m_overallCntSet.disableResourceCounter();
            this.m_overallPerfIndication.setLogData(message);
            this.m_overallPerfIndication.setStatus(status);
            this.m_logger.log((Object)this.m_overallPerfIndication);
        }
    }

    protected boolean isEnabled() {
        return this.m_overallPerfIndication != null && this.m_logger.isEnabled(this.m_overallPerfIndication.getLevel());
    }

    private void startPerf(String status, int level, String message) {
        if (this.m_logger.isEnabled(level)) {
            this.m_overallCntSet = new CCLResourceCounterSet("Execution", null);
            this.m_overallPerfIndication = new LogPerfIndication("MDSRV", MDSRVVersionInfo.getBuildNumber(), this.m_overallCntSet);
            this.m_overallPerfIndication.setLevel(level);
            this.m_overallPerfIndication.setLogData(message);
            this.m_overallPerfIndication.setStatus(status);
            this.m_overallCntSet.enableResourceCounter();
            this.m_logger.log((Object)this.m_overallPerfIndication);
        }
    }
}

