/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.misc;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import javax.xml.namespace.QName;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.dom4j.Element;

public class AxisTypesHelper {
    public static String getBIBusObjectTypeName(String objectTypeName) {
        return BIBusEnvelope.NS_BUS.getPrefix() + ":" + objectTypeName;
    }

    public static String getBIBusPropValueTypeName(Class<?> axisClientBaseProp) {
        TypeDesc propTypeDesc = TypeDesc.getTypeDescForClass(axisClientBaseProp);
        FieldDesc propValueTypeDesc = propTypeDesc.getFieldByName("value");
        return BIBusEnvelope.NS_BUS.getPrefix() + ":" + propValueTypeDesc.getXmlType().getLocalPart();
    }

    public static String getXsdPropValueTypeName(Class<?> axisClientBaseProp) {
        TypeDesc propTypeDesc = TypeDesc.getTypeDescForClass(axisClientBaseProp);
        FieldDesc propValueTypeDesc = propTypeDesc.getFieldByName("value");
        return "xsd:" + propValueTypeDesc.getXmlType().getLocalPart();
    }

    public static QName getOMClassType(Class<?> axisClientClass) {
        return TypeDesc.getTypeDescForClass(axisClientClass).getXmlType();
    }

    public static String getOMClassTypeName(Class<?> axisClientClass) {
        return TypeDesc.getTypeDescForClass(axisClientClass).getXmlType().getLocalPart();
    }

    public static Element addBIBusResponseElem(Element parentElem, org.dom4j.QName elemName, String type) {
        Element elem = parentElem.addElement(elemName);
        elem.addAttribute(SOAPEnvelope.XSI_TYPE, AxisTypesHelper.getBIBusObjectTypeName(type));
        return elem;
    }

    public static Element addBIBusResponseElem(Element parentElem, String elemName, String type) {
        Element elem = parentElem.addElement(elemName);
        elem.addAttribute(SOAPEnvelope.XSI_TYPE, AxisTypesHelper.getBIBusObjectTypeName(type));
        return elem;
    }

    public static Element addResponseElem(Element parentElem, String elemName, String type) {
        Element elem = parentElem.addElement(elemName);
        elem.addAttribute(SOAPEnvelope.XSI_TYPE, type);
        return elem;
    }

    public static Element addBIBusResponseElem(Element parentElem, Class<?> axisClientClassBaseType, Class<?> axisClientClass) {
        return AxisTypesHelper.addBIBusResponseElem(parentElem, AxisTypesHelper.getOMClassTypeName(axisClientClassBaseType), AxisTypesHelper.getBIBusObjectTypeName(AxisTypesHelper.getOMClassTypeName(axisClientClass)));
    }
}

