/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.misc;

import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LocalizedStrings {
    private static final String BUNDLENAME = "mdsrv";
    Locale m_locale;
    ResourceBundle m_bundle;
    Pattern aposRegex = Pattern.compile("(?<!')'(?!')");
    public static final String SECTION_OBJECTMODEL = "MSR_OM_";
    public static final String SECTION_AUTHOREDREPORT = "MSR_AU_";

    public LocalizedStrings(String localeStr) {
        this.initLocale(localeStr);
        this.m_bundle = ResourceBundle.getBundle(BUNDLENAME, this.m_locale);
    }

    private void initLocale(String localeStr) {
        String[] localeParts = localeStr.split("-|_");
        if (localeParts.length == 1) {
            this.m_locale = new Locale(localeParts[0]);
        } else if (localeParts.length > 1) {
            this.m_locale = new Locale(localeParts[0], localeParts[1]);
        } else {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("got strange locale: " + localeStr + ". Using 'en'");
            this.m_locale = new Locale("en");
        }
    }

    public LocalizedStrings(String localeStr, String bundleName) {
        this.initLocale(localeStr);
        this.m_bundle = ResourceBundle.getBundle(bundleName, this.m_locale);
    }

    public ResourceBundle getBundle() {
        return this.m_bundle;
    }

    public String getLocalizedValue(String key) {
        return this.getLocalizedValue(key, null);
    }

    public String getLocalizedValue(String key, Object[] arguments) {
        String localizedMessage = null;
        try {
            localizedMessage = this.m_bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return mre.getMessage();
        }
        if (arguments != null && arguments.length > 0) {
            Matcher match = this.aposRegex.matcher(localizedMessage);
            localizedMessage = match.replaceAll("''");
            localizedMessage = MessageFormat.format(localizedMessage, arguments);
        }
        return localizedMessage;
    }
}

