/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.misc;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.axis.message.RPCElement;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;

public class MDSRVBIBusCommand
extends BIBusCommand
implements MetadataService_PortType {
    private static MDSRVBIBusCommand request = new MDSRVBIBusCommand();
    private static String serviceName = null;
    private static String searchPath = "/content/package[@name='Sales']";
    private static String requestContext = null;
    private String affinity = null;
    private Element headerElement = null;
    private Element primaryRequestElement = null;
    private Element conversationElement = null;
    private ConnectionPool serviceConnectionPool = new ConnectionPool("localhost", 9300, false, 0);
    private static final String TRACKING = "tracking";
    private static final String REQUEST_CONTEXT = "requestContext";
    private static final String PRIMARY_REQUEST = "primaryRequest";
    private static final String PRIMARY_WAIT_THRESHOLD = "primaryWaitThreshold";
    private static final String SECONDARY_WAIT_THRESHOLD = "secondaryWaitThreshold";
    private static final String HOST = "localhost";
    private static final int PORT = 9300;
    private static final String DEFAULT_PRIMARY_WAIT_THRESHOLD = "7";
    private static final String DEFAULT_SECONDARY_WAIT_THRESHOLD = "30";
    private static final QName RUN_REQUEST = DocumentHelper.createQName((String)"run");
    private static final QName RUNSPECIFICATION_REQUEST = DocumentHelper.createQName((String)"runSpecification");
    private static final QName CANCEL_REQUEST = DocumentHelper.createQName((String)"cancel");
    private static final QName WAIT_REQUEST = DocumentHelper.createQName((String)"wait");
    private static final QName OBJECT_PATH = DocumentHelper.createQName((String)"objectPath");
    private static final QName BUS_SEARCH_PATH_SINGLE_OBJECT = DocumentHelper.createQName((String)"searchPathSingleObject", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName OPTION = DocumentHelper.createQName((String)"option");
    private static final QName NAME = DocumentHelper.createQName((String)"name");
    private static final QName VALUE = DocumentHelper.createQName((String)"value");
    private static final QName OPTIONS = DocumentHelper.createQName((String)"options");
    private static final QName PARAMETER_VALUE = DocumentHelper.createQName((String)"parameterValue");
    private static final QName PARAMETER_VALUES = DocumentHelper.createQName((String)"parameterValues");
    private static final QName CONVERSATION = DocumentHelper.createQName((String)"conversation");
    private static final QName BUS_ASYNC_REQUEST = DocumentHelper.createQName((String)"asynchRequest", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_OPTION_INT = DocumentHelper.createQName((String)"asynchOptionInt", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_OPTION_ENUM = DocumentHelper.createQName((String)"asynchOptionEnum", (Namespace)BIBusEnvelope.NS_BUS);

    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
    }

    protected String fetchRequestContext() {
        return "/p2pd/servlet/dispatch";
    }

    protected ServerConnection fetchServerConnection() {
        ServerConnection connection = this.serviceConnectionPool.getConnection();
        if (this.affinity.length() > 0) {
            connection.addRequestHeader("SOAPAction", "http://developer.cognos.com/schemas/" + serviceName + "/1." + this.affinity);
        } else {
            connection.addRequestHeader("SOAPAction", "http://developer.cognos.com/schemas/" + serviceName + "/1");
        }
        return connection;
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
    }

    private void cacheHeaderInfo(BIBusEnvelope envelope) {
        Element ele;
        int i;
        if (this.headerElement != null) {
            this.headerElement.detach();
        }
        this.headerElement = envelope.getBIBusHeader().createCopy();
        Element tracking = null;
        List bodyContent = this.headerElement.content();
        for (i = 0; i < bodyContent.size(); ++i) {
            if (!(bodyContent.get(i) instanceof Element) || (ele = (Element)bodyContent.get(i)).getName().compareTo(TRACKING) != 0) continue;
            tracking = ele;
            break;
        }
        if (tracking != null) {
            bodyContent = tracking.content();
            for (i = 0; i < bodyContent.size(); ++i) {
                if (!(bodyContent.get(i) instanceof Element) || (ele = (Element)bodyContent.get(i)).getName().compareTo(REQUEST_CONTEXT) != 0) continue;
                requestContext = ele.getText();
                break;
            }
        }
    }

    private void cachePrimaryRequestInfo(BIBusEnvelope envelope) {
        Element requestBody = envelope.getBody();
        List bodyContent = requestBody.content();
        for (int i = 0; i < bodyContent.size(); ++i) {
            Element ele;
            if (!(bodyContent.get(i) instanceof Element) || (ele = (Element)bodyContent.get(i)).getName().compareTo(PRIMARY_REQUEST) != 0) continue;
            this.primaryRequestElement = ele.createCopy();
            break;
        }
        if (this.primaryRequestElement != null) {
            if (this.conversationElement != null) {
                this.conversationElement.detach();
            }
            this.conversationElement = this.primaryRequestElement.createCopy(CONVERSATION);
        }
    }

    private String runRequest() throws CommandExecutionException {
        BIBusEnvelope request = this.getRequestEnvelope();
        Element runRequest = request.getBody().addElement(RUN_REQUEST);
        runRequest.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
        Element objectPath = runRequest.addElement(OBJECT_PATH);
        objectPath.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_SEARCH_PATH_SINGLE_OBJECT.getQualifiedName());
        objectPath.setText(searchPath);
        Element paramsElement = runRequest.addElement(PARAMETER_VALUES);
        paramsElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        paramsElement.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, PARAMETER_VALUE.getQualifiedName() + "[0]");
        Element optionsElement = runRequest.addElement(OPTIONS);
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, OPTION.getQualifiedName() + "[1]");
        Element primaryWaitThreshold = optionsElement.addElement(OPTION);
        primaryWaitThreshold.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_INT.getQualifiedName());
        Element name = primaryWaitThreshold.addElement(NAME);
        name.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_ENUM.getQualifiedName());
        name.setText(PRIMARY_WAIT_THRESHOLD);
        Element value = primaryWaitThreshold.addElement(VALUE);
        value.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        value.setText(DEFAULT_PRIMARY_WAIT_THRESHOLD);
        this.affinity = "";
        this.execute();
        runRequest.detach();
        BIBusEnvelope response = this.getResponseEnvelope();
        this.cacheHeaderInfo(response);
        this.cachePrimaryRequestInfo(response);
        String status = response.getConversationContextStatus();
        if (status == null) {
            status = "conversationComplete";
        }
        return status;
    }

    String runSpecificationRequest() throws CommandExecutionException {
        BIBusEnvelope request = this.getRequestEnvelope();
        Element runRequest = request.getBody().addElement(RUNSPECIFICATION_REQUEST);
        runRequest.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
        Element paramsElement = runRequest.addElement(PARAMETER_VALUES);
        paramsElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        paramsElement.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, PARAMETER_VALUE.getQualifiedName() + "[0]");
        Element optionsElement = runRequest.addElement(OPTIONS);
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, OPTION.getQualifiedName() + "[1]");
        Element primaryWaitThreshold = optionsElement.addElement(OPTION);
        primaryWaitThreshold.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_INT.getQualifiedName());
        Element name = primaryWaitThreshold.addElement(NAME);
        name.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_ENUM.getQualifiedName());
        name.setText(PRIMARY_WAIT_THRESHOLD);
        Element value = primaryWaitThreshold.addElement(VALUE);
        value.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        value.setText(DEFAULT_PRIMARY_WAIT_THRESHOLD);
        this.affinity = "";
        this.execute();
        runRequest.detach();
        BIBusEnvelope response = this.getResponseEnvelope();
        this.cacheHeaderInfo(response);
        this.cachePrimaryRequestInfo(response);
        String status = response.getConversationContextStatus();
        if (status == null) {
            status = "conversationComplete";
        }
        return status;
    }

    String cancelRequest() throws CommandExecutionException {
        BIBusEnvelope request = this.getRequestEnvelope();
        Element ele = request.getBIBusHeader();
        ele.detach();
        request.setBIBusHeader(this.headerElement);
        List bodyContent = request.getBody().content();
        for (int i = 0; i < bodyContent.size(); ++i) {
            if (!(bodyContent.get(i) instanceof Element) || (ele = (Element)bodyContent.get(i)).getName().compareTo(WAIT_REQUEST.getName()) != 0) continue;
            ele.detach();
            break;
        }
        Element cancelRequest = request.getBody().addElement(CANCEL_REQUEST);
        this.affinity = "";
        this.execute();
        cancelRequest.detach();
        this.headerElement = null;
        this.primaryRequestElement = null;
        BIBusEnvelope response = this.getResponseEnvelope();
        String status = response.getConversationContextStatus();
        if (status == null) {
            status = "conversationComplete";
        }
        return status;
    }

    private String waitForResponse() throws CommandExecutionException {
        BIBusEnvelope request = this.getRequestEnvelope();
        Element ele = request.getBIBusHeader();
        ele.detach();
        request.setBIBusHeader(this.headerElement);
        Element waitRequest = request.getBody().addElement(WAIT_REQUEST);
        waitRequest.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REQUEST.getQualifiedName());
        Element paramsElement = waitRequest.addElement(PARAMETER_VALUES);
        paramsElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        paramsElement.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, PARAMETER_VALUE.getQualifiedName() + "[0]");
        Element optionsElement = waitRequest.addElement(OPTIONS);
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, OPTION.getQualifiedName() + "[1]");
        Element secondaryWaitThreshold = optionsElement.addElement(OPTION);
        secondaryWaitThreshold.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_INT.getQualifiedName());
        Element name = secondaryWaitThreshold.addElement(NAME);
        name.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNC_OPTION_ENUM.getQualifiedName());
        name.setText(SECONDARY_WAIT_THRESHOLD);
        Element value = secondaryWaitThreshold.addElement(VALUE);
        value.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        value.setText(DEFAULT_SECONDARY_WAIT_THRESHOLD);
        this.affinity = "absolute";
        this.execute();
        waitRequest.detach();
        BIBusEnvelope response = this.getResponseEnvelope();
        this.cacheHeaderInfo(response);
        this.cachePrimaryRequestInfo(response);
        String status = this.getResponseEnvelope().getConversationContextStatus();
        return status;
    }

    public static void main(String[] args) {
        try {
            SAXReaderPool.prepare((boolean)false, (int)0);
            serviceName = args[0];
            if (serviceName == null || serviceName.length() == 0) {
                return;
            }
            if (args.length == 2) {
                searchPath = args[1];
            }
            String status = request.runRequest();
            while (status.compareTo("complete") != 0 && status.compareTo("conversationComplete") != 0) {
                status = request.waitForResponse();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void cancel(AsynchRequest conversation) throws RemoteException {
    }

    public XmlEncodedXML queryMetadata(XmlEncodedXML request) throws RemoteException {
        return null;
    }

    public void release(AsynchRequest conversation) throws RemoteException {
    }

    public AsynchReply run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return null;
    }

    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        BIBusEnvelope request = this.getRequestEnvelope();
        Element runRequest = request.getBody();
        Element domElem = this.toRequestElem(specification, parameterValues, options);
        runRequest.add(domElem);
        try {
            this.execute();
        }
        catch (CommandExecutionException e) {
            throw new RemoteException("CommandExecutionException occurred", e);
        }
        runRequest.detach();
        BIBusEnvelope response = this.getResponseEnvelope();
        this.cacheHeaderInfo(response);
        this.cachePrimaryRequestInfo(response);
        String status = response.getConversationContextStatus();
        if (status == null) {
            status = "conversationComplete";
        }
        return new AsynchReply();
    }

    private Element toRequestElem(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        Object[] args = new Object[]{specification, parameterValues, options};
        Namespace serviceNamespace = new Namespace("mds", "http://developer.cognos.com/schemas/metadataService/1");
        QName commandName = new QName("runSpecification", serviceNamespace);
        Element domElem = null;
        try {
            RPCElement callElem = new RPCElement(commandName.getNamespaceURI(), commandName.getName(), args);
            org.w3c.dom.Document w3cDom = callElem.getAsDocument();
            DOMReader w3cDomReader = new DOMReader();
            Document dom4jDoc = w3cDomReader.read(w3cDom);
            domElem = dom4jDoc.getRootElement();
            domElem.detach();
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred when serializing the request", e);
        }
        return domElem;
    }

    public void testDataSourceConnection(String connectionString, XmlEncodedXML credentials) throws RemoteException {
    }

    public XmlEncodedXML updateMetadata(XmlEncodedXML request) throws RemoteException {
        return null;
    }

    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return null;
    }

    public static String getRequestContext() {
        return requestContext;
    }
}

