/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.misc;

import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.misc.LocalizedStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.CROneCookie;

public final class MDSRVLocaleUtils {
    public static String getUnknownErrorException(MessageContext context) {
        LocalizedStrings localizedStrings = new LocalizedStrings(MDSRVLocaleUtils.getLocale(context));
        String errorMsg = localizedStrings.getLocalizedValue("MSR_UI_ui_unknown_error");
        return errorMsg;
    }

    public static String getErrorMessage(Throwable e, MessageContext mc) {
        String errMsg = null;
        if (e instanceof MDSRVException) {
            String sErrCode = e.getMessage();
            String[] args = (String[])((MDSRVException)e).getArgs();
            errMsg = MDSRVLocaleUtils.getErrorMessage(mc, sErrCode, args);
        } else {
            errMsg = e.getLocalizedMessage();
        }
        return errMsg;
    }

    public static String getErrorMessage(MessageContext context, String errCode) {
        return MDSRVLocaleUtils.getErrorMessage(context, errCode, null);
    }

    public static String getErrorMessage(MessageContext context, String errCode, String[] args) {
        LocalizedStrings localizedStrings = new LocalizedStrings(MDSRVLocaleUtils.getLocale(context));
        String errorMsg = localizedStrings.getLocalizedValue(errCode, args);
        return errorMsg;
    }

    public static String getLocale(MessageContext context) {
        CROneCookie crnCookie;
        Object productLocale;
        if (context == null) {
            return "en";
        }
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)context.getProperty("request.envelope");
        String cookieValue = requestEnvelope.getCookieValue("CRN");
        if (cookieValue != null && cookieValue != "" && (productLocale = (crnCookie = new CROneCookie(cookieValue)).getPreferences().get("productLocale")) != null) {
            return productLocale.toString();
        }
        return "en";
    }
}

