/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.util.misc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class TypeSafeEnumBase
implements Comparable<TypeSafeEnumBase> {
    protected final String m_stringValue;
    protected final int m_intValue;

    protected TypeSafeEnumBase(String stringValue, int intValue) {
        this.m_stringValue = stringValue;
        this.m_intValue = intValue;
    }

    public String toString() {
        return String.valueOf(this.m_intValue);
    }

    public int hashCode() {
        return this.m_intValue;
    }

    public String getStringValue() {
        return this.m_stringValue;
    }

    @Override
    public int compareTo(TypeSafeEnumBase other) {
        int result = 0;
        int otherIntValue = other.m_intValue;
        if (this.m_intValue < otherIntValue) {
            result = -1;
        } else if (this.m_intValue > otherIntValue) {
            result = -1;
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        if (other instanceof TypeSafeEnumBase) {
            equals = this.compareTo((TypeSafeEnumBase)other) == 0;
        }
        return equals;
    }

    protected static TypeSafeEnumBase loadFromValue(String stringValue, String typeSafeEnumBaseSubclassName) {
        TypeSafeEnumBase enumObj = null;
        try {
            Class<?> typeSafeEnumBaseSubclass = Class.forName(typeSafeEnumBaseSubclassName);
            Field[] fields = typeSafeEnumBaseSubclass.getFields();
            for (int fieldsIdx = 0; enumObj == null && fieldsIdx < fields.length; ++fieldsIdx) {
                TypeSafeEnumBase currentEnumObj;
                int modifier;
                Field field = fields[fieldsIdx];
                if (!field.getDeclaringClass().equals(typeSafeEnumBaseSubclass) || !Modifier.isStatic(modifier = field.getModifiers()) || !Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !(currentEnumObj = (TypeSafeEnumBase)field.get(null)).getStringValue().equals(stringValue)) continue;
                enumObj = currentEnumObj;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            enumObj = null;
        }
        catch (IllegalAccessException e) {
            enumObj = null;
        }
        return enumObj;
    }
}

