/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;

public class MFWActionLogHelper {
    public static final short ObjectQueryType_queryTypeXPath = 0;
    public static final short ObjectQueryType_queryTypeRidName = 1;
    public static final short ObjectQueryType_queryTypeAllChildren = 3;
    public static final String QUERY_TYPE_XPATH = "xPath";
    public static final String QUERY_TYPE_RIDNAME = "ridName";
    public static final String QUERY_TYPE_ALL_CHILDREN = "allChildren";
    public static final String QUERY_TYPE = "queryType";
    public static final String GATEWAY_CLOSE = "gatewayclose";
    public static final String CLUSTER_QUERY = "clusterQuery";
    public static final String OBJECT_QUERY = "objectQuery";
    public static final String GATEWAYCONNECTION = "gatewayconnection";
    public static final String GET_PROPERTY_VALUE = "getPropertyValue";
    public static final String FIND_CHILD_OBJECTS = "findChildObjects";
    public static final String QUERY_PROPERTY = "queryProperty";
    public static final String QUERY_PROPERTIES = "queryProperties";
    public static final String METADATASOURCE_QUERY = "mfwMetadataSourceQuery";
    public static final String API_TYPE = "apiType";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String ENUM = "enum";
    public static final String OBJECT = "object";
    public static final String RID = "rid";
    public static final String VALUE = "value";
    public static final String CHILD_OBJ_NAME = "childObjName";
    public static final String PROP_NAME = "propName";
    public static final String PROP_VALUE = "propValue";
    public static final String THREAD_ID = "threadid";
    public static final String GATEWAY_ID = "gatewayid";
    public static final String RESULT_SET = "resultSet";
    public static final String METADATASOURCE = "metadatasource";
    public static final String RESOLVE_CRN_ID = "resolveCrnID";
    public static final String CRNID = "crnId";
    public static final short PropertyQueryType_string = 0;
    public static final short PropertyQueryType_boolean = 1;
    public static final short PropertyQueryType_enum = 2;

    private static String GetThreadId() {
        return Thread.currentThread().getName() + Thread.currentThread().hashCode();
    }

    public static void GetXMLRepresentationForMetadataSource(MFWMetadataSource aMetadataSrc, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(METADATASOURCE, 0);
        xmlRepresentation.addAttribute("type", aMetadataSrc.getType());
        xmlRepresentation.endElement(false);
        MFWActionLogHelper.getXMLRepresentationForMetadataSourceEntries(aMetadataSrc, xmlRepresentation);
        xmlRepresentation.addElement(METADATASOURCE, 2);
    }

    private static void getXMLRepresentationForMetadataSourceEntries(MFWMetadataSource aMetadataSrc, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement("connectInfo", 1);
        for (String name : aMetadataSrc.getConnectionInfo().keySet()) {
            xmlRepresentation.addElement("pair", 1);
            xmlRepresentation.addElement("name", 1);
            xmlRepresentation.addText(name);
            xmlRepresentation.addElement("name", 2);
            xmlRepresentation.addElement(VALUE, 1);
            xmlRepresentation.addText(aMetadataSrc.getConnectionItem(name).toString());
            xmlRepresentation.addElement(VALUE, 2);
            xmlRepresentation.addElement("pair", 2);
        }
        xmlRepresentation.addElement("connectInfo", 2);
        Iterator<String> scopes = aMetadataSrc.getScopeInfo().keySet().iterator();
        xmlRepresentation.addElement("scopes", 1);
        while (scopes.hasNext()) {
            String name = scopes.next();
            xmlRepresentation.addElement("pair", 1);
            xmlRepresentation.addElement("name", 1);
            xmlRepresentation.addText(name);
            xmlRepresentation.addElement("name", 2);
            xmlRepresentation.addElement(VALUE, 1);
            xmlRepresentation.addText(aMetadataSrc.getScope(name).toString());
            xmlRepresentation.addElement(VALUE, 2);
            xmlRepresentation.addElement("pair", 2);
        }
        xmlRepresentation.addElement("scopes", 2);
        Iterator<String> signon = aMetadataSrc.getSignonInfo().keySet().iterator();
        xmlRepresentation.addElement("signons", 1);
        while (signon.hasNext()) {
            String name = signon.next();
            xmlRepresentation.addElement("pair", 1);
            xmlRepresentation.addElement("name", 1);
            xmlRepresentation.addText(name);
            xmlRepresentation.addElement("name", 2);
            xmlRepresentation.addElement(VALUE, 1);
            xmlRepresentation.addText(aMetadataSrc.getSignon(name).toString());
            xmlRepresentation.addElement(VALUE, 2);
            xmlRepresentation.addElement("pair", 2);
        }
        xmlRepresentation.addElement("signons", 2);
    }

    public static void GetXMLRepresentationForGatewayDeletion(String gatewayID, MFWXMLDump xmlRepr) {
        xmlRepr.addElement(GATEWAY_CLOSE, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepr.addAttribute(THREAD_ID, threadID);
        xmlRepr.addAttribute(GATEWAY_ID, gatewayID);
        xmlRepr.endElement(false);
        xmlRepr.addElement(GATEWAY_CLOSE, 2);
    }

    public static void GetXMLRepresentationForGatewayCreation(String gatewayID, MFWRequestContext aContext, MFWMetadataSource aMetadataSrc, String failureReason, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(GATEWAYCONNECTION, 0);
        String threadID = Thread.currentThread().getName() + Thread.currentThread().hashCode();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute("type", aMetadataSrc.getType());
        xmlRepresentation.addAttribute(GATEWAY_ID, gatewayID);
        xmlRepresentation.addAttribute("productLocale", aContext.getProductLocale());
        xmlRepresentation.addAttribute("contentLocale", aContext.getContentLocale());
        xmlRepresentation.addAttribute("userName", "");
        if (aContext.getUserPassport() != null) {
            CRC32 myCRC = new CRC32();
            myCRC.update(aContext.getUserPassport().getBytes());
            xmlRepresentation.addAttribute("uid", Long.toString(myCRC.getValue()));
        }
        xmlRepresentation.endElement(false);
        if (failureReason != null && !"".equals(failureReason)) {
            xmlRepresentation.addElement("FAILURE", 1);
            xmlRepresentation.addText(failureReason);
            xmlRepresentation.addElement("FAILURE", 2);
        }
        MFWActionLogHelper.getXMLRepresentationForMetadataSourceEntries(aMetadataSrc, xmlRepresentation);
        xmlRepresentation.addElement(GATEWAYCONNECTION, 2);
    }

    public static void GetXMLRepresentationForCluster(MFWCluster cluster, MFWXMLDump xmlRepr) {
        xmlRepr.addElement("cluster", 1);
        MFWNodeObject node = cluster.getRootNode();
        MFWActionLogHelper.GetXMLRepresentationForNode(node, xmlRepr);
        xmlRepr.addElement("cluster", 2);
    }

    public static void GetXMLRepresentationForObjectQueryResultSet(short queryType, String expression, int queryDepth, MFWGateway gateway, MFWNodeHandle node, MFWNodeHandle[] vResultNodes, String failureReason, boolean dumpResultNodes, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(OBJECT_QUERY, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(OBJECT, 0);
        switch (queryType) {
            case 0: {
                xmlRepresentation.addAttribute(QUERY_TYPE, QUERY_TYPE_XPATH);
                break;
            }
            case 1: {
                xmlRepresentation.addAttribute(QUERY_TYPE, QUERY_TYPE_RIDNAME);
                break;
            }
            case 3: {
                xmlRepresentation.addAttribute(QUERY_TYPE, QUERY_TYPE_ALL_CHILDREN);
            }
        }
        xmlRepresentation.endElement(false);
        MFWActionLogHelper.BuildIDPath((MFWNode)node, xmlRepresentation);
        xmlRepresentation.addElement(OBJECT, 2);
        if (queryType != 3) {
            if (queryDepth >= 0) {
                xmlRepresentation.addElement("queryExpression", 0);
                xmlRepresentation.addAttribute("depth", queryDepth);
                xmlRepresentation.endElement(false);
            } else {
                xmlRepresentation.addElement("queryExpression", 1);
            }
            xmlRepresentation.addText(expression);
            xmlRepresentation.addElement("queryExpression", 2);
        }
        if (dumpResultNodes) {
            MFWActionLogHelper.GetXMLRepresentationForResultSet(vResultNodes, failureReason, xmlRepresentation);
        }
        xmlRepresentation.addElement(OBJECT_QUERY, 2);
    }

    public static void GetXMLRepresentationForResultSet(MFWNodeHandle[] vResultNodes, String failureReason, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(RESULT_SET, 1);
        if (vResultNodes != null && vResultNodes.length > 0) {
            for (int i = 0; i < vResultNodes.length; ++i) {
                xmlRepresentation.addElement("result", 1);
                MFWActionLogHelper.GetXMLRepresentationForNode((MFWNode)vResultNodes[i], xmlRepresentation);
                xmlRepresentation.addElement("result", 2);
            }
        } else if (failureReason != null && !"".equals(failureReason)) {
            StringBuffer outString = new StringBuffer();
            CCLXMLUtils.xmlEncode((String)failureReason, (StringBuffer)outString);
            xmlRepresentation.addText(outString.toString());
        }
        xmlRepresentation.addElement(RESULT_SET, 2);
    }

    public static void GetXMLRepresentationForCRNIDResultSet(MFWNodeHandle[] vResultNodes, MFWGateway gateway, String failureReason, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(RESULT_SET, 1);
        if (vResultNodes != null && vResultNodes.length > 0) {
            for (int i = 0; i < vResultNodes.length; ++i) {
                MFWActionLogHelper.GetXMLRepresentationForHandleID(vResultNodes[i], gateway, xmlRepresentation);
            }
        } else if (failureReason != null && !"".equals(failureReason)) {
            StringBuffer outString = new StringBuffer();
            CCLXMLUtils.xmlEncode((String)failureReason, (StringBuffer)outString);
            xmlRepresentation.addText(outString.toString());
        }
        xmlRepresentation.addElement(RESULT_SET, 2);
    }

    public static void GetXMLRepresentationForCrnIdResolutionResultSet(String crnId, MFWGateway gateway, MFWNodeHandle[] vResultNodes, String failureReason, boolean dumpResultNodes, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(RESOLVE_CRN_ID, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(CRNID, 1);
        xmlRepresentation.addText(crnId);
        xmlRepresentation.addElement(CRNID, 2);
        if (dumpResultNodes) {
            MFWActionLogHelper.GetXMLRepresentationForCRNIDResultSet(vResultNodes, gateway, failureReason, xmlRepresentation);
        }
        xmlRepresentation.addElement(RESOLVE_CRN_ID, 2);
    }

    public static void GetXMLRepresentationForHandleID(MFWNodeHandle aHandle, MFWGateway gateway, MFWXMLDump xmlRepresentation) {
        String objectType = aHandle.getName();
        xmlRepresentation.addElement(objectType, 1);
        xmlRepresentation.addElement("ID", 1);
        short rid = MFWModelRes.getInstance().getResourceID("ID");
        String id = gateway.getObjectPropertyValue(aHandle, rid);
        xmlRepresentation.addText(id);
        xmlRepresentation.addElement("ID", 2);
        xmlRepresentation.addElement(objectType, 2);
    }

    private static void BuildIDPath(MFWNode handle, MFWXMLDump dump) {
        String idPath = MFWActionLogHelper.BuildIDPath(handle);
        if (idPath != null && idPath.length() > 0) {
            dump.addText(idPath);
        }
    }

    protected static String BuildIDPath(MFWNode node) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList<String> vNames = new ArrayList<String>();
        MFWNode pCurrNode = node;
        while (pCurrNode != null) {
            StringBuffer identificationString = new StringBuffer();
            MFWNodeObject pParent = null;
            if (pCurrNode.getParentObject().getInfo() == MFWModel.getInstance().getRootObjInfo()) {
                identificationString.setLength(0);
                identificationString.append(pCurrNode.getName());
            } else {
                pParent = (MFWNodeObject)pCurrNode.getParent();
                MFWException.ASSERT(pParent != null, "Expecting a valid parent node");
                if (pCurrNode.getInfo().findChildInfo(gModelRes.RID_ID) != null) {
                    MFWNodeObject no = (MFWNodeObject)pCurrNode;
                    String id = no.getPropertyValue(gModelRes.RID_ID);
                    if (id != null) {
                        identificationString.setLength(0);
                        identificationString.append("/*[ID='");
                        String encoded = MFWStringHelper.escapeXMLChars(id);
                        id = encoded.replaceAll("'", "&apos;");
                        identificationString.append(id);
                        identificationString.append("']");
                    } else {
                        identificationString.setLength(0);
                        identificationString.append(no.getName());
                    }
                    pParent = null;
                } else {
                    int index = 0;
                    if (pCurrNode.isProperty()) {
                        List<String> vPropVals = pParent.getPropertyValues(pCurrNode.getNameRID());
                        if (vPropVals != null) {
                            index = vPropVals.indexOf(((MFWNodeProperty)pCurrNode).getValue());
                        }
                    } else {
                        List<MFWNode> vObjs = pParent.getObjectNodes(pCurrNode.getNameRID());
                        index = vObjs.indexOf(pCurrNode);
                    }
                    identificationString.setLength(0);
                    identificationString.append(pCurrNode.getName());
                    identificationString.append("[");
                    identificationString.append(Integer.toString(index));
                    identificationString.append("]");
                }
            }
            vNames.add(identificationString.toString());
            pCurrNode = pParent;
        }
        StringBuffer idPath = new StringBuffer();
        for (int idx = vNames.size() - 1; idx >= 0; --idx) {
            idPath.append("/");
            idPath.append((String)vNames.get(idx));
        }
        return idPath.toString();
    }

    public static void GetXMLRepresentationForQueryResultResultSet(String clusterQuery, int queryDepth, MFWGateway gateway, MFWNodeHandle[] vResultNodes, String failureReason, boolean dumpResultNodes, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(CLUSTER_QUERY, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        if (queryDepth >= 0) {
            xmlRepresentation.addElement("query", 0);
            xmlRepresentation.addAttribute("depth", queryDepth);
            xmlRepresentation.endElement(false);
        } else {
            xmlRepresentation.addElement("query", 1);
        }
        xmlRepresentation.addText(clusterQuery, true);
        xmlRepresentation.addElement("query", 2);
        if (dumpResultNodes) {
            MFWActionLogHelper.GetXMLRepresentationForResultSet(vResultNodes, failureReason, xmlRepresentation);
        }
        xmlRepresentation.addElement(CLUSTER_QUERY, 2);
    }

    public static void GetXMLRepresentationForNode(MFWNode node, MFWXMLDump xmlRepr) {
        switch (node.getInfo().getNodeType()) {
            case 1: {
                MFWNodeProperty prop = (MFWNodeProperty)node;
                if (prop.getValue() == null || "".equals(prop.getValue())) {
                    xmlRepr.addEmptyElement(prop.getName());
                    break;
                }
                xmlRepr.addElement(node.getName(), 1);
                StringBuffer sEscapedValue = new StringBuffer();
                CCLXMLUtils.xmlEncode((String)prop.getValue(), (StringBuffer)sEscapedValue);
                xmlRepr.addText(sEscapedValue.toString());
                xmlRepr.addElement(node.getName(), 3);
                break;
            }
            case 2: {
                xmlRepr.addElement(node.getName(), 1);
                MFWNodeObject pObj = (MFWNodeObject)node;
                List<MFWNode> vChildren = pObj.getChildNodes();
                for (MFWNode aNode : vChildren) {
                    MFWActionLogHelper.GetXMLRepresentationForNode(aNode, xmlRepr);
                }
                xmlRepr.addElement(node.getName(), 2);
                break;
            }
            case 3: {
                MFWNodeLink pLink = (MFWNodeLink)node;
                xmlRepr.addElement(node.getName(), 0);
                String sQPath = pLink.getQuerySpec().getXPathQuery();
                xmlRepr.addAttribute("queryPath", sQPath);
                xmlRepr.endElement(true);
            }
        }
        if (node.getNameRID() == MFWModelRes.getInstance().RID_project) {
            MFWNodeObject objNode = (MFWNodeObject)node;
            List<MFWCluster> vLinkedClusters = objNode.getCluster().getAllLinkedClusters();
            for (int idx = 0; idx < vLinkedClusters.size(); ++idx) {
                MFWCluster pCluster = vLinkedClusters.get(idx);
                MFWActionLogHelper.GetXMLRepresentationForCluster(pCluster, xmlRepr);
            }
        }
    }

    public static void GetXMLRepresentationForHandle(MFWNodeHandle aHandle, MFWXMLDump xmlRepr) {
        MFWActionLogHelper.GetXMLRepresentationForNode((MFWNode)aHandle, xmlRepr);
    }

    public static void GetXMLRepresentationForMetadataSourceQuery(MFWGateway gateway, MFWNodeHandle node, MFWMetadataSource source, MFWXMLDump xmlRepresentation, boolean dumpSource) {
        xmlRepresentation.addElement(METADATASOURCE_QUERY, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(OBJECT, 1);
        MFWActionLogHelper.BuildIDPath((MFWNode)node, xmlRepresentation);
        xmlRepresentation.addElement(OBJECT, 2);
        if (dumpSource) {
            MFWActionLogHelper.GetXMLRepresentationForMetadataSource(source, xmlRepresentation);
        }
        xmlRepresentation.addElement(METADATASOURCE_QUERY, 2);
    }

    public static void GetXMLRepresentationForPropertyValueQuery(String apiName, MFWGateway gateway, MFWNodeHandle handle, String propName, short valueType, MFWXMLDump xmlRepresentation, List<String> values, String failureReason, boolean dumpValue) {
        MFWException.ASSERT(QUERY_PROPERTY.equals(apiName) || QUERY_PROPERTIES.equals(apiName), "API name must be either 'queryProperty' or 'queryProperties'");
        xmlRepresentation.addElement(apiName, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(OBJECT, 1);
        MFWActionLogHelper.BuildIDPath((MFWNode)handle, xmlRepresentation);
        xmlRepresentation.addElement(OBJECT, 2);
        xmlRepresentation.addElement(RID, 1);
        xmlRepresentation.addText(propName);
        xmlRepresentation.addElement(RID, 2);
        xmlRepresentation.addElement(API_TYPE, 1);
        switch (valueType) {
            case 0: {
                xmlRepresentation.addText(STRING);
                break;
            }
            case 1: {
                xmlRepresentation.addText(BOOLEAN);
                break;
            }
            case 2: {
                xmlRepresentation.addText(ENUM);
            }
        }
        xmlRepresentation.addElement(API_TYPE, 2);
        if (values != null && dumpValue) {
            if (failureReason != null && failureReason.length() > 0) {
                xmlRepresentation.addElement(VALUE, 1);
                xmlRepresentation.addText(failureReason);
            } else {
                for (String aVal : values) {
                    xmlRepresentation.addElement(VALUE, 1);
                    xmlRepresentation.addText(aVal);
                    xmlRepresentation.addElement(VALUE, 2);
                }
            }
        }
        xmlRepresentation.addElement(apiName, 2);
    }

    public static void GetXMLRepresentationForFindChildObjectsResultSet(String method, MFWGateway gateway, MFWNodeHandle node, String childObjName, String propName, String propValue, MFWNodeHandle[] resultNodes, String failureReason, boolean fullActionLogs, MFWXMLDump xmlRepresentation) {
        xmlRepresentation.addElement(FIND_CHILD_OBJECTS, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(OBJECT, 1);
        MFWActionLogHelper.BuildIDPath((MFWNode)node, xmlRepresentation);
        xmlRepresentation.addElement(OBJECT, 2);
        xmlRepresentation.addElement(CHILD_OBJ_NAME, 1);
        xmlRepresentation.addText(childObjName);
        xmlRepresentation.addElement(CHILD_OBJ_NAME, 2);
        xmlRepresentation.addElement(PROP_NAME, 1);
        xmlRepresentation.addText(propName);
        xmlRepresentation.addElement(PROP_NAME, 2);
        xmlRepresentation.addElement(PROP_VALUE, 1);
        xmlRepresentation.addText(propValue);
        xmlRepresentation.addElement(PROP_VALUE, 2);
        if (fullActionLogs) {
            MFWActionLogHelper.GetXMLRepresentationForResultSet(resultNodes, failureReason, xmlRepresentation);
        }
        xmlRepresentation.addElement(FIND_CHILD_OBJECTS, 2);
    }

    public static void GetXMLRepresentationForValueQuery(MFWGateway gateway, MFWNodeHandle handle, MFWXMLDump xmlRepresentation, String result, String failureReason, boolean fullActionLogs) {
        xmlRepresentation.addElement(GET_PROPERTY_VALUE, 0);
        String threadID = MFWActionLogHelper.GetThreadId();
        xmlRepresentation.addAttribute(THREAD_ID, threadID);
        xmlRepresentation.addAttribute(GATEWAY_ID, gateway.getID());
        xmlRepresentation.endElement(false);
        xmlRepresentation.addElement(OBJECT, 1);
        MFWActionLogHelper.BuildIDPath((MFWNode)handle, xmlRepresentation);
        xmlRepresentation.addElement(OBJECT, 2);
        if (fullActionLogs) {
            xmlRepresentation.addElement(VALUE, 1);
            if (failureReason != null && failureReason.length() > 0) {
                xmlRepresentation.addText(failureReason);
            } else {
                xmlRepresentation.addText(result);
            }
            xmlRepresentation.addElement(VALUE, 2);
        }
        xmlRepresentation.addElement(GET_PROPERTY_VALUE, 2);
    }
}

