/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFW;
import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWClusterOwner;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionManager;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWLinkManager;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWStringPool;
import com.cognos.mfw4j.framework.log.MFWLogClusterCreation;
import com.cognos.mfw4j.framework.log.MFWLogClusterDeletion;
import com.cognos.mfw4j.framework.log.MFWLogClusterOwner;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public final class MFWCluster {
    private ReentrantLock mConnLock = new ReentrantLock();
    private MFWConnection mConnection;
    private MFWNodeObject mRootNode;
    private MFWLinkManager mLinkMgr = null;
    private MFWIndexManager mIndexMgr = null;
    private MFWStringPool mStringPool;
    private ConcurrentLinkedQueue<LinkClusters> mLinkedClusters;
    private volatile int mRefCount;

    MFWCluster(MFWConnection aConnection) {
        this.mConnection = aConnection;
        this.mRefCount = 0;
        this.mLinkedClusters = new ConcurrentLinkedQueue();
        String meth = "MFWCluster::MFWCluster";
        MFWLogClusterCreation log = new MFWLogClusterCreation("MFWCluster::MFWCluster", this);
        log.logEnd();
    }

    void destroy() {
        String meth = "MFWCluster::destroy()";
        MFWLogClusterDeletion log = new MFWLogClusterDeletion("MFWCluster::destroy()", this);
        try {
            int refCount = this.getReferenceCount();
            if (refCount != 0) {
                StringBuffer msg = new StringBuffer("At least one gateway is still hanging to this cluster, referenceCount: ");
                msg.append(Integer.toString(refCount));
                MFWException.ASSERT(false, msg.toString());
            }
            this.mConnection = null;
            if (this.mLinkMgr != null) {
                this.mLinkMgr.destroy();
            }
            this.mLinkMgr = null;
            if (this.mIndexMgr != null) {
                this.mIndexMgr.destroy();
            }
            this.mIndexMgr = null;
            if (this.mStringPool != null) {
                this.mStringPool.destroy();
            }
            this.mStringPool = null;
            if (this.mRootNode != null) {
                this.mRootNode.destroy();
            }
            this.mRootNode = null;
            for (LinkClusters aLink : this.mLinkedClusters) {
                aLink.destroy();
            }
            this.mLinkedClusters.clear();
        }
        catch (RuntimeException t) {
            log.logEnd(t);
            throw t;
        }
        log.logEnd();
    }

    public MFWLinkManager getLinkManager() {
        if (this.mLinkMgr == null) {
            this.mLinkMgr = this.mConnection.createLinkManager();
        }
        return this.mLinkMgr;
    }

    public MFWIndexManager getIndexManager() {
        if (this.mIndexMgr == null) {
            this.mIndexMgr = this.mConnection.createIndexManager();
        }
        return this.mIndexMgr;
    }

    public MFWStringPool getStringPool() {
        if (this.mStringPool == null) {
            this.mStringPool = this.mConnection.createStringPool();
        }
        return this.mStringPool;
    }

    public MFWNodeObject getRootNode() {
        if (this.mRootNode == null) {
            this.mRootNode = this.mConnection.setupRootNode(this);
        }
        return this.mRootNode;
    }

    public long getTimeOfInception() {
        return this.mConnection.getReuseInfo().getInceptionTime();
    }

    public long getLastAccessedTime() {
        return this.mConnection.getReuseInfo().getLastAccessedTime();
    }

    void setLastAccessedTime(long lastAccessedTime) {
        this.mConnection.getReuseInfo().setLastAccessedTime(lastAccessedTime);
    }

    public MFWConnection getConnection() {
        return this.mConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MFWCluster getLinkedCluster(MFWRequestContextUser aContext, short idLinkSrc) {
        LinkClusters aLinkClstrs = null;
        this.mConnLock.lock();
        try {
            for (LinkClusters anElement : this.mLinkedClusters) {
                if (anElement.mLinkID != idLinkSrc) continue;
                aLinkClstrs = anElement;
            }
            if (aLinkClstrs == null) {
                aLinkClstrs = new LinkClusters(this.getLinkManager(), idLinkSrc);
                this.mLinkedClusters.add(aLinkClstrs);
            }
        }
        finally {
            this.mConnLock.unlock();
        }
        return aLinkClstrs.getClusterFor(aContext, true);
    }

    public List<MFWCluster> getAllLinkedClustersFor(MFWRequestContextUser aContext) {
        ArrayList<MFWCluster> outClusters = new ArrayList<MFWCluster>();
        for (LinkClusters aLnkClstrs : this.mLinkedClusters) {
            MFWCluster aLinkedCluster = aLnkClstrs.getClusterFor(aContext, false);
            if (aLinkedCluster == null) continue;
            outClusters.add(aLinkedCluster);
        }
        return outClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MFWCluster> connectAllLinkedClustersFor(MFWRequestContextUser aContext) {
        this.mConnLock.lock();
        try {
            ArrayList<MFWCluster> outClusters = new ArrayList<MFWCluster>();
            for (LinkClusters aLnkClstrs : this.mLinkedClusters) {
                MFWCluster aLinkedCluster = aLnkClstrs.getClusterFor(aContext, true);
                if (aLinkedCluster == null) continue;
                outClusters.add(aLinkedCluster);
            }
            ArrayList<MFWCluster> arrayList = outClusters;
            return arrayList;
        }
        finally {
            this.mConnLock.unlock();
        }
    }

    public List<MFWCluster> getAllLinkedClusters() {
        ArrayList<MFWCluster> outClusters = new ArrayList<MFWCluster>();
        for (LinkClusters aLnkClstrs : this.mLinkedClusters) {
            aLnkClstrs.getClusters(outClusters);
        }
        return outClusters;
    }

    public void expand(MFWNodeObject parentObj, MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec) {
        this.mConnection.expand(aContext, aQuerySpec, parentObj);
    }

    public MFWNodeObject lookup(MFWInfoProperty aPropInfo, String sPropValue, MFWRequestContextUser aContext, List<MFWNodeObject> ancestorsChain) {
        MFWNodeObject outObj = this.lookupInCluster(aPropInfo, sPropValue, aContext, ancestorsChain);
        if (outObj == null) {
            outObj = this.lookupInLinkedClusters(aPropInfo, sPropValue, aContext, ancestorsChain);
        }
        if (ancestorsChain != null && outObj == null) {
            ancestorsChain.clear();
        }
        return outObj;
    }

    private MFWNodeObject lookupInCluster(MFWInfoProperty aPropInfo, String sPropValue, MFWRequestContextUser aContext, List<MFWNodeObject> ancestorsChain) {
        MFWNodeObject outObj = this.getIndexManager().lookup(aPropInfo, sPropValue);
        if (outObj != null) {
            if (ancestorsChain != null) {
                MFWCrnIDAdvancedLookup.addToAncestorsChain(outObj, null, ancestorsChain);
            }
        } else {
            outObj = this.mConnection.lookup(aContext, aPropInfo, sPropValue, this.getRootNode(), ancestorsChain);
        }
        return outObj;
    }

    public MFWNodeObject lookupInLinkedClusters(MFWInfoProperty aPropInfo, String sPropValue, MFWRequestContextUser aContext, List<MFWNodeObject> ancestorsChain) {
        MFWCluster aLinkedCluster;
        MFWNodeObject alinkCont;
        short aLinkID;
        int idx;
        MFWNodeObject outObj = null;
        short[] vLinkIDs = this.getLinkManager().getLinkIDs();
        for (idx = 0; outObj == null && idx < vLinkIDs.length; ++idx) {
            aLinkID = vLinkIDs[idx];
            if (ancestorsChain != null) {
                ancestorsChain.clear();
                alinkCont = this.getLinkManager().getLinkContainer(aLinkID);
                MFWCrnIDAdvancedLookup.addToAncestorsChain(alinkCont, null, ancestorsChain);
            }
            aLinkedCluster = this.getLinkedCluster(aContext, aLinkID);
            outObj = aLinkedCluster.lookupInCluster(aPropInfo, sPropValue, aContext, ancestorsChain);
        }
        for (idx = 0; outObj == null && idx < vLinkIDs.length; ++idx) {
            aLinkID = vLinkIDs[idx];
            if (ancestorsChain != null) {
                ancestorsChain.clear();
                alinkCont = this.getLinkManager().getLinkContainer(aLinkID);
                MFWCrnIDAdvancedLookup.addToAncestorsChain(alinkCont, null, ancestorsChain);
            }
            aLinkedCluster = this.getLinkedCluster(aContext, aLinkID);
            outObj = aLinkedCluster.lookupInLinkedClusters(aPropInfo, sPropValue, aContext, ancestorsChain);
        }
        return outObj;
    }

    public int getReferenceCount() {
        return this.mRefCount;
    }

    void registerOwner(MFWClusterOwner owner, MFWRequestContextUser aContext) {
        this.mConnLock.lock();
        try {
            ++this.mRefCount;
        }
        finally {
            this.mConnLock.unlock();
        }
        String meth = "MFWCluster::registerOwner";
        MFWLogClusterOwner log = new MFWLogClusterOwner("MFWCluster::registerOwner", 0, owner, aContext, this, this.mRefCount);
        log.logEnd();
    }

    void unOwn() {
        this.mRefCount = 0;
    }

    void unregisterOwner(MFWClusterOwner owner, MFWRequestContextUser aContext) {
        String meth = "MFWCluster::unregisterOwner";
        MFWLogClusterOwner log = new MFWLogClusterOwner("MFWCluster::unregisterOwner", 1, owner, aContext, this, this.mRefCount);
        this.mConnLock.lock();
        try {
            this.getConnection().notifyUnregisterOwner(owner, aContext, this.mRefCount);
            this.notifyConsumers(aContext);
            if (this.mRefCount == 1 && this.getConnection().getAdaptor().shouldEvictCluster(this.getConnection())) {
                this.getConnection().setReusable(false);
            }
            --this.mRefCount;
        }
        catch (RuntimeException t) {
            log.logEnd(t);
            throw t;
        }
        finally {
            this.mConnLock.unlock();
        }
        log.logEnd();
        MFWConnectionManager.getInstance().doWakeup();
    }

    void notifyConsumers(MFWRequestContextUser aContext) {
        for (LinkClusters linkClstrs : this.mLinkedClusters) {
            linkClstrs.notifyLinkSourceUnregister(aContext, this);
        }
    }

    public boolean isStale(MFWRequestContextUser aContext, MFWMetadataSource metadataSrc) {
        for (LinkClusters aLnkClstrs : this.mLinkedClusters) {
            try {
                MFWCluster aLinkedCluster = aLnkClstrs.getClusterFor(aContext, true);
                if (aLinkedCluster == null) continue;
                MFWNodeObject aLinkParent = this.getLinkManager().getLinkContainer(aLnkClstrs.mLinkID);
                if (aLinkParent == null) {
                    return true;
                }
                MFWMetadataSource aLinkSrc = this.getLinkManager().getLinkSource(aLnkClstrs.mLinkID);
                if (!aLinkedCluster.isStale(aContext, aLinkParent, aLinkSrc)) continue;
                return true;
            }
            catch (RuntimeException ex) {
                String errorCode = ex.getMessage();
                boolean knownErrorCode = MFWConfiguration.getInstance().isKnownErrorCode(errorCode);
                if (knownErrorCode) continue;
                throw ex;
            }
        }
        return this.isStale(aContext, null, metadataSrc);
    }

    private boolean isStale(MFWRequestContextUser aContext, MFWNodeObject linkParent, MFWMetadataSource metadataSrc) {
        MFWConnection conn = this.getConnection();
        if (conn == null) {
            return true;
        }
        if (metadataSrc == null) {
            return true;
        }
        try {
            MFWAdaptor adaptor = conn.getAdaptor();
            MFWConnectionReuseInfo reuseInfo = adaptor.createReuseInfo(aContext, metadataSrc, linkParent);
            return !conn.getReuseInfo().isCacheUpToDate(aContext, reuseInfo);
        }
        catch (MFWModelNotFoundException ex) {
            throw ex;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final class LinkClusters
    implements MFWClusterOwner {
        private short mLinkID = (short)-1;
        private MFWLinkManager mLinkMngr = null;
        private ConcurrentHashMap<MFWRequestContextUser, MFWCluster> mContext2Clusters = null;

        LinkClusters(MFWLinkManager linkMngr, short linkID) {
            this.mLinkID = linkID;
            this.mLinkMngr = linkMngr;
            this.mContext2Clusters = new ConcurrentHashMap();
        }

        MFWCluster getClusterFor(MFWRequestContextUser aContext, boolean doConnect) {
            MFWCluster outCluster = null;
            outCluster = this.mContext2Clusters.get(aContext);
            if (!doConnect) {
                return outCluster;
            }
            if (outCluster == null) {
                MFWMetadataSource aLinkSrc = this.mLinkMngr.getLinkSource(this.mLinkID);
                MFWNodeObject aLinkCont = this.mLinkMngr.getLinkContainer(this.mLinkID);
                outCluster = MFW.getInstance().findOrCreateCluster(this, aContext, aLinkSrc, aLinkCont);
            }
            this.mContext2Clusters.put(aContext, outCluster);
            return outCluster;
        }

        void getClusters(ArrayList<MFWCluster> outClusters) {
            for (MFWCluster aCluster : this.mContext2Clusters.values()) {
                if (outClusters.contains(aCluster)) continue;
                outClusters.add(aCluster);
            }
        }

        void notifyLinkSourceUnregister(MFWRequestContextUser aContext, MFWCluster sourceCluster) {
            MFWCluster linkCluster = this.mContext2Clusters.remove(aContext);
            if (linkCluster != null) {
                linkCluster.getConnection().notifyLinkSourceClosing(sourceCluster, aContext);
                linkCluster.unregisterOwner(this, aContext);
                linkCluster = null;
            }
        }

        @Override
        public String getStringRepresentation() {
            StringBuffer outStr = new StringBuffer("LinkClusters: link ID:");
            outStr.append(Integer.toString(this.mLinkID));
            outStr.append(" from cluster ");
            MFWCluster ownerCluster = this.mLinkMngr.getLinkContainer(this.mLinkID).getCluster();
            outStr.append(Double.toString(ownerCluster.hashCode()));
            return outStr.toString();
        }

        void destroy() {
            MFWException.ASSERT(this.mContext2Clusters.isEmpty(), "All link clusters must be released by now");
            this.mContext2Clusters = null;
            this.mLinkMngr = null;
        }
    }
}

