/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWClusterOwner;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWLinkManager;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWStringPool;
import com.cognos.mfw4j.framework.implHeap.MFWIndexManagerHeap;
import com.cognos.mfw4j.framework.implHeap.MFWLinkManagerHeap;
import com.cognos.mfw4j.framework.implHeap.MFWNodeObjectRootHeap;
import com.cognos.mfw4j.framework.implHeap.MFWStringPoolHeap;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class MFWConnection {
    private static final int SETUP_STATE_NOT_STARETD = 0;
    private static final int SETUP_STATE_STARTED = 1;
    private static final int SETUP_STATE_COMPLETE = 2;
    private static final int SETUP_STATE_FAILED = 3;
    private MFWConnectionReuseInfo mReuseInfo;
    private MFWAdaptor mAdaptor;
    private MFWCluster mCluster;
    private volatile boolean mReusable;
    private volatile RuntimeException mSetupException = null;
    private MFWPersistentMetadataCluster mPMC;
    private boolean mbCaseSensitive;
    private final AtomicInteger mSetupState = new AtomicInteger(0);
    private final ReentrantLock mSetupLock = new ReentrantLock();
    private final Condition mSetupCond = this.mSetupLock.newCondition();

    protected MFWConnection(MFWConnectionReuseInfo aReuseInfo, MFWAdaptor anAdaptor) {
        this.mReuseInfo = aReuseInfo;
        this.mAdaptor = anAdaptor;
        this.mCluster = null;
        this.mReusable = true;
        this.mbCaseSensitive = true;
    }

    final boolean isAssociatedWithPMC() {
        return this.mPMC != null;
    }

    final void waitForSetup() {
        if (this.mSetupException != null) {
            throw this.mSetupException;
        }
        if (this.mSetupState.get() == 2) {
            return;
        }
        this.mSetupLock.lock();
        try {
            while (this.mSetupState.get() != 2 && this.mSetupState.get() != 3) {
                this.mSetupCond.await();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            this.mSetupLock.unlock();
        }
        if (this.mSetupException != null) {
            throw this.mSetupException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setup(MFWCluster newCluster, MFWRequestContextUser aContext, MFWNodeObject aLinkParent, EClusterSetup eSetupType) {
        MFWException.ASSERT(eSetupType != EClusterSetup.kEUnknown, "The connection set up type cannot be unknown!");
        if (this.mSetupState.compareAndSet(0, 1)) {
            this.initializeCluster(newCluster, aContext, aLinkParent, eSetupType);
            this.mSetupLock.lock();
            try {
                this.mSetupCond.signalAll();
            }
            finally {
                this.mSetupLock.unlock();
            }
            if (this.mSetupException != null) {
                throw this.mSetupException;
            }
        }
    }

    final boolean canBeCheckedForEviction() {
        return this.mSetupState.get() == 2 || this.mSetupState.get() == 3;
    }

    final boolean setupFailed() {
        return this.mSetupState.get() == 3;
    }

    private void initializeCluster(MFWCluster newCluster, MFWRequestContextUser aContext, MFWNodeObject aLinkParent, EClusterSetup eSetupType) {
        try {
            if (eSetupType == EClusterSetup.kEReconstruct) {
                this.reconstructSetup(aContext, aLinkParent);
            } else {
                this.initialSetup(aContext, aLinkParent);
            }
            if (eSetupType == EClusterSetup.kEInitializeExpandAll) {
                this.expandAll(aContext, aLinkParent);
                if (this.getPMC() != null) {
                    this.getPMC().saveAndReopen();
                }
            }
            this.mSetupState.set(2);
        }
        catch (Throwable th) {
            newCluster.unOwn();
            this.mSetupException = th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
            if (eSetupType == EClusterSetup.kEInitializeExpandAll && this.mPMC != null) {
                this.mPMC.deleteUnOwned();
                this.mPMC = null;
            }
            this.mSetupState.set(3);
            this.setReusable(false);
        }
    }

    public MFWIndexManager createIndexManager() {
        if (this.mPMC != null) {
            return this.mPMC.getIndexManager();
        }
        return new MFWIndexManagerHeap();
    }

    public MFWLinkManager createLinkManager() {
        if (this.mPMC != null) {
            return this.mPMC.getLinkManager();
        }
        return new MFWLinkManagerHeap(this.mCluster);
    }

    public MFWStringPool createStringPool() {
        if (this.mPMC != null) {
            return this.mPMC.getStringPool();
        }
        return new MFWStringPoolHeap();
    }

    public void destroy() {
        this.mReuseInfo.destroy();
        this.mAdaptor = null;
        this.mCluster = null;
        if (this.mPMC != null) {
            this.mPMC.updateUsageInfoAndClose();
        }
    }

    protected MFWNodeObject setupRootNode(MFWCluster ownerCluster) {
        if (this.mPMC != null) {
            return this.mPMC.getRootObject();
        }
        return new MFWNodeObjectRootHeap(ownerCluster);
    }

    protected abstract void expand(MFWRequestContextUser var1, MFWQuerySpec var2, MFWNodeObject var3);

    protected abstract MFWNodeObject lookup(MFWRequestContextUser var1, MFWInfoProperty var2, String var3, MFWNodeObject var4, List<MFWNodeObject> var5);

    protected void notifyLinkSourceClosing(MFWCluster pSourceCluster, MFWRequestContextUser aContext) {
    }

    protected void notifyUnregisterOwner(MFWClusterOwner anOwner, MFWRequestContextUser aContext, int clusterRefCount) {
    }

    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    protected void expandAll(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWException.ASSERT(false, "Expand all is not supported for connections of this type:", this.getSource().getType());
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        String outValue = null;
        if (ridDynProp == MFWModelRes.getInstance().RID_isFromLinkedSource) {
            outValue = !this.getCluster().equals(aContext.getGatewayCluster()) ? "true" : "false";
        }
        return outValue;
    }

    public final MFWAdaptor getAdaptor() {
        return this.mAdaptor;
    }

    public final MFWConnectionReuseInfo getReuseInfo() {
        return this.mReuseInfo;
    }

    public final MFWMetadataSource getSource() {
        return this.mReuseInfo.getMetadataSource();
    }

    public final MFWCluster getCluster() {
        return this.mCluster;
    }

    public final boolean isReusable() {
        return this.mReusable;
    }

    public final boolean isCaseSensitive() {
        return this.mbCaseSensitive;
    }

    final void setCluster(MFWCluster aCluster) {
        this.mCluster = aCluster;
    }

    public final void setPMC(MFWPersistentMetadataCluster aPMC) {
        this.mPMC = aPMC;
    }

    public final MFWPersistentMetadataCluster getPMC() {
        return this.mPMC;
    }

    protected final void setReusable(boolean reusable) {
        this.mReusable = reusable;
    }

    protected final void setCaseSensitiveResult(boolean bCaseSensitive) {
        this.mbCaseSensitive = bCaseSensitive;
    }

    protected final void defaultExpand(MFWRequestContextUser aContext, short ridChildProp, MFWNodeObject parentNode) {
        parentNode.setExpandStatus(ridChildProp, (byte)1);
    }

    static enum EClusterSetup {
        kEUnknown,
        kEInitialize,
        kEInitializeExpandAll,
        kEReconstruct;

    }
}

