/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.framework.implPersistence.MFWStringPoolPrst;
import com.cognos.mfw4j.framework.log.MFWLog;
import com.cognos.mfw4j.persistence.MFWPStore;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class MFWConnectionReuseInfo {
    public static final String PERSTSTENT_CLUSTER_EXTENSION = ".pmc";
    public static final FileFilter PMCFileFilter = new FileFilter(){

        @Override
        public boolean accept(File anEntry) {
            if (anEntry.isDirectory()) {
                return true;
            }
            return anEntry.getName().endsWith(MFWConnectionReuseInfo.PERSTSTENT_CLUSTER_EXTENSION);
        }
    };
    private MFWMetadataSource mMetadataSrc = null;
    private long mLastAccessedTime;
    private long mInceptionTime;

    protected MFWConnectionReuseInfo(MFWMetadataSource aSource) {
        this.mMetadataSrc = (MFWMetadataSource)aSource.clone();
        this.mLastAccessedTime = System.currentTimeMillis();
        this.mInceptionTime = System.currentTimeMillis();
    }

    protected MFWConnectionReuseInfo() {
    }

    public void destroy() {
    }

    public MFWMetadataSource getMetadataSource() {
        return this.mMetadataSrc;
    }

    protected abstract boolean isReusableFor(MFWConnectionReuseInfo var1);

    public abstract StringBuffer getPersistentPath();

    protected abstract boolean isCacheUpToDate(MFWRequestContextUser var1, MFWConnectionReuseInfo var2);

    public final long getInceptionTime() {
        return this.mInceptionTime;
    }

    public final long getLastAccessedTime() {
        return this.mLastAccessedTime;
    }

    final void setLastAccessedTime(long lastAccessedTime) {
        this.mLastAccessedTime = lastAccessedTime;
    }

    public final String getPersistentClusterFilePath() {
        StringBuffer aPath = this.getPersistentPath();
        aPath.append(PERSTSTENT_CLUSTER_EXTENSION);
        return aPath.toString();
    }

    public String toString() {
        StringWriter osw = new StringWriter();
        try {
            this.asXML(osw);
        }
        catch (IOException e) {
            return "toString Failed:" + e.getMessage();
        }
        return osw.toString();
    }

    public void asXML(Writer osw) throws IOException {
        osw.write("<reuseInfo>");
        osw.write("<inceptionTime>");
        osw.write(MFWLog.formatDateTime(this.mInceptionTime));
        osw.write("</inceptionTime>");
        osw.write("<lastAccessTime>");
        osw.write(MFWLog.formatDateTime(this.mLastAccessedTime));
        osw.write("</lastAccessTime>");
        this.mMetadataSrc.asXML(osw);
        osw.write("</reuseInfo>");
    }

    public final int persist(MFWPersistentMetadataCluster aPMC) {
        MFWPStore aStore = aPMC.getPMCStore();
        MFWStringPoolPrst aPoolString = aPMC.getStringPool();
        int outPos = aStore.putLong(this.mLastAccessedTime);
        aStore.putLong(this.mInceptionTime);
        this.mMetadataSrc.doPersist(aStore, aPoolString, outPos + 16);
        return outPos;
    }

    public final void load(MFWPersistentMetadataCluster aPMC, int aPosition) {
        MFWPStore aStore = aPMC.getPMCStore();
        MFWStringPoolPrst aPoolString = aPMC.getStringPool();
        this.mLastAccessedTime = aStore.getLong(aPosition);
        this.mInceptionTime = aStore.getLong(aPosition + 8);
        this.mMetadataSrc = MFWMetadataSource.doLoad(aStore, aPoolString, aPosition + 16);
    }

    public static void refreshLastAccessTime(MFWPStore aStore, int aPosition) {
        aStore.updateLong(aPosition, System.currentTimeMillis());
    }
}

