/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.List;

public final class MFWCrnIDAdvancedLookup {
    private static final MFWModelRes gModelRes = MFWModelRes.getInstance();
    private MFWNodeObject mProjectNode;
    private MFWCrnIDGenerator mIDGenerator;
    private MFWRequestContext mContext;

    public MFWCrnIDAdvancedLookup(MFWNodeObject aProjectNode, MFWCrnIDGenerator anIDGenerator, MFWRequestContext aContext) {
        this.mProjectNode = aProjectNode;
        this.mIDGenerator = anIDGenerator;
        this.mContext = aContext;
    }

    public void destroy() {
        this.mProjectNode = null;
        this.mIDGenerator = null;
    }

    public MFWNodeObject lookup(String aCrnID, List<MFWNodeObject> ancestorsChain) {
        if (aCrnID.startsWith("[].[dataSources]") || aCrnID.startsWith("[].[securityViews]") || aCrnID.startsWith("[].[parameterMaps]") || aCrnID.startsWith("[:physicalSources]")) {
            return null;
        }
        MFWInfoProperty indexPropInfo = MFWModel.getInstance().getIDPropertyInfo();
        boolean doResoveShortcutIDs = this.mContext.getAdvancedIDResolution() || ancestorsChain != null;
        ArrayList<String> vEntries = new ArrayList<String>();
        MFWCrnIDHelper.parseID(aCrnID, vEntries);
        if (vEntries.size() == 0) {
            return null;
        }
        MFWNode aPartialParent = null;
        MFWCluster parentCluster = this.mProjectNode.getCluster();
        StringBuilder sPartialID = new StringBuilder("");
        for (short idx = 0; idx < vEntries.size(); idx = (short)(idx + 1)) {
            if (aPartialParent != null) {
                parentCluster = aPartialParent.getCluster();
                if (aPartialParent.getNameRID() == MFWCrnIDAdvancedLookup.gModelRes.RID_shortcut && doResoveShortcutIDs) {
                    String targetValue = ((MFWNodeObject)aPartialParent).getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_refobj);
                    if (targetValue == null) {
                        return null;
                    }
                    aPartialParent = parentCluster.getIndexManager().lookup(indexPropInfo, targetValue);
                    if (aPartialParent == null) {
                        return null;
                    }
                    if (ancestorsChain != null) {
                        ancestorsChain.add((MFWNodeObject)aPartialParent);
                    }
                    sPartialID.setLength(0);
                    sPartialID.append(targetValue);
                } else {
                    String idValue = ((MFWNodeObject)aPartialParent).getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_ID);
                    MFWException.ASSERT(idValue != null, "Required ID property is missing");
                    sPartialID.setLength(0);
                    sPartialID.append(idValue);
                }
            }
            String id2Try = MFWCrnIDHelper.addEntryToID(sPartialID.toString(), vEntries.get(idx));
            MFWNodeObject anObjNode = parentCluster.getIndexManager().lookup(indexPropInfo, id2Try);
            if (anObjNode == null && (anObjNode = this.advancedLookup(doResoveShortcutIDs, (MFWNodeObject)aPartialParent, idx, vEntries.get(idx))) == null && !aCrnID.equals(id2Try)) {
                anObjNode = this.mProjectNode.getCluster().lookupInLinkedClusters(indexPropInfo, id2Try, (MFWRequestContextUser)this.mContext, null);
            }
            if (anObjNode == null) {
                return null;
            }
            if (ancestorsChain != null) {
                MFWCrnIDAdvancedLookup.addToAncestorsChain(anObjNode, (MFWNodeObject)aPartialParent, ancestorsChain);
            }
            aPartialParent = anObjNode;
        }
        return aPartialParent;
    }

    public static void addToAncestorsChain(MFWNodeObject baseNode, MFWNodeObject targetNode, List<MFWNodeObject> ancestorsChain) {
        short parentRID;
        MFWNodeObject ancestorObj;
        String lastNamespace = null;
        if (ancestorsChain.size() > 0 && (ancestorObj = ancestorsChain.get(ancestorsChain.size() - 1)).getInfo().getRID() == MFWCrnIDAdvancedLookup.gModelRes.RID_namespace) {
            lastNamespace = ancestorObj.getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_ID);
        }
        ArrayList<MFWNodeObject> ancestors = new ArrayList<MFWNodeObject>();
        for (MFWNodeObject parent = baseNode; !(parent == null || parent.equals(targetNode) || (parentRID = parent.getInfo().getRID()) == MFWCrnIDAdvancedLookup.gModelRes.RID_project || parentRID == MFWCrnIDAdvancedLookup.gModelRes.RID_physicalSources || parentRID == MFWCrnIDAdvancedLookup.gModelRes.RID_namespace && lastNamespace != null && lastNamespace.equals(parent.getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_ID))); parent = parent.getParentObject()) {
            ancestors.add(parent);
        }
        for (int idx = ancestors.size() - 1; idx >= 0; --idx) {
            ancestorsChain.add((MFWNodeObject)ancestors.get(idx));
        }
    }

    private MFWNodeObject findTopLevelObject(boolean doResoveShortcutIDs, String valueIDEntry) {
        if (this.mProjectNode.getPropertyValues(MFWCrnIDAdvancedLookup.gModelRes.RID_locale).size() == 1) {
            return null;
        }
        ArrayList<MFWNodeObject> objTopLevels = new ArrayList<MFWNodeObject>(20);
        this.mProjectNode.getCluster().getIndexManager().lookupObjectsByType((short)253, objTopLevels);
        this.mProjectNode.getCluster().getIndexManager().lookupObjectsByType((short)294, objTopLevels);
        MFWException.ASSERT(objTopLevels.size() > 0, "Expecting at least a namespace when looking up this ID in advanced lookup", valueIDEntry);
        for (MFWNodeObject objTop : objTopLevels) {
            if (!this.doesNameMatch(objTop, valueIDEntry)) continue;
            return objTop;
        }
        ArrayList<MFWNodeObject> objShortcuts = new ArrayList<MFWNodeObject>(20);
        this.mProjectNode.getCluster().getIndexManager().lookupObjectsByType((short)243, objShortcuts);
        for (MFWNodeObject objSC : objShortcuts) {
            String targetType = objSC.getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_targetType);
            if (!"namespace".equals(targetType) && !"folder".equals(targetType) || !this.doesNameMatch(objSC, valueIDEntry)) continue;
            return objSC;
        }
        return null;
    }

    private MFWNodeObject advancedLookup(boolean doResoveShortcutIDs, MFWNodeObject aParentObj, short indexIDEntry, String valueIDEntry) {
        MFWNodeObject outObjNode = null;
        MFWException.ASSERT(aParentObj != null || indexIDEntry == 0, "Need a starting point for looking up objects");
        if (aParentObj == null) {
            outObjNode = this.findTopLevelObject(doResoveShortcutIDs, valueIDEntry);
        } else {
            if (aParentObj.getCluster().getRootNode().getObjectNode(MFWCrnIDAdvancedLookup.gModelRes.RID_project).getPropertyValues(MFWCrnIDAdvancedLookup.gModelRes.RID_locale).size() == 0) {
                return null;
            }
            short[] vCandidateTypes = MFWCrnIDGenerator.getCandidateTypesForIDEntry(indexIDEntry);
            for (int idx = 0; outObjNode == null && idx < vCandidateTypes.length; ++idx) {
                MFWInfo candidateInfo = aParentObj.getObjectInfo().findChildInfo(vCandidateTypes[idx]);
                if (candidateInfo == null) continue;
                short[] vContTypes = this.mIDGenerator.getContainerTypes(vCandidateTypes[idx]);
                outObjNode = vContTypes.length > 0 ? this.lookChildrenByName(aParentObj, vCandidateTypes[idx], vContTypes, valueIDEntry) : this.lookChildrenByName(aParentObj, vCandidateTypes[idx], valueIDEntry);
            }
        }
        return outObjNode;
    }

    private boolean doesNameMatch(MFWNodeObject objNode, String sName) {
        MFWInfoObject objInfo = objNode.getObjectInfo();
        MFWInfo nameInfo = objInfo.findChildInfo(MFWCrnIDAdvancedLookup.gModelRes.RID_name);
        if (nameInfo == null) {
            return false;
        }
        if (nameInfo.getNodeType() == 1) {
            String nameProp = objNode.getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID_name);
            if (sName.equals(nameProp)) {
                return true;
            }
        } else if (nameInfo.getNodeType() == 2) {
            List<MFWNode> nameObjs = objNode.getObjectNodes(MFWCrnIDAdvancedLookup.gModelRes.RID_name);
            for (int idx = 0; idx < nameObjs.size(); ++idx) {
                MFWNodeObject aNameObj = (MFWNodeObject)nameObjs.get(idx);
                String aName = aNameObj.getPropertyValue(MFWCrnIDAdvancedLookup.gModelRes.RID__Value);
                if (!sName.equals(aName)) continue;
                return true;
            }
        }
        return false;
    }

    private MFWNodeObject lookChildrenByName(MFWNodeObject objNode, short ridChildName, String sName) {
        List<MFWNode> vChildren = objNode.getObjectNodes(ridChildName);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            MFWNodeObject anObj = (MFWNodeObject)vChildren.get(idx);
            if (!this.doesNameMatch(anObj, sName)) continue;
            return anObj;
        }
        return null;
    }

    private MFWNodeObject lookChildrenByName(MFWNodeObject objNode, short ridChildName, short[] vContainerTypes, String sName) {
        ArrayList<MFWNodeObject> vChildren = new ArrayList<MFWNodeObject>();
        objNode.findObjectNodesRecursively(ridChildName, vContainerTypes, (short)-1, null, false, vChildren);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            MFWNodeObject anObj = vChildren.get(idx);
            if (!this.doesNameMatch(anObj, sName)) continue;
            return anObj;
        }
        return null;
    }
}

