/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;

public final class MFWCrnIDGenerator {
    public static final String FIXED_ID_PROJECT = "[]";
    public static final String FIXED_ID_SECURITYVIEWS = "[].[securityViews]";
    public static final String FIXED_ID_PARAMETERMAPS = "[].[parameterMaps]";
    public static final String FIXED_ID_DATASOURCES = "[].[dataSources]";
    private MFWCluster mCluster = null;
    private String mDesignLocale = null;
    private MFWIndexManager mIndexManager = null;
    private MFWInfoProperty mIDInfo = null;
    private static ObjIDTrait[] gObjIDTraits = new ObjIDTrait[27];

    public static short[] getCandidateTypesForIDEntry(short idEntryPosition) {
        short[] outArray = null;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        switch (idEntryPosition) {
            case 0: {
                outArray = new short[]{gModelRes.RID_namespace, gModelRes.RID_shortcut, gModelRes.RID_function};
                break;
            }
            case 1: {
                outArray = new short[]{gModelRes.RID_folder, gModelRes.RID_dimension, gModelRes.RID_querySubject, gModelRes.RID_updateSubject, gModelRes.RID_calculation, gModelRes.RID_filter, gModelRes.RID_shortcut, gModelRes.RID_relationship, gModelRes.RID_relationshipShortcut, gModelRes.RID_scopeRelationship};
                break;
            }
            case 2: {
                outArray = new short[]{gModelRes.RID_hierarchy, gModelRes.RID_hierarchyFolder, gModelRes.RID_queryItemFolder, gModelRes.RID_measureFolder, gModelRes.RID_queryItem, gModelRes.RID_measure};
                break;
            }
            case 3: {
                outArray = new short[]{gModelRes.RID_level, gModelRes.RID_queryItemFolder, gModelRes.RID_queryItem, gModelRes.RID_measure, gModelRes.RID_hierarchyNamedSet};
                break;
            }
            case 4: {
                outArray = new short[]{gModelRes.RID_queryItem, gModelRes.RID_measure};
                break;
            }
            default: {
                outArray = new short[]{gModelRes.RID_measure};
            }
        }
        return outArray;
    }

    public MFWCrnIDGenerator(MFWCluster aCluster) {
        MFWModelRes gRes = MFWModelRes.getInstance();
        MFWCrnIDGenerator.gObjIDTraits[0] = new ObjIDTrait(gRes.RID_project, true, false, false, FIXED_ID_PROJECT, null);
        MFWCrnIDGenerator.gObjIDTraits[1] = new ObjIDTrait(gRes.RID_namespace, true, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[2] = new ObjIDTrait(gRes.RID_dataSource, false, false, false, null, null);
        MFWCrnIDGenerator.gObjIDTraits[3] = new ObjIDTrait(gRes.RID_securityViews, true, false, false, FIXED_ID_SECURITYVIEWS, null);
        MFWCrnIDGenerator.gObjIDTraits[4] = new ObjIDTrait(gRes.RID_securityView, false, false, false, null, new short[]{gRes.RID_securityViews});
        MFWCrnIDGenerator.gObjIDTraits[5] = new ObjIDTrait(gRes.RID_parameterMaps, true, false, false, FIXED_ID_PARAMETERMAPS, null);
        MFWCrnIDGenerator.gObjIDTraits[6] = new ObjIDTrait(gRes.RID_parameterMap, false, false, false, null, new short[]{gRes.RID_parameterMaps});
        MFWCrnIDGenerator.gObjIDTraits[7] = new ObjIDTrait(gRes.RID_parameterMapEntry, false, false, false, null, new short[]{gRes.RID_parameterMap});
        MFWCrnIDGenerator.gObjIDTraits[8] = new ObjIDTrait(gRes.RID_folder, false, true, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[9] = new ObjIDTrait(gRes.RID_querySubject, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[10] = new ObjIDTrait(gRes.RID_dimension, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[11] = new ObjIDTrait(gRes.RID_updateSubject, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[12] = new ObjIDTrait(gRes.RID_queryItem, false, false, true, null, new short[]{gRes.RID_dimension, gRes.RID_querySubject, gRes.RID_updateSubject, gRes.RID_queryItemFolder, gRes.RID_hierarchy, gRes.RID_level});
        MFWCrnIDGenerator.gObjIDTraits[13] = new ObjIDTrait(gRes.RID_queryItemFolder, false, true, true, null, new short[]{gRes.RID_dimension, gRes.RID_querySubject, gRes.RID_updateSubject, gRes.RID_queryItemFolder, gRes.RID_hierarchy, gRes.RID_level});
        MFWCrnIDGenerator.gObjIDTraits[14] = new ObjIDTrait(gRes.RID_hierarchy, false, false, true, null, new short[]{gRes.RID_dimension, gRes.RID_hierarchyFolder});
        MFWCrnIDGenerator.gObjIDTraits[15] = new ObjIDTrait(gRes.RID_hierarchyFolder, false, true, true, null, new short[]{gRes.RID_dimension, gRes.RID_hierarchyFolder});
        MFWCrnIDGenerator.gObjIDTraits[16] = new ObjIDTrait(gRes.RID_level, false, false, true, null, new short[]{gRes.RID_hierarchy});
        MFWCrnIDGenerator.gObjIDTraits[17] = new ObjIDTrait(gRes.RID_hierarchyNamedSet, false, true, true, null, new short[]{gRes.RID_hierarchy});
        MFWCrnIDGenerator.gObjIDTraits[18] = new ObjIDTrait(gRes.RID_measure, false, false, true, null, new short[]{gRes.RID_dimension, gRes.RID_measure, gRes.RID_measureFolder});
        MFWCrnIDGenerator.gObjIDTraits[19] = new ObjIDTrait(gRes.RID_measureFolder, false, true, true, null, new short[]{gRes.RID_dimension, gRes.RID_measureFolder});
        MFWCrnIDGenerator.gObjIDTraits[20] = new ObjIDTrait(gRes.RID_calculation, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[21] = new ObjIDTrait(gRes.RID_filter, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[22] = new ObjIDTrait(gRes.RID_shortcut, false, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[23] = new ObjIDTrait(gRes.RID_relationship, false, false, false, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[24] = new ObjIDTrait(gRes.RID_relationshipShortcut, false, false, false, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[25] = new ObjIDTrait(gRes.RID_scopeRelationship, false, false, false, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        MFWCrnIDGenerator.gObjIDTraits[26] = new ObjIDTrait(gRes.RID_function, true, false, true, null, new short[]{gRes.RID_namespace, gRes.RID_folder});
        this.mCluster = aCluster;
        this.mIndexManager = aCluster.getIndexManager();
        this.mIDInfo = (MFWInfoProperty)MFWModel.getInstance().findInfoByRID(MFWModelRes.getInstance().RID_ID);
    }

    public void destroy() {
        this.mCluster = null;
        this.mIndexManager = null;
        this.mIDInfo = null;
        this.mDesignLocale = null;
    }

    private String getDesignLocale() {
        if (this.mDesignLocale == null) {
            MFWNodeObject projNode = this.mCluster.getRootNode().getObjectNode(MFWModelRes.getInstance().RID_project);
            MFWException.ASSERT(projNode != null, "The 'project' object must be present");
            this.mDesignLocale = projNode.getPropertyValue(MFWModelRes.getInstance().RID_defaultLocale);
            MFWException.ASSERT(this.mDesignLocale != null, "The required 'defaultLocale' property is missing");
        }
        return this.mDesignLocale;
    }

    public String generate(MFWNodeObject aFMObjNode, String aCaption, boolean doCleanName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ObjIDTrait objIDTrait = this.findIDTraitFor(aFMObjNode.getNameRID());
        MFWException.ASSERT(objIDTrait != null, "This method mst be called for node representing valid FM objects");
        String cleanedCaption = doCleanName ? MFWCrnIDHelper.cleanIDEntry(aCaption) : aCaption;
        String sParentID = "";
        if (aFMObjNode.getNameRID() == gModelRes.RID_dataSource) {
            sParentID = FIXED_ID_DATASOURCES;
        } else if (!objIDTrait.mIsIDRoot && objIDTrait.mFixedID == null) {
            for (MFWNodeObject objParent = aFMObjNode.getParentObject(); objParent != null; objParent = objParent.getParentObject()) {
                ObjIDTrait anIDTrait = this.findIDTraitFor(objParent.getNameRID());
                boolean isSkipped = anIDTrait.mIsSkipped;
                if (anIDTrait.mObjectRID == gModelRes.RID_queryItemFolder) {
                    boolean bl = isSkipped = objParent.getPropertyValue(gModelRes.RID_datatype) == null;
                }
                if (anIDTrait == null || !anIDTrait.mIsIDRoot && anIDTrait.mFixedID == null && isSkipped) continue;
                sParentID = this.getObjectID(objParent, anIDTrait);
                break;
            }
        }
        String sID = objIDTrait.mFixedID != null ? objIDTrait.mFixedID : MFWCrnIDHelper.addEntryToID(sParentID, cleanedCaption);
        String sUsedName = cleanedCaption;
        int seqNo = 0;
        while (this.mIndexManager.lookup(this.mIDInfo, sID) != null) {
            sUsedName = cleanedCaption + Integer.toString(++seqNo);
            sID = MFWCrnIDHelper.addEntryToID(sParentID, sUsedName.toString());
        }
        aFMObjNode.addProperty(MFWModelRes.getInstance().RID_ID, sID);
        return sUsedName;
    }

    public void generate(MFWNodeObject objNode, MFWInfoProperty currProp) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String idName = null;
        MFWNodeObject fmObject = null;
        if (currProp == null) {
            String id;
            if (objNode.getNameRID() != gModelRes.RID_name) {
                return;
            }
            String locale = objNode.getPropertyValue(gModelRes.RID_locale);
            if (locale == null ? (id = (fmObject = objNode.getParentObject()).getPropertyValue(gModelRes.RID_ID)) != null : !this.getDesignLocale().equals(locale)) {
                return;
            }
            fmObject = objNode.getParentObject();
            if (fmObject.getNameRID() == gModelRes.RID_shortcut || fmObject.getNameRID() == gModelRes.RID_role) {
                return;
            }
            idName = objNode.getPropertyValue(MFWModelRes.getInstance().RID__Value);
            MFWException.ASSERT(idName != null && idName.length() > 0, "Expecting a valid name for object of type", fmObject.getName());
        } else {
            if (!(currProp.getRID() == gModelRes.RID_name || currProp.getRID() == gModelRes.RID_key && objNode.getNameRID() == gModelRes.RID_parameterMapEntry || currProp.getRID() == gModelRes.RID_targetType && objNode.getNameRID() == gModelRes.RID_shortcut)) {
                return;
            }
            fmObject = objNode;
            if (objNode.getNameRID() == gModelRes.RID_shortcut) {
                ArrayList<MFWNodeObject> vNames = new ArrayList<MFWNodeObject>();
                objNode.findObjectNodes(gModelRes.RID_name, gModelRes.RID_locale, this.getDesignLocale(), vNames);
                if (vNames.size() > 0) {
                    idName = vNames.get(0).getPropertyValue(gModelRes.RID__Value);
                }
            } else {
                idName = objNode.getPropertyValue(currProp.getRID());
            }
        }
        ObjIDTrait objIDTrait = this.findIDTraitFor(fmObject.getNameRID());
        if (objIDTrait == null) {
            return;
        }
        if (objIDTrait.mFixedID != null) {
            fmObject.addProperty(gModelRes.RID_ID, objIDTrait.mFixedID);
            return;
        }
        MFWException.ASSERT(idName != null, "Object name cannot be empty.");
        if (fmObject.getNameRID() == gModelRes.RID_shortcut) {
            String targetType = fmObject.getPropertyValue(gModelRes.RID_targetType);
            MFWException.ASSERT(targetType != null, "Target type expected. MFWCrnIDGenerator::GenerateIDForobjShortcut");
            if ("namespace".equals(targetType) || "folder".equals(targetType)) {
                String sID = MFWCrnIDHelper.addEntryToID("", idName);
                fmObject.addProperty(gModelRes.RID_ID, sID);
                return;
            }
        }
        String sParentID = "";
        if (fmObject.getNameRID() == gModelRes.RID_dataSource) {
            sParentID = FIXED_ID_DATASOURCES;
        } else if (!objIDTrait.mIsIDRoot) {
            for (MFWNodeObject aParent = fmObject.getParentObject(); aParent != null; aParent = aParent.getParentObject()) {
                ObjIDTrait anIDTrait = this.findIDTraitFor(aParent.getNameRID());
                boolean isSkipped = anIDTrait.mIsSkipped;
                if (anIDTrait.mObjectRID == gModelRes.RID_queryItemFolder) {
                    boolean bl = isSkipped = aParent.getPropertyValue(gModelRes.RID_datatype) == null;
                }
                if (anIDTrait == null || !anIDTrait.mIsIDRoot && anIDTrait.mFixedID == null && isSkipped) continue;
                sParentID = this.getObjectID(aParent, anIDTrait);
                break;
            }
        }
        String sID = MFWCrnIDHelper.addEntryToID(sParentID, idName);
        fmObject.addProperty(gModelRes.RID_ID, sID);
    }

    public short[] getContainerTypes(short ridObjName) {
        ObjIDTrait anIDTrait = this.findIDTraitFor(ridObjName);
        if (anIDTrait == null) {
            StringBuffer msg = new StringBuffer("Unable to find containment information for type :");
            msg.append(MFWModelRes.getInstance().getResource(ridObjName));
            MFWException.ASSERT(false, msg.toString());
        }
        return anIDTrait.mRIDContainers;
    }

    private ObjIDTrait findIDTraitFor(short ridObj) {
        ObjIDTrait outTrait = null;
        for (int idx = 0; outTrait == null && idx < gObjIDTraits.length; ++idx) {
            if (MFWCrnIDGenerator.gObjIDTraits[idx].mObjectRID != ridObj) continue;
            outTrait = gObjIDTraits[idx];
        }
        return outTrait;
    }

    private String getObjectID(MFWNodeObject objNode, ObjIDTrait objIDTrait) {
        String outID = null;
        if (objIDTrait.mFixedID != null) {
            outID = objIDTrait.mFixedID;
        } else {
            outID = objNode.getPropertyValue(MFWModelRes.getInstance().RID_ID);
            if (outID == null) {
                StringBuffer msg = new StringBuffer("unable to find an ID for object '");
                msg.append(objNode.getName());
                msg.append("'");
                MFWException.ASSERT(false, msg.toString());
            }
        }
        return outID;
    }

    private static final class ObjIDTrait {
        short mObjectRID;
        boolean mIsIDRoot;
        boolean mIsSkipped;
        String mFixedID;
        short[] mRIDContainers;

        ObjIDTrait(short objRID, boolean isIDRoot, boolean isSkipped, boolean hasLocalizedName, String fixedID, short[] ridContainers) {
            this.mObjectRID = objRID;
            this.mIsIDRoot = isIDRoot;
            this.mIsSkipped = isSkipped;
            this.mFixedID = fixedID;
            this.mRIDContainers = ridContainers;
        }
    }
}

