/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWClusterOwner;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWGatewayReuseIndicator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWXPathEvaluator;
import com.cognos.mfw4j.framework.log.MFWLogCrnIdResolution;
import com.cognos.mfw4j.framework.log.MFWLogEventObject;
import com.cognos.mfw4j.framework.log.MFWLogFindChildObjects;
import com.cognos.mfw4j.framework.log.MFWLogGateway;
import com.cognos.mfw4j.framework.log.MFWLogGetAllChildren;
import com.cognos.mfw4j.framework.log.MFWLogGetAssociatedMetadataSource;
import com.cognos.mfw4j.framework.log.MFWLogGetChildrenRID;
import com.cognos.mfw4j.framework.log.MFWLogGetPropertyValue;
import com.cognos.mfw4j.framework.log.MFWLogGetValue;
import com.cognos.mfw4j.framework.log.MFWLogQuery;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKey;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKeyIndexed;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKeyXPath;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.List;

final class MFWGatewayImpl
extends MFWGateway
implements MFWClusterOwner {
    private static final boolean API_Logging_Enabled = MFWConfiguration.getInstance().isGatewayLoggingenabled();
    private static final String TAG_QUERY = "MFW4j/MFWGatewayImpl/query";
    private static final String TAG_GET_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getPropertyValue";
    private static final String TAG_GET_BOOLEAN_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getBooleanPropertyValue";
    private static final String TAG_GET_ENUM_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getEnumPropertyValue";
    private static final String TAG_GET_REFERENCED_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getReferencePropertyValue";
    private static final String TAG_QUERY_OBJECT = "MFW4j/MFWGatewayImpl/queryObject";
    private static final String TAG_GET_OBJECT_CHILDREN = "MFW4j/MFWGatewayImpl/getObjectChildren";
    private static final String TAG_GET_ALL_OBJECT_CHILDREN = "MFW4j/MFWGatewayImpl/getAllObjectChildren";
    private static final String TAG_FIND_CHILD_OBJECTS = "MFW4j/MFWGatewayImpl/findChildObjects";
    private static final String TAG_GET_OBJECT_PROPERTY_VALUES = "MFW4j/MFWGatewayImpl/getObjectPropertyValues";
    private static final String TAG_GET_OBJECT_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getObjectPropertyValue";
    private static final String TAG_GET_OBJECT_BOOLEAN_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getObjectBooleanPropertyValue";
    private static final String TAG_GET_OBJECT_ENUM_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getObjectEnumPropertyValue";
    private static final String TAG_GET_OBJECT_REFERENCED_PROPERTY_VALUE = "MFW4j/MFWGatewayImpl/getObjectReferencePropertyValue";
    private static final String TAG_GET_ASSOSIATED_METADATA_SERVICE = "MFW4j/MFWGatewayImpl/getAssociatedMetadataSource";
    private static final String TAG_RESOLVE_CRN_ID = "MFW4j/MFWGatewayImpl/resolveCrnID";
    private static final String TAG_GET_NODE_BY_KEY = "MFW4j/MFWGatewayImpl/getNodeByKey";
    private static final String TAG_GET_REUSE_INDICATOR = "MFW4j/MFWGatewayImpl/getReuseIndicator";
    private static final String TAG_LOOKUP_OBJECTS_BY_TYPE = "MFW4j/MFWGatewayImpl/lookupObjectsByType";
    private String mID;
    private MFWRequestContextUser mContext;
    private MFWCluster mCluster = null;
    private IMFWUsageIndicator mXQEUsageIndicatorService = null;

    MFWGatewayImpl(String anID, MFWRequestContextUser aContext) {
        this.mContext = aContext;
        StringBuilder temp = new StringBuilder(anID);
        temp.append(Integer.toString(this.hashCode()));
        this.mID = temp.toString();
        this.mXQEUsageIndicatorService = aContext.getXQEUsageIndicatorService();
    }

    void destroy() {
        MFWLogGateway log = new MFWLogGateway("GW:destroy", this.mID, this.mCluster);
        try {
            if (this.mCluster != null) {
                this.mCluster.getConnection().getAdaptor().unregisterOwner(this, this.mCluster, this.mContext);
            }
            if (this.mContext != null) {
                this.mContext.destroy();
            }
            this.mContext = null;
            this.mCluster = null;
        }
        catch (RuntimeException t) {
            log.logEnd(t);
            throw t;
        }
        log.logEnd();
    }

    @Override
    public boolean isStale(boolean ignoreRetainPeriod) {
        return false;
    }

    @Override
    public boolean isStale(boolean ignoreRetainPeriod, MFWMetadataSource metadataSrc) {
        return this.isStale(ignoreRetainPeriod, metadataSrc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStale(boolean ignoreRetainPeriod, MFWMetadataSource metadataSrc, boolean isMetadataRequest) {
        this.mContext.setIgnoreMetadataUpdateRetainPeriod(ignoreRetainPeriod);
        this.mContext.setMetadataRequest(isMetadataRequest);
        try {
            if (this.mCluster != null) {
                boolean bl = this.mCluster.isStale(this.mContext, metadataSrc);
                return bl;
            }
        }
        finally {
            this.mContext.setIgnoreMetadataUpdateRetainPeriod(false);
        }
        return false;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder msg = new StringBuilder("Gateway: ");
        msg.append(this.mID);
        return msg.toString();
    }

    MFWRequestContextUser getRequestContext() {
        return this.mContext;
    }

    void setCluster(MFWCluster aCluster) {
        this.mCluster = aCluster;
    }

    @Override
    public MFWRequestContext getContext() {
        return this.mContext;
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public MFWNodeHandle[] query(MFWQuerySpec aQuerySpec) {
        ArrayList<MFWNode> outResult = new ArrayList<MFWNode>();
        MFWLogQuery log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogQuery(1, "GW:query(aQuerySpec)", this, aQuerySpec, null);
        }
        MFWNodeHandle[] outHandles = null;
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWXPathEvaluator evaluator = new MFWXPathEvaluator(this.mContext);
            evaluator.evaluate(this.mCluster.getRootNode(), aQuerySpec, outResult);
            outHandles = this.issueNodeHandles(outResult);
            executionTime = System.currentTimeMillis() - runTime;
            if (API_Logging_Enabled) {
                log.setResultHandles(outHandles);
            }
        }
        catch (RuntimeException t) {
            if (API_Logging_Enabled) {
                log.logEnd(t);
            }
            throw t;
        }
        if (API_Logging_Enabled) {
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_QUERY, executionTime);
        }
        return outHandles;
    }

    @Override
    public String getPropertyValue(MFWNodeHandle handleProp) {
        MFWException.ASSERT(handleProp.isProperty(), "Expecting a valid handle to an property node");
        MFWLogGetValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetValue("GW:getPropertyValue", this, handleProp);
        }
        String outValue = null;
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNodeHandle handleParent = handleProp.getParent();
            MFWException.ASSERT(handleParent != null, "getPropertyValue expects a valid parent object");
            MFWNodeProperty propNode = (MFWNodeProperty)handleProp;
            outValue = propNode.getValue();
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public boolean getBooleanPropertyValue(MFWNodeHandle handleProp) {
        MFWException.ASSERT(handleProp.isProperty(), "Expecting a valid handle to an property node");
        MFWLogGetValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetValue("GW:getBooleanPropertyValue", this, handleProp);
        }
        boolean outValue = false;
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNodeHandle handleParent = handleProp.getParent();
            MFWException.ASSERT(handleParent != null, "getPropertyValue expects a valid parent object");
            MFWNodeProperty propNode = (MFWNodeProperty)handleProp;
            outValue = propNode.getBooleanValue();
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outValue ? "true" : "false");
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_BOOLEAN_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public int getEnumPropertyValue(MFWNodeHandle handleProp) {
        MFWException.ASSERT(handleProp.isProperty(), "Expecting a valid handle to an property node");
        MFWLogGetValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetValue("GW:getEnumPropertyValue", this, handleProp);
        }
        int outValue = 0;
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNodeHandle handleParent = handleProp.getParent();
            MFWException.ASSERT(handleParent != null, "getPropertyValue expects a valid parent object");
            MFWNodeProperty propNode = (MFWNodeProperty)handleProp;
            outValue = propNode.getEnumValue();
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(Integer.toString(outValue));
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_ENUM_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public MFWNodeHandle getReferencePropertyValue(MFWNodeHandle handleProp) {
        MFWException.ASSERT(handleProp.isProperty(), "Expecting a valid handle to an property node");
        MFWLogGetValue log = null;
        long executionTime = 0L;
        if (API_Logging_Enabled) {
            log = new MFWLogGetValue("GW:getReferencePropertyValue", this, handleProp);
        }
        MFWNodeObject outValue = null;
        String refValue = null;
        try {
            long runTime = System.currentTimeMillis();
            MFWNodeHandle handleParent = handleProp.getParent();
            MFWException.ASSERT(handleParent != null, "getPropertyValue expects a valid parent object");
            MFWNodeProperty propNode = (MFWNodeProperty)handleProp;
            outValue = this.mCluster.lookup(MFWModel.getInstance().getIDPropertyInfo(), propNode.getValue(), this.mContext, null);
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(refValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_REFERENCED_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public MFWNodeHandle[] queryObject(MFWNodeHandle handleObj, MFWQuerySpec aQuerySpec) {
        MFWException.ASSERT(handleObj.isObject(), "Expecting a valid handle to an object node");
        MFWNodeHandle[] outHandles = null;
        ArrayList<MFWNode> outResult = new ArrayList<MFWNode>();
        long executionTime = 0L;
        MFWLogEventObject lq = null;
        if (API_Logging_Enabled) {
            lq = new MFWLogQuery(0, "GW:queryObject(handleObj, aQuerySpec)", this, aQuerySpec, handleObj);
        }
        try {
            long runTime = System.currentTimeMillis();
            MFWNodeObject parentObj = (MFWNodeObject)handleObj;
            MFWXPathEvaluator evaluator = new MFWXPathEvaluator(this.mContext);
            evaluator.evaluate(parentObj, aQuerySpec, outResult);
            outHandles = this.issueNodeHandles(outResult);
            executionTime = System.currentTimeMillis() - runTime;
            if (API_Logging_Enabled) {
                ((MFWLogQuery)lq).setResultHandles(outHandles);
            }
        }
        catch (RuntimeException t) {
            if (API_Logging_Enabled) {
                lq.logEnd(t);
            }
            throw t;
        }
        if (API_Logging_Enabled) {
            lq.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_QUERY_OBJECT, executionTime);
        }
        return outHandles;
    }

    @Override
    public MFWNodeHandle[] getObjectChildren(MFWNodeHandle handleObj, short ridChildName) {
        MFWException.ASSERT(handleObj.isObject(), "Expecting a valid handle to an object node");
        ArrayList<MFWNode> outResult = new ArrayList<MFWNode>();
        MFWNodeHandle[] outHandles = null;
        MFWLogGetChildrenRID log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetChildrenRID("GW:GetObjectChildren(handleObj, ridChildName)", this, ridChildName, handleObj);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            this.getObjectChildrenInternal((MFWNodeObject)handleObj, ridChildName, outResult);
            outHandles = this.issueNodeHandles(outResult);
            executionTime = System.currentTimeMillis() - runTime;
            if (API_Logging_Enabled) {
                log.setResultHandles(outHandles);
            }
        }
        catch (RuntimeException t) {
            if (API_Logging_Enabled) {
                log.logEnd(t);
            }
            throw t;
        }
        if (API_Logging_Enabled) {
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_CHILDREN, executionTime);
        }
        return outHandles;
    }

    @Override
    public MFWNodeHandle[] getAllObjectChildren(MFWNodeHandle handleObj) {
        MFWNodeHandle[] outHandles = null;
        ArrayList<MFWNode> outResult = new ArrayList<MFWNode>();
        MFWLogGetAllChildren log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetAllChildren("GW:getAllObjectChildren(handleObj)", this, handleObj);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWException.ASSERT(handleObj.isObject(), "Expecting a valid handle to an object node");
            MFWNodeObject parentObj = (MFWNodeObject)handleObj;
            parentObj.queryAllChildren(this.mContext, outResult);
            outHandles = this.issueNodeHandles(outResult);
            executionTime = System.currentTimeMillis() - runTime;
            if (API_Logging_Enabled) {
                log.setResultHandles(outHandles);
            }
        }
        catch (RuntimeException t) {
            if (API_Logging_Enabled) {
                log.logEnd(t);
            }
            throw t;
        }
        if (API_Logging_Enabled) {
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_ALL_OBJECT_CHILDREN, executionTime);
        }
        return outHandles;
    }

    @Override
    public MFWNodeHandle[] findChildObjects(MFWNodeHandle handleObj, short ridChildObjName, short ridPropName, String aPropValue) {
        long executionTime;
        MFWLogFindChildObjects log;
        MFWNodeHandle[] outHandles;
        block8: {
            ArrayList<MFWNode> outResults = new ArrayList<MFWNode>();
            MFWException.ASSERT(handleObj.isObject(), "Expecting a valid handle to an object node");
            MFWException.ASSERT(ridPropName != -1, "findChildObjects method expects a valid filter property");
            outHandles = null;
            log = null;
            if (API_Logging_Enabled) {
                log = new MFWLogFindChildObjects("GW:findChildObjects(handleObj, ricChildObjName, ridPropName, aPropValue)", this, handleObj, ridChildObjName, ridPropName, aPropValue);
            }
            executionTime = 0L;
            try {
                long runTime = System.currentTimeMillis();
                ArrayList<MFWNode> vObjs = new ArrayList<MFWNode>();
                this.getObjectChildrenInternal((MFWNodeObject)handleObj, ridChildObjName, vObjs);
                for (int idx = 0; idx < vObjs.size(); ++idx) {
                    MFWNodeObject anObj = (MFWNodeObject)vObjs.get(idx);
                    ArrayList<MFWNode> vProps = new ArrayList<MFWNode>();
                    this.getObjectChildrenInternal(anObj, ridPropName, vProps);
                    if (vProps.isEmpty()) continue;
                    if (aPropValue == null) {
                        outResults.add(vObjs.get(idx));
                        continue;
                    }
                    MFWNodeProperty aProp = (MFWNodeProperty)vProps.get(0);
                    if (!aPropValue.equals(aProp.getValue())) continue;
                    outResults.add(vObjs.get(idx));
                }
                outHandles = this.issueNodeHandles(outResults);
                executionTime = System.currentTimeMillis() - runTime;
                if (API_Logging_Enabled) {
                    log.setResultHandles(outHandles);
                }
            }
            catch (RuntimeException t) {
                if (!API_Logging_Enabled) break block8;
                log.logEnd(t);
            }
        }
        if (API_Logging_Enabled) {
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_FIND_CHILD_OBJECTS, executionTime);
        }
        return outHandles;
    }

    @Override
    public List<String> getObjectPropertyValues(MFWNodeHandle handleObj, short ridPropName) {
        ArrayList<String> outList = null;
        MFWLogGetPropertyValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetPropertyValue("queryProperties", "GW:getObjectPropertyValues", this, handleObj, ridPropName);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            ArrayList<MFWNode> vPropNodes = new ArrayList<MFWNode>();
            this.getObjectChildrenInternal((MFWNodeObject)handleObj, ridPropName, vPropNodes);
            if (!vPropNodes.isEmpty()) {
                outList = new ArrayList<String>(vPropNodes.size());
                for (MFWNode aNode : vPropNodes) {
                    outList.add(((MFWNodeProperty)aNode).getValue());
                }
            }
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outList);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_PROPERTY_VALUES, executionTime);
        }
        return outList;
    }

    @Override
    public String getObjectPropertyValue(MFWNodeHandle handleObj, short ridPropName) {
        String outValue = null;
        MFWLogGetPropertyValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetPropertyValue("queryProperty", "GW:getObjectPropertyValue", this, handleObj, ridPropName);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNode outNode = this.getObjectSingleChild(handleObj, ridPropName, (short)1);
            if (outNode != null) {
                outValue = ((MFWNodeProperty)outNode).getValue();
            }
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public boolean getObjectBooleanPropertyValue(MFWNodeHandle handleObj, short ridPropName) {
        boolean outValue = false;
        MFWLogGetPropertyValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetPropertyValue("queryProperty", "GW:getObjectBooleanPropertyValue", this, handleObj, ridPropName);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNode outNode = this.getObjectSingleChild(handleObj, ridPropName, (short)1);
            if (outNode != null) {
                outValue = ((MFWNodeProperty)outNode).getBooleanValue();
            }
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_BOOLEAN_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public int getObjectEnumPropertyValue(MFWNodeHandle handleObj, short ridPropName) {
        int outValue = -1;
        MFWLogGetPropertyValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetPropertyValue("queryProperty", "GW:getObjectEnumPropertyValue", this, handleObj, ridPropName);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNode outNode = this.getObjectSingleChild(handleObj, ridPropName, (short)1);
            if (outNode != null) {
                outValue = ((MFWNodeProperty)outNode).getEnumValue();
            }
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(outValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_ENUM_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public MFWNodeHandle getObjectReferencePropertyValue(MFWNodeHandle handleObj, short ridPropName) {
        MFWNodeObject outValue = null;
        String refValue = null;
        MFWLogGetPropertyValue log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetPropertyValue("queryProperty", "GW:getObjectReferencePropertyValue", this, handleObj, ridPropName);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWNode outNode = this.getObjectSingleChild(handleObj, ridPropName, (short)1);
            if (outNode != null) {
                MFWNodeProperty refProp = (MFWNodeProperty)outNode;
                refValue = refProp.getValue();
                outValue = this.mCluster.lookup(MFWModel.getInstance().getIDPropertyInfo(), refValue, this.mContext, null);
            }
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.setResult(refValue);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_OBJECT_REFERENCED_PROPERTY_VALUE, executionTime);
        }
        return outValue;
    }

    @Override
    public MFWMetadataSource getAssociatedMetadataSource(MFWNodeHandle handleNode) {
        MFWConnection aConn = null;
        MFWLogGetAssociatedMetadataSource log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogGetAssociatedMetadataSource("GW:getAssociatedMetadataSource", this, handleNode);
        }
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            MFWCluster ownerCluster = ((MFWNode)handleNode).getCluster();
            aConn = ownerCluster.getConnection();
            executionTime = System.currentTimeMillis() - runTime;
            if (API_Logging_Enabled) {
                log.setMetadataSource(aConn.getSource());
            }
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        if (API_Logging_Enabled) {
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_ASSOSIATED_METADATA_SERVICE, executionTime);
        }
        return aConn.getSource();
    }

    private void getObjectChildrenInternal(MFWNodeObject parentObj, short ridChildName, ArrayList<MFWNode> outList) {
        parentObj.queryChild(this.mContext, ridChildName, outList);
    }

    private MFWNode getObjectSingleChild(MFWNodeHandle handleObj, short ridChildName, short nodeType) {
        MFWNodeObject parentObj = (MFWNodeObject)handleObj;
        MFWNode outNode = parentObj.querySingleChild(this.mContext, ridChildName);
        return outNode;
    }

    @Override
    public MFWNodeHandle[] resolveCrnID(String crnId) {
        MFWLogCrnIdResolution log = null;
        if (API_Logging_Enabled) {
            log = new MFWLogCrnIdResolution("GW:resolveCrnID", this, crnId);
        }
        MFWException.ASSERT(crnId != null && crnId.length() > 0, "Expecting a valid CRN Id");
        ArrayList<MFWNodeObject> ancestorsChain = new ArrayList<MFWNodeObject>();
        long executionTime = 0L;
        try {
            long runTime = System.currentTimeMillis();
            this.mCluster.lookup(MFWModel.getInstance().getIDPropertyInfo(), crnId, this.mContext, ancestorsChain);
            executionTime = System.currentTimeMillis() - runTime;
        }
        catch (RuntimeException rt) {
            if (API_Logging_Enabled) {
                log.logEnd(rt);
            }
            throw rt;
        }
        MFWNodeHandle[] nodehandles = this.issueNodeHandles(ancestorsChain);
        if (API_Logging_Enabled) {
            log.setResultHandles(nodehandles);
            log.logEnd();
        }
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_RESOLVE_CRN_ID, executionTime);
        }
        return nodehandles;
    }

    private MFWNodeHandle[] issueNodeHandles(ArrayList<? extends MFWNode> resultNodes) {
        MFWNodeHandle[] outHandles = new MFWNodeHandle[resultNodes.size()];
        resultNodes.toArray(outHandles);
        return outHandles;
    }

    @Override
    public MFWNodeKey getNodeKey(MFWNodeHandle hNode) {
        MFWNodeKey aNodeKey = MFWNodeKey.buildKey(hNode);
        return aNodeKey;
    }

    @Override
    public MFWNodeHandle getNodeByKey(MFWNodeKey kNode) {
        long runTime = System.currentTimeMillis();
        if (kNode instanceof MFWNodeKeyIndexed) {
            return this.mCluster.lookup(MFWModel.getInstance().getIDPropertyInfo(), ((MFWNodeKeyIndexed)kNode).getIndexedKey(), this.mContext, null);
        }
        MFWException.ASSERT(kNode instanceof MFWNodeKeyXPath, "Unexpected node key type");
        String xPath = ((MFWNodeKeyXPath)kNode).getXPath();
        ArrayList<MFWNode> outResult = new ArrayList<MFWNode>(1);
        MFWXPathEvaluator evaluator = new MFWXPathEvaluator(this.mContext);
        evaluator.evaluate(this.mCluster.getRootNode(), MFWQuerySpec.create(xPath), outResult);
        MFWNodeHandle[] outHandles = this.issueNodeHandles(outResult);
        long executionTime = System.currentTimeMillis() - runTime;
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_NODE_BY_KEY, executionTime);
        }
        return outHandles.length > 0 ? outHandles[0] : null;
    }

    @Override
    public MFWGatewayReuseIndicator getReuseIndicator() {
        long runTime = System.currentTimeMillis();
        MFWGatewayReuseIndicator outIndicator = new MFWGatewayReuseIndicator();
        outIndicator.addCluster(this.mCluster.getConnection().getReuseInfo().getPersistentClusterFilePath());
        outIndicator.digest();
        long executionTime = System.currentTimeMillis() - runTime;
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_GET_REUSE_INDICATOR, executionTime);
        }
        return outIndicator;
    }

    @Override
    public MFWNodeHandle[] lookupObjectsByType(short classGUID) {
        long runTime = System.currentTimeMillis();
        ArrayList<MFWNodeObject> outObjs = new ArrayList<MFWNodeObject>(100);
        this.mCluster.getIndexManager().lookupObjectsByType(classGUID, outObjs);
        List<MFWCluster> linkedClusters = this.mCluster.connectAllLinkedClustersFor(this.mContext);
        for (MFWCluster linkCluster : linkedClusters) {
            linkCluster.getIndexManager().lookupObjectsByType(classGUID, outObjs);
        }
        MFWNodeHandle[] outHandles = new MFWNodeHandle[outObjs.size()];
        outObjs.toArray(outHandles);
        long executionTime = System.currentTimeMillis() - runTime;
        if (this.mXQEUsageIndicatorService != null) {
            this.mXQEUsageIndicatorService.logMeasurements(TAG_LOOKUP_OBJECTS_BY_TYPE, executionTime);
        }
        return outHandles;
    }

    @Override
    public boolean hasRoleBasedSecurityViews() {
        return true;
    }

    @Override
    public boolean hasUserSecurityViews() {
        return true;
    }
}

