/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class MFWInfoObjectImpl
extends MFWInfoObject {
    private ArrayList<ChildInfo> mChildren = new ArrayList();
    private short[] mChildrenRIDs = null;
    private short mInitialChildrenListSize = 0;
    private short mNumberOfChildProperties = 0;
    private boolean mIsIndexed = false;
    private static final ChildComparator gChildCmpr = new ChildComparator();

    MFWInfoObjectImpl(String aName, short aGUID) {
        super(aName, aGUID);
    }

    @Override
    public MFWInfo findChildInfo(String childName) {
        short childRID = MFWModelRes.getInstance().getResourceID(childName);
        return this.findChildInfo(childRID);
    }

    @Override
    public boolean isIndexed() {
        return this.mIsIndexed;
    }

    void setIndexed(boolean isIndexed) {
        this.mIsIndexed = isIndexed;
    }

    public short getNumberOfChildProperties() {
        return this.mNumberOfChildProperties;
    }

    @Override
    public MFWInfo findChildInfo(short childRID) {
        ChildInfo anInfo = this.lookupChildInfo(childRID);
        if (anInfo == null) {
            return null;
        }
        return anInfo.mInfo;
    }

    @Override
    public MFWInfo findChildInfoByGUID(short childGUID) {
        for (int idx = 0; idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            if (this.mChildren.get(idx).mInfo.getGUID() != childGUID) continue;
            return anInfo.mInfo;
        }
        return null;
    }

    @Override
    public short findChildMultiplicity(short childRID) {
        ChildInfo anInfo = this.lookupChildInfo(childRID);
        if (anInfo == null) {
            return 0;
        }
        return anInfo.mMultiplicity;
    }

    @Override
    public MFWInfo[] getChildrenInfo() {
        if (this.mChildren.size() == 0) {
            return null;
        }
        MFWInfo[] infoChildren = new MFWInfo[this.mChildren.size()];
        for (int idx = 0; idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            infoChildren[idx] = anInfo.mInfo;
        }
        return infoChildren;
    }

    public ChildInfo findDetailedChildInfo(short childRID) {
        return this.lookupChildInfo(childRID);
    }

    public List<ChildInfo> getDetailedChildrenInfo() {
        return this.mChildren;
    }

    public int getChildrenSize() {
        return this.mChildrenRIDs.length;
    }

    public int getChildIndex(short ridChild) {
        int idx = Arrays.binarySearch(this.mChildrenRIDs, ridChild);
        if (idx < 0) {
            StringBuffer msg = new StringBuffer("Unable to locate the child ");
            msg.append(Integer.toString(ridChild));
            msg.append(" for object ");
            msg.append(this.getName());
            MFWException.ASSERT(false, msg.toString());
        }
        return idx;
    }

    void sortChildren() {
        Collections.sort(this.mChildren, gChildCmpr);
        this.mChildrenRIDs = new short[this.mChildren.size()];
        for (int idx = 0; idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            this.mChildrenRIDs[idx] = anInfo.mInfo.getRID();
            anInfo.mOverallIndex = (short)idx;
            if (anInfo.getInfo().getNodeType() == 1) {
                anInfo.mPropIndex = this.mNumberOfChildProperties;
                this.mNumberOfChildProperties = (short)(this.mNumberOfChildProperties + 1);
                continue;
            }
            anInfo.mPropIndex = (short)-1;
        }
    }

    void addChildInfo(MFWInfo childInfo, short aMultiplicity) {
        this.ensureUniqueness(childInfo);
        this.mChildren.add(new ChildInfo(aMultiplicity, childInfo));
        if (childInfo.getNodeType() == 2) {
            this.updateInitialChildrenListSize(aMultiplicity);
        }
        childInfo.addParent(this);
    }

    void addUnResolvedChildInfo(MFWInfo childInfo, short aMultiplicity) {
        this.mChildren.add(new ChildInfo(aMultiplicity, childInfo));
        if (childInfo.getNodeType() == 2) {
            this.updateInitialChildrenListSize(aMultiplicity);
        }
    }

    private void updateInitialChildrenListSize(short aMultiplicity) {
        switch (aMultiplicity) {
            case 2: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mInitialChildrenListSize = (short)(this.mInitialChildrenListSize + 1);
            }
        }
    }

    public short getInitialChildrenListSize() {
        return this.mInitialChildrenListSize;
    }

    void resolveChildInfo(String childName, MFWInfo aChildInfo) {
        ChildInfo unrsvldInfo = null;
        for (int idx = 0; unrsvldInfo == null && idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            if (!anInfo.mInfo.getName().equals(childName)) continue;
            unrsvldInfo = anInfo;
        }
        MFWException.ASSERT(unrsvldInfo != null, "Unable to find child info for ", childName);
        unrsvldInfo.mInfo = aChildInfo;
        aChildInfo.addParent(this);
    }

    private ChildInfo lookupChildInfo(short childRID) {
        ChildInfo outInfo = null;
        int idx = Arrays.binarySearch(this.mChildrenRIDs, childRID);
        if (idx >= 0) {
            outInfo = this.mChildren.get(idx);
        }
        return outInfo;
    }

    private void ensureUniqueness(MFWInfo childInfo) {
        for (int idx = 0; idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            if (anInfo.mInfo.getRID() != childInfo.getRID()) continue;
            StringBuffer msg = new StringBuffer(this.getName());
            msg.append(" already contains a child prperty/object with the same name:");
            msg.append(childInfo.getName());
            MFWException.ASSERT(false, msg.toString());
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer("MFWObjectInfo:");
        out.append(this.getName());
        out.append("\n\tNodes:");
        for (int idx = 0; idx < this.mChildren.size(); ++idx) {
            ChildInfo anInfo = this.mChildren.get(idx);
            out.append("\n\t\t");
            out.append(anInfo.mInfo.getName());
        }
        MFWInfoObject[] parents = this.getParents();
        out.append("\n\tParents:");
        for (int idx1 = 0; idx1 != parents.length; ++idx1) {
            out.append("\n\t\t");
            out.append(parents[idx1].getName());
        }
        return out.toString();
    }

    @Override
    void destroy() {
        super.destroy();
        this.mChildren.clear();
    }

    private static final class ChildComparator
    implements Comparator<ChildInfo> {
        private ChildComparator() {
        }

        @Override
        public int compare(ChildInfo obj1, ChildInfo obj2) {
            return obj1.mInfo.getRID() - obj2.mInfo.getRID();
        }
    }

    public static final class ChildInfo {
        private short mMultiplicity;
        private MFWInfo mInfo;
        private short mOverallIndex = 0;
        private short mPropIndex = 0;

        public short getMultiplicity() {
            return this.mMultiplicity;
        }

        public MFWInfo getInfo() {
            return this.mInfo;
        }

        public int getIndex() {
            return this.mOverallIndex;
        }

        public int getPropertyIndex() {
            return this.mPropIndex;
        }

        public boolean hasSingleMultiplicity() {
            return this.mMultiplicity == 2 || this.mMultiplicity == 1;
        }

        private ChildInfo(short aMultiplicity, MFWInfo anInfo) {
            this.mMultiplicity = aMultiplicity;
            this.mInfo = anInfo;
        }
    }
}

