/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.IOException;
import java.io.Writer;

public abstract class MFWLinkManager {
    protected MFWCluster mOwnerCluster = null;
    public static final short UNKNOWN_LINK_SOURCE = -1;

    protected MFWLinkManager(MFWCluster aCluster) {
        this.mOwnerCluster = aCluster;
    }

    public void destroy() {
        this.mOwnerCluster = null;
    }

    public abstract short findOrAddLink(MFWMetadataSource var1, MFWNodeObject var2);

    protected abstract MFWMetadataSource getLinkSource(short var1);

    protected abstract MFWNodeObject getLinkContainer(short var1);

    protected abstract short[] getLinkIDs();

    protected void setupGlobalLinks(MFWMetadataSource aSource, short idLink) {
        MFWNodeObject parmMaps;
        if ("modelPhysical".equals(aSource.getType()) || "modelPhysicalFM".equals(aSource.getType())) {
            return;
        }
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject projNode = this.mOwnerCluster.getRootNode().getObjectNode(gModelRes.RID_project);
        MFWException.ASSERT(projNode != null, "Expecting a valid project node - MFWLinkManager.setupGlobalLinks");
        projNode.addLinkNode(gModelRes.RID_dataSource, idLink, "/project/dataSource");
        projNode.addLinkNode(gModelRes.RID_qosOverride, idLink, "/project/qosOverride");
        MFWNodeObject secViews = projNode.getObjectNode(gModelRes.RID_securityViews);
        if (secViews != null) {
            secViews.addLinkNode(gModelRes.RID_securityView, idLink, "/project/securityViews/securityView");
        }
        if ((parmMaps = projNode.getObjectNode(gModelRes.RID_parameterMaps)) == null) {
            parmMaps = projNode.addObjectNode(gModelRes.RID_parameterMaps);
        }
        parmMaps.addLinkNode(gModelRes.RID_parameterMap, idLink, "/project/parameterMaps/parameterMap");
        if ("modelFM".equals(aSource.getType())) {
            projNode.addLinkNode(gModelRes.RID_modelDataSecurityObjects, idLink, "/project/modelDataSecurityObjects");
        }
    }

    public void asXML(Writer osw, boolean bDetailed) throws IOException {
        short[] idLinks = this.getLinkIDs();
        if (idLinks.length == 0) {
            return;
        }
        osw.write("<linkManager>");
        for (int idx = 0; idx < idLinks.length; ++idx) {
            osw.write("<linkSource id=\"");
            osw.write(Integer.toString(idx));
            osw.write("\">");
            MFWMetadataSource linkSrc = this.getLinkSource(idLinks[idx]);
            linkSrc.asXML(osw);
            MFWNodeObject nodeParent = this.getLinkContainer(idLinks[idx]);
            osw.write("<containerPath>");
            osw.write(MFWStringHelper.escapeXMLChars(nodeParent.getPropertyValue(MFWModelRes.getInstance().RID_ID)));
            osw.write("</containerPath>");
            osw.write("</linkSource>");
        }
        osw.write("</linkManager>");
    }

    protected static class Link {
        public MFWMetadataSource mMetadataSrc = null;
        public MFWNodeObject mLinkParent = null;

        public Link(MFWMetadataSource aMDSrc, MFWNodeObject linkParent) {
            this.mMetadataSrc = aMDSrc;
            this.mLinkParent = linkParent;
        }
    }
}

