/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.implPersistence.MFWStringPoolPrst;
import com.cognos.mfw4j.persistence.MFWPElement;
import com.cognos.mfw4j.persistence.MFWPElementInt;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class MFWMetadataSource
implements Cloneable {
    public static final String SOURCE_TYPE_MODEL_FM = "modelFM";
    public static final String SOURCE_TYPE_MODEL_PHYSICAL = "modelPhysical";
    public static final String SOURCE_TYPE_MODEL_PHYSICAL_FM = "modelPhysicalFM";
    public static final String SOURCE_TYPE_REPORT_CRN = "reportCRN";
    public static final String SOURCE_TYPE_JSON = "JSON";
    public static final String CONN_MODEL_FILE_PATH = "modelFilePath";
    public static final String CONN_CM_SEARCH_PATH = "cmSearchPath";
    public static final String CONN_CM_DATA_SOURCE = "cmDataSource";
    public static final String CONN_CM_MODIFICATION_TIME = "cmModificationTime";
    public static final String CONN_REPORT_NAME = "ReportName";
    public static final String CONN_SUPPRESS_REPORT_VALIDATION = "suppressReportValidation";
    public static final String CONN_EMBEDDED_CONTENT = "embeddedContent";
    public static final String CONN_CACHING_MODE = "cachingMode";
    public static final String CONN_QUERY_STACK = "queryStack";
    public static final String SCOPE_CATALOG = "catalog";
    public static final String SCOPE_SCHEMA = "schema";
    public static final String SCOPE_CUBE = "cube";
    public static final String QUERY_SERVICE = "queryService";
    public static final String QUERY_FRAMEWORK = "queryFramework";
    public static final String TM1_ALIASTABLE_DELIMITER = "+++***DELIMITER***+++";
    public static final String CACHING_TRANSIENT = "transient";
    public static final String CACHING_PERSISTENT = "persistent";
    private String mType;
    private TreeMap<String, Object> mConnectionInfo;
    private TreeMap<String, Object> mScopeInfo;
    private TreeMap<String, Object> mSignonInfo;
    private LinkedHashMap<String, Object> mAliasInfo;

    public static MFWMetadataSource create(String type) {
        return new MFWMetadataSource(type);
    }

    private MFWMetadataSource(String sType) {
        this.mType = sType;
        this.mConnectionInfo = new TreeMap();
        this.mScopeInfo = new TreeMap();
        this.mSignonInfo = new TreeMap();
        this.mAliasInfo = new LinkedHashMap();
    }

    public Object clone() {
        try {
            MFWMetadataSource src = (MFWMetadataSource)super.clone();
            src.mConnectionInfo = (TreeMap)this.mConnectionInfo.clone();
            src.mScopeInfo = (TreeMap)this.mScopeInfo.clone();
            src.mSignonInfo = (TreeMap)this.mSignonInfo.clone();
            src.mAliasInfo = (LinkedHashMap)this.mAliasInfo.clone();
            return src;
        }
        catch (Exception e) {
            MFWException.ASSERT(false, "Clone of MFWMetadataSource failed: \n" + MFWException.getExceptionAndStackTrace(e));
            return null;
        }
    }

    public void destroy() {
        this.mConnectionInfo.clear();
        this.mScopeInfo.clear();
        this.mSignonInfo.clear();
        this.mAliasInfo.clear();
        this.mType = null;
    }

    public String getType() {
        return this.mType;
    }

    public void addConnectionItem(String sConnPropName, Object sConnPropValue) {
        this.mConnectionInfo.put(sConnPropName, sConnPropValue);
    }

    public Map<String, Object> getConnectionInfo() {
        return this.mConnectionInfo;
    }

    public Object getConnectionItem(String sConnPropName) {
        return this.mConnectionInfo.get(sConnPropName);
    }

    public void addScope(String sScopePropName, Object sScopePropValue) {
        this.mScopeInfo.put(sScopePropName, sScopePropValue);
    }

    public Map<String, Object> getScopeInfo() {
        return this.mScopeInfo;
    }

    public Object getScope(String sScopePropName) {
        return this.mScopeInfo.get(sScopePropName);
    }

    public void addSignon(String sSignonPropName, Object sSignonPropValue) {
        this.mSignonInfo.put(sSignonPropName, sSignonPropValue);
    }

    public Map<String, Object> getSignonInfo() {
        return this.mSignonInfo;
    }

    public Object getSignon(String sSignonPropName) {
        return this.mSignonInfo.get(sSignonPropName);
    }

    public void addAlias(String sLocale, Object sAliasTable) {
        this.mAliasInfo.put(sLocale, sAliasTable);
    }

    public Map<String, Object> getAliasInfo() {
        return this.mAliasInfo;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof MFWMetadataSource) {
            MFWMetadataSource ms = (MFWMetadataSource)rhs;
            boolean bResult = this.mType.equals(ms.mType) && this.mConnectionInfo.equals(ms.mConnectionInfo) && this.mScopeInfo.equals(ms.mScopeInfo) && this.mSignonInfo.equals(ms.mSignonInfo) && this.mAliasInfo.equals(ms.mAliasInfo);
            return bResult;
        }
        return false;
    }

    public void doPersist(MFWPStore aStore, MFWStringPoolPrst aStringPool, int aPosition) {
        PElement psrc = new PElement(aStringPool, this);
        for (int idx = 0; idx < psrc.sizeof() / 4; ++idx) {
            aStore.putInt(0);
        }
        psrc.persist(aStore, aPosition);
    }

    public static MFWMetadataSource doLoad(MFWPStore aStore, MFWStringPoolPrst aStringPool, int aPosition) {
        PElement psrc = new PElement(aStringPool);
        psrc.load(aStore, aPosition);
        return psrc.getSource();
    }

    public String toString() {
        StringWriter osw = new StringWriter();
        try {
            this.asXML(osw);
        }
        catch (IOException e) {
            return "toString Failed:" + e.getMessage();
        }
        return osw.toString();
    }

    public void asXML(Writer osw) throws IOException {
        osw.write("<metadataSource type=\"");
        osw.write(this.mType);
        osw.write("\">");
        this.dumpMap("connections", this.mConnectionInfo, osw);
        this.dumpMap("scopes", this.mScopeInfo, osw);
        this.dumpMap("signOns", this.mSignonInfo, osw);
        this.dumpMap("aliasInfo", this.mAliasInfo, osw);
        osw.write("</metadataSource>");
    }

    private void dumpMap(String mapName, Map<String, Object> aMap, Writer osw) throws IOException {
        if (aMap.isEmpty()) {
            return;
        }
        osw.write(60);
        osw.write(mapName);
        osw.write(62);
        for (Map.Entry<String, Object> aPair : aMap.entrySet()) {
            osw.write("<");
            osw.write(aPair.getKey());
            osw.write(">");
            if (aPair.getValue() != null) {
                osw.write(aPair.getValue().toString());
            }
            osw.write("</");
            osw.write(aPair.getKey());
            osw.write(">");
        }
        osw.write("</");
        osw.write(mapName);
        osw.write(62);
    }

    public static final class PElement
    implements MFWPElement {
        MFWMetadataSource mSource = null;
        MFWStringPoolPrst mStringPool = null;

        public PElement(MFWStringPoolPrst aStringPool, MFWMetadataSource aSource) {
            this.mStringPool = aStringPool;
            this.mSource = aSource;
        }

        public PElement(MFWStringPoolPrst aStringPool) {
            this.mStringPool = aStringPool;
            this.mSource = null;
        }

        public MFWMetadataSource getSource() {
            return this.mSource;
        }

        @Override
        public boolean isEqual(MFWPStore store, MFWPElement that) {
            PElement thatSource = (PElement)that;
            boolean outRes = this.mSource == null && thatSource.mSource == null || this.mSource != null && thatSource.mSource != null && this.mSource.equals(thatSource.mSource);
            return outRes;
        }

        @Override
        public void load(MFWPStore aStore, int aPosition) {
            int intType = aStore.getInt(aPosition);
            this.mSource = MFWMetadataSource.create(this.mStringPool.getString(intType));
            this.loadMap(aStore, aPosition + 4, this.mSource.getConnectionInfo());
            this.loadMap(aStore, aPosition + 12, this.mSource.getScopeInfo());
            this.loadMap(aStore, aPosition + 20, this.mSource.getSignonInfo());
            this.loadMap(aStore, aPosition + 28, this.mSource.getAliasInfo());
        }

        @Override
        public void persist(MFWPStore aStore, int aPosition) {
            if (this.mSource != null) {
                int intType = this.mStringPool.poolString(this.mSource.getType());
                aStore.updateInt(aPosition, intType);
                this.persistMap(aStore, aPosition + 4, this.mSource.getConnectionInfo());
                this.persistMap(aStore, aPosition + 12, this.mSource.getScopeInfo());
                this.persistMap(aStore, aPosition + 20, this.mSource.getSignonInfo());
                this.persistMap(aStore, aPosition + 28, this.mSource.getAliasInfo());
            }
        }

        @Override
        public short sizeof() {
            return 36;
        }

        @Override
        public int getHashCode() {
            if (this.mSource != null) {
                return this.mSource.hashCode();
            }
            return this.hashCode();
        }

        private void persistMap(MFWPStore aStore, int aPosition, Map<String, Object> aMap) {
            if (aMap.isEmpty()) {
                aStore.updateInt(aPosition, 0);
                aStore.updateInt(aPosition + 4, 0);
            } else {
                MFWPElementInt anEntry = new MFWPElementInt();
                MFWPList<MFWPElementInt> keyList = MFWPList.create(aStore, (short)aMap.size(), anEntry);
                MFWPList<MFWPElementInt> valueList = MFWPList.create(aStore, (short)aMap.size(), anEntry);
                for (Map.Entry<String, Object> aPair : aMap.entrySet()) {
                    keyList.add(anEntry.reset(this.mStringPool.poolString(aPair.getKey())));
                    if (aPair.getValue() != null) {
                        valueList.add(anEntry.reset(this.mStringPool.poolString(aPair.getValue().toString())));
                        continue;
                    }
                    valueList.add(anEntry.reset(0));
                }
                aStore.updateInt(aPosition, keyList.getPosition());
                aStore.updateInt(aPosition + 4, valueList.getPosition());
            }
        }

        private void loadMap(MFWPStore aStore, int aPosition, Map<String, Object> aMap) {
            int keyListPos = aStore.getInt(aPosition);
            int valueListPos = aStore.getInt(aPosition + 4);
            if (keyListPos != 0 && valueListPos != 0) {
                MFWPElementInt anEntry = new MFWPElementInt();
                MFWPList keyList = MFWPList.open(aStore, keyListPos);
                ArrayList<String> tempKeys = new ArrayList<String>();
                MFWPList.Iterator keyItr = keyList.getIterator();
                while (keyItr.hasNext()) {
                    keyItr.next(anEntry);
                    tempKeys.add(this.mStringPool.getString(anEntry.getValue()));
                }
                MFWPList valueList = MFWPList.open(aStore, valueListPos);
                MFWPList.Iterator valItr = valueList.getIterator();
                int keyIdx = 0;
                while (valItr.hasNext()) {
                    valItr.next(anEntry);
                    aMap.put((String)tempKeys.get(keyIdx), this.mStringPool.getString(anEntry.getValue()));
                    ++keyIdx;
                }
            }
        }
    }
}

