/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoLinkImpl;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWInfoPropertyImpl;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MFWModel {
    public static final short GUID_ROOT_NODE = 0;
    public static final short GUID_LINK_NODE = 1;
    public static final short GUID_UNKNOWN = -1;
    private static final String TAG_CODENUM = "codeNum";
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DATATYPE = "dataType";
    private static final String TAG_DEFAULTVALUE = "defaultValue";
    private static final String TAG_DYNAMIC = "dynamic";
    private static final String TAG_ENUMVALUES = "enumValues";
    private static final String TAG_GUID = "guid";
    private static final String TAG_ID = "id";
    private static final String TAG_INDEXED = "indexed";
    private static final String TAG_MULTIPLICITY = "multiplicity";
    private static final String TAG_NAME = "name";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_OBJECTREF = "objectRef";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_PROPERTYREF = "propertyRef";
    private static final InfoComparator gInfoCmpr = new InfoComparator();
    private static MFWModel gSingleton = new MFWModel();
    private short mVerMajor = 1;
    private short mVerMinor = 1;
    private MFWInfoObjectImpl mRootObjInfo = null;
    private MFWInfoLinkImpl mLinkNodeInfo = null;
    private MFWInfoProperty mIDPropInfo = null;
    private ArrayList<MFWInfo> mAllInfos = new ArrayList(250);
    private HashMap<String, MFWInfo> mStandaloneInfos = new HashMap(150);
    private HashMap<String, UnresolvedInfo> mUnresolvedInfos = new HashMap();

    public static MFWModel getInstance() {
        return gSingleton;
    }

    public MFWInfoObjectImpl getRootObjInfo() {
        return this.mRootObjInfo;
    }

    public MFWInfoLinkImpl getLinkNodeInfo() {
        return this.mLinkNodeInfo;
    }

    public MFWInfoProperty getIDPropertyInfo() {
        return this.mIDPropInfo;
    }

    public short getMajorVersion() {
        return this.mVerMajor;
    }

    public short getMinorVersion() {
        return this.mVerMinor;
    }

    public MFWInfo findInfoByGUID(short aGUID) {
        int idx = this.binarySearchGUID(aGUID, 0, this.mAllInfos.size() - 1);
        if (idx != -1) {
            return this.mAllInfos.get(idx);
        }
        return null;
    }

    private int binarySearchGUID(short keyGUID, int lowerBound, int upperBound) {
        int curIn = (lowerBound + upperBound) / 2;
        short aGUID = this.mAllInfos.get(curIn).getGUID();
        if (keyGUID == aGUID) {
            return curIn;
        }
        if (lowerBound > upperBound) {
            return -1;
        }
        if (aGUID < keyGUID) {
            return this.binarySearchGUID(keyGUID, curIn + 1, upperBound);
        }
        return this.binarySearchGUID(keyGUID, lowerBound, curIn - 1);
    }

    private MFWInfo lookupGUID(short aGUID) {
        MFWInfo outInfo = null;
        for (int idx = 0; outInfo == null && idx < this.mAllInfos.size(); ++idx) {
            MFWInfo anInfo = this.mAllInfos.get(idx);
            if (anInfo.getGUID() != aGUID) continue;
            outInfo = anInfo;
        }
        return outInfo;
    }

    public ArrayList<MFWInfo> findAllInfoByRID(short aRID) {
        ArrayList<MFWInfo> outList = new ArrayList<MFWInfo>();
        for (int idx = 0; idx < this.mAllInfos.size(); ++idx) {
            MFWInfo anInfo = this.mAllInfos.get(idx);
            if (anInfo.getRID() != aRID) continue;
            outList.add(anInfo);
        }
        return outList;
    }

    public MFWInfo findInfoByRID(short aRID) {
        MFWInfo outInfo = null;
        for (int idx = 0; outInfo == null && idx < this.mAllInfos.size(); ++idx) {
            MFWInfo anInfo = this.mAllInfos.get(idx);
            if (anInfo.getRID() != aRID) continue;
            outInfo = anInfo;
        }
        return outInfo;
    }

    private MFWModel() {
        this.mRootObjInfo = new MFWInfoObjectImpl("root", 0);
        this.mLinkNodeInfo = new MFWInfoLinkImpl("linkNode", 1);
        this.mAllInfos.add(this.mRootObjInfo);
        this.mAllInfos.add(this.mLinkNodeInfo);
        this.ReadModelDefinition();
        if (!this.mUnresolvedInfos.isEmpty()) {
            StringBuffer sMsg = new StringBuffer("The following property/object references are unresolved: ");
            for (String sKey : this.mUnresolvedInfos.keySet()) {
                sMsg.append(sKey);
                sMsg.append(", ");
            }
            MFWException.ASSERT(false, sMsg.toString());
        }
        this.mUnresolvedInfos = null;
        this.mStandaloneInfos.clear();
        this.mStandaloneInfos = null;
        MFWModelRes.getInstance().setupCommonRIDs();
        MFWInfo projInfo = this.findInfoByRID(MFWModelRes.getInstance().RID_project);
        MFWException.ASSERT(projInfo != null, "Unable to find information for 'project'");
        this.mRootObjInfo.addChildInfo(projInfo, (short)1);
        MFWInfo physicalSources = this.findInfoByRID(MFWModelRes.getInstance().RID_physicalSources);
        MFWException.ASSERT(physicalSources != null, "Unable to find information for 'physicalSources'");
        this.mRootObjInfo.addChildInfo(physicalSources, (short)1);
        for (int idx = 0; idx < this.mAllInfos.size(); ++idx) {
            MFWInfo anInfo = this.mAllInfos.get(idx);
            if (anInfo.getNodeType() != 2) continue;
            ((MFWInfoObjectImpl)anInfo).sortChildren();
        }
        Collections.sort(this.mAllInfos, gInfoCmpr);
        this.mIDPropInfo = (MFWInfoProperty)this.findInfoByGUID((short)100);
    }

    private void ReadModelDefinition() {
        try {
            ICCLConfiguration icclConfig = CCLConfigurationFactory.getInstance();
            String mfwModelFile = "../configuration/mfw4jModel.xml";
            mfwModelFile = icclConfig.resolveEffectivePath(mfwModelFile);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(mfwModelFile));
            DocumentBuilder myBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document docConfig = myBuilder.parse(is);
            for (Node nodeChild = docConfig.getDocumentElement().getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
                if (!(nodeChild instanceof Element)) continue;
                Element elemChild = (Element)nodeChild;
                String sName = elemChild.getNodeName();
                if ("version".equals(sName)) {
                    this.mVerMajor = (short)Integer.parseInt(elemChild.getAttribute("major"));
                    this.mVerMinor = (short)Integer.parseInt(elemChild.getAttribute("minor"));
                    continue;
                }
                if (TAG_PROPERTY.equals(sName)) {
                    this.readProperty(null, (short)0, elemChild);
                    continue;
                }
                if (TAG_OBJECT.equals(sName)) {
                    this.readObject(null, (short)0, elemChild);
                    continue;
                }
                MFWException.ASSERT(false, "Unexpected element in the model specification document:", sName);
            }
            is.close();
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    private void readProperty(MFWInfoObjectImpl aParentInfo, short aMultiplicity, Element elmProp) {
        MFWInfoPropertyImpl newInfoProp = this.addPropertyInfo(elmProp);
        if (aParentInfo != null) {
            aParentInfo.addChildInfo(newInfoProp, aMultiplicity);
        }
        Node elmEnumValues = null;
        String defaultValue = null;
        for (Node nodeChild = elmProp.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            if (nodeChild.getNodeType() != 1) continue;
            String sNodeName = nodeChild.getNodeName();
            Element elmChild = (Element)nodeChild;
            if (TAG_DATATYPE.equals(sNodeName)) {
                String sDataType = this.getTextNodeValue(elmChild);
                newInfoProp.setDataType(this.toDataType(sDataType));
                continue;
            }
            if (TAG_DEFAULTVALUE.equals(sNodeName)) {
                defaultValue = this.getTextNodeValue(elmChild);
                continue;
            }
            if (!TAG_ENUMVALUES.equals(sNodeName)) continue;
            elmEnumValues = elmChild;
        }
        if (elmEnumValues != null) {
            for (Node enumValueChild = elmEnumValues.getFirstChild(); enumValueChild != null; enumValueChild = enumValueChild.getNextSibling()) {
                if (enumValueChild.getNodeType() != 1) continue;
                Element elmEnum = (Element)enumValueChild;
                String enumNum = elmEnum.getAttribute(TAG_CODENUM);
                newInfoProp.addEnumeratedValue(Integer.parseInt(enumNum), this.getTextNodeValue(elmEnum));
            }
        }
        if (defaultValue != null) {
            newInfoProp.setDefaultValue(defaultValue);
        }
    }

    private void readObject(MFWInfoObjectImpl aParentInfo, short aMultiplicity, Element elmObj) {
        MFWInfoObjectImpl newInfoObj = this.addObjectInfo(elmObj);
        if (aParentInfo != null) {
            aParentInfo.addChildInfo(newInfoObj, aMultiplicity);
        }
        for (Node nodeTemp = elmObj.getFirstChild(); nodeTemp != null; nodeTemp = nodeTemp.getNextSibling()) {
            Node nodeChild;
            if (nodeTemp.getNodeType() != 1 || !TAG_CONTAINS.equals(nodeTemp.getNodeName())) continue;
            Element elmCont = (Element)nodeTemp;
            short eMult = this.toMultiplicity(elmCont.getAttribute(TAG_MULTIPLICITY));
            String sObjRef = elmCont.getAttribute(TAG_OBJECTREF);
            String sPropRef = elmCont.getAttribute(TAG_PROPERTYREF);
            if (sPropRef.length() > 0) {
                MFWInfo refProp = this.lookupReferencedObjProp(sPropRef, newInfoObj, (short)1);
                newInfoObj.addChildInfo(refProp, eMult);
                continue;
            }
            if (sObjRef.length() > 0) {
                MFWInfo refObj = this.lookupReferencedObjProp(sObjRef, newInfoObj, (short)2);
                newInfoObj.addChildInfo(refObj, eMult);
                continue;
            }
            for (nodeChild = elmCont.getFirstChild(); nodeChild != null && nodeChild.getNodeType() != 1; nodeChild = nodeChild.getNextSibling()) {
            }
            MFWException.ASSERT(nodeChild != null, "Either a 'property' or 'object' element must be specified");
            Element elmTemp = (Element)nodeChild;
            String sName = nodeChild.getNodeName();
            MFWException.ASSERT(TAG_PROPERTY.equals(sName) || TAG_OBJECT.equals(sName), "Either a 'property' or 'object' element must be specified");
            if (TAG_PROPERTY.equals(sName)) {
                this.readProperty(newInfoObj, eMult, elmTemp);
                continue;
            }
            this.readObject(newInfoObj, eMult, elmTemp);
        }
    }

    private MFWInfoPropertyImpl addPropertyInfo(Element elmProp) {
        String anID = elmProp.getAttribute(TAG_ID);
        String aGUID = elmProp.getAttribute(TAG_GUID);
        String sName = this.getName(elmProp);
        MFWException.ASSERT(aGUID.length() > 0, "Missing GUID value for property ", sName);
        short guid = (short)Integer.parseInt(aGUID);
        MFWException.ASSERT(this.lookupGUID(guid) == null, "Duplicate GUID is specified for property ", sName);
        MFWInfoPropertyImpl infoProp = new MFWInfoPropertyImpl(sName, guid);
        this.mAllInfos.add(infoProp);
        if (anID.length() > 0) {
            this.mStandaloneInfos.put(anID, infoProp);
        }
        if ("true".equals(elmProp.getAttribute(TAG_INDEXED))) {
            infoProp.setIndexed(true);
        }
        if ("true".equals(elmProp.getAttribute(TAG_DYNAMIC))) {
            infoProp.setDynamic(true);
        }
        this.resolveInfo(anID, infoProp);
        return infoProp;
    }

    private MFWInfoObjectImpl addObjectInfo(Element elmObj) {
        String anID = elmObj.getAttribute(TAG_ID);
        String aGUID = elmObj.getAttribute(TAG_GUID);
        String isIndexed = elmObj.getAttribute(TAG_INDEXED);
        String sName = this.getName(elmObj);
        MFWException.ASSERT(aGUID.length() > 0, "Missing GUID value for object ", sName);
        short guid = (short)Integer.parseInt(aGUID);
        MFWException.ASSERT(this.lookupGUID(guid) == null, "Duplicate GUID is specified for object ", sName);
        MFWInfoObjectImpl infoObj = new MFWInfoObjectImpl(sName, guid);
        this.mAllInfos.add(infoObj);
        if (anID.length() > 0) {
            this.mStandaloneInfos.put(anID, infoObj);
        }
        if ("true".equals(isIndexed)) {
            infoObj.setIndexed(true);
        }
        this.resolveInfo(anID, infoObj);
        return infoObj;
    }

    private short toMultiplicity(String aMult) {
        if ("0:1".equals(aMult)) {
            return 2;
        }
        if ("1:1".equals(aMult)) {
            return 1;
        }
        if ("0:n".equals(aMult)) {
            return 3;
        }
        if ("1:n".equals(aMult)) {
            return 4;
        }
        return 2;
    }

    private short toDataType(String aDataType) {
        if ("string".equals(aDataType)) {
            return 1;
        }
        if ("enum".equals(aDataType)) {
            return 2;
        }
        if ("boolean".equals(aDataType)) {
            return 4;
        }
        return 0;
    }

    private String getName(Element elmPropObj) {
        NodeList list = elmPropObj.getElementsByTagName(TAG_NAME);
        MFWException.ASSERT(list.getLength() > 0 && list.item(0).getNodeType() == 1, "Property/Object definition is missing a valid 'name' element");
        String sName = this.getTextNodeValue((Element)list.item(0));
        MFWException.ASSERT(sName.length() > 0, "The name of property/object cannot be empty");
        return sName;
    }

    private String getTextNodeValue(Element elm) {
        Node nodeText = elm.getFirstChild();
        MFWException.ASSERT(nodeText.getNodeType() == 3, "Expecting a text node under element:", elm.getNodeName());
        return nodeText.getNodeValue();
    }

    private MFWInfo lookupReferencedObjProp(String refID, MFWInfoObjectImpl parentInfo, short eType) {
        MFWInfo refInfo = this.mStandaloneInfos.get(refID);
        if (refInfo != null) {
            MFWException.ASSERT(refInfo.getNodeType() == eType, "Inconsistencies netween reference and referenced type for:", refID);
            return refInfo;
        }
        return this.findOrAddUnresolvedInfo(refID, parentInfo, eType);
    }

    private MFWInfo findOrAddUnresolvedInfo(String refID, MFWInfoObjectImpl parentInfo, short eType) {
        MFWInfo outInfo = null;
        UnresolvedInfo anUnrsvldInfo = this.mUnresolvedInfos.get(refID);
        if (anUnrsvldInfo == null) {
            outInfo = eType == 1 ? new MFWInfoPropertyImpl(refID, -1) : new MFWInfoObjectImpl(refID, -1);
            anUnrsvldInfo = new UnresolvedInfo(outInfo);
            this.mUnresolvedInfos.put(refID, anUnrsvldInfo);
        } else {
            outInfo = anUnrsvldInfo.mUnrsvldInfo;
        }
        anUnrsvldInfo.mUsedInInfos.add(parentInfo);
        return outInfo;
    }

    private void resolveInfo(String refID, MFWInfo resolvedInfo) {
        UnresolvedInfo anUnrsvldInfo = this.mUnresolvedInfos.get(refID);
        if (anUnrsvldInfo == null) {
            return;
        }
        for (int idx = 0; idx < anUnrsvldInfo.mUsedInInfos.size(); ++idx) {
            MFWInfoObjectImpl aParentObjInfo = (MFWInfoObjectImpl)anUnrsvldInfo.mUsedInInfos.get(idx);
            aParentObjInfo.resolveChildInfo(refID, resolvedInfo);
        }
        anUnrsvldInfo.mUnrsvldInfo = null;
        anUnrsvldInfo.mUsedInInfos.clear();
        anUnrsvldInfo = this.mUnresolvedInfos.remove(refID);
        anUnrsvldInfo = null;
    }

    void destroy() {
        for (int idx = 0; idx < this.mAllInfos.size(); ++idx) {
            MFWInfo anInfo = this.mAllInfos.get(idx);
            anInfo.destroy();
        }
        this.mAllInfos.clear();
    }

    public boolean canLeadTo(MFWInfo infoDescendant, MFWInfoObject infoAncestor, ArrayList<MFWInfo> outPathInfo) {
        ArrayList<InfoPair> vVisitedInfo = new ArrayList<InfoPair>();
        boolean bResult = this.canLeadTo(infoDescendant, infoAncestor, outPathInfo, vVisitedInfo);
        return bResult;
    }

    private boolean canLeadTo(MFWInfo infoDescendant, MFWInfoObject infoAncestor, ArrayList<MFWInfo> outPathInfo, ArrayList<InfoPair> visistedInfo) {
        int idx;
        MFWInfoObject[] vParentsInfo = infoDescendant.getParents();
        if (vParentsInfo == null) {
            return false;
        }
        InfoPair aPair = new InfoPair(infoDescendant, infoAncestor);
        if (visistedInfo.contains(aPair)) {
            return outPathInfo.contains(infoDescendant);
        }
        visistedInfo.add(aPair);
        boolean outResult = false;
        for (idx = 0; idx < vParentsInfo.length; ++idx) {
            if (vParentsInfo[idx] != infoAncestor) continue;
            outResult = true;
            if (infoDescendant.getNodeType() != 2 || ((MFWInfoObject)infoDescendant).findChildInfo(infoDescendant.getRID()) == null || outPathInfo.contains(infoDescendant)) continue;
            outPathInfo.add(infoDescendant);
        }
        for (idx = 0; idx < vParentsInfo.length; ++idx) {
            if (!this.canLeadTo(vParentsInfo[idx], infoAncestor, outPathInfo, visistedInfo)) continue;
            if (!outPathInfo.contains(vParentsInfo[idx])) {
                outPathInfo.add(vParentsInfo[idx]);
            }
            outResult = true;
            this.canLeadTo(infoDescendant, vParentsInfo[idx], outPathInfo, visistedInfo);
        }
        return outResult;
    }

    private static final class InfoPair {
        private MFWInfo mFirst = null;
        private MFWInfo mSecond = null;

        InfoPair(MFWInfo first, MFWInfo second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        public boolean equals(Object that) {
            if (that instanceof InfoPair) {
                InfoPair thatInfo = (InfoPair)that;
                return this.mFirst.getGUID() == thatInfo.mFirst.getGUID() && this.mSecond.getGUID() == thatInfo.mSecond.getGUID();
            }
            return false;
        }
    }

    private static final class UnresolvedInfo {
        private MFWInfo mUnrsvldInfo = null;
        private ArrayList<MFWInfoObjectImpl> mUsedInInfos = new ArrayList();

        private UnresolvedInfo(MFWInfo tempInfo) {
            this.mUnrsvldInfo = tempInfo;
        }
    }

    private static final class InfoComparator
    implements Comparator<MFWInfo> {
        private InfoComparator() {
        }

        @Override
        public int compare(MFWInfo obj1, MFWInfo obj2) {
            return obj1.getGUID() - obj2.getGUID();
        }
    }
}

