/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWXPathEvaluator;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.List;

public abstract class MFWNodeLink
extends MFWNode {
    private static final String TAG_NOLWM_CLUSTER = "noLWMCluster";

    protected MFWNodeLink() {
    }

    public abstract MFWQuerySpec getQuerySpec();

    @Override
    public MFWInfo getInfo() {
        return MFWModel.getInstance().getLinkNodeInfo();
    }

    public abstract short getLinkSourceID();

    public abstract short getLinkChildRID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLinkedNodes(MFWCluster sourceCluster, MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        MFWQuerySpec myQuerySpec = this.getQuerySpec();
        try {
            MFWNodeObject aLinkCont;
            MFWException.ASSERT(myQuerySpec != null, "A valid query spec object is expected for link nodes");
            if (aQuerySpec != null) {
                myQuerySpec.setPrimaryQuerySpec(aQuerySpec);
            }
            short idLinkSrc = this.getLinkSourceID();
            if (aContext.getConnectionSpec() != null && TAG_NOLWM_CLUSTER.equals(aContext.getConnectionSpec().getName()) && (aLinkCont = sourceCluster.getLinkManager().getLinkContainer(idLinkSrc)).getNameRID() == MFWModelRes.getInstance().RID_namespace && aLinkCont.getBooleanPropertyValue(MFWModelRes.getInstance().getResourceID("isCube"))) {
                return;
            }
            MFWCluster aLinkedCluster = null;
            try {
                aLinkedCluster = sourceCluster.getLinkedCluster(aContext, idLinkSrc);
            }
            catch (RuntimeException ex) {
                String errorCode = ex.getMessage();
                boolean knownErrorCode = MFWConfiguration.getInstance().isKnownErrorCode(errorCode);
                if (knownErrorCode) {
                    aLinkedCluster = null;
                }
                throw ex;
            }
            if (aLinkedCluster != null) {
                MFWXPathEvaluator myEvaluator = new MFWXPathEvaluator(aContext);
                myEvaluator.evaluate(aLinkedCluster.getRootNode(), myQuerySpec, outResults);
            }
        }
        finally {
            myQuerySpec.setPrimaryQuerySpec(null);
        }
    }

    public String toString() {
        StringBuilder outStr = new StringBuilder("MFWNodeLink: \n");
        outStr.append(this.getQuerySpec().toString());
        outStr.append("\n\tAncestry: ");
        boolean bMultiple = false;
        for (MFWNodeObject parent = this.getParentObject(); parent != null; parent = parent.getParentObject()) {
            if (bMultiple) {
                outStr.append("->");
            } else {
                bMultiple = true;
            }
            outStr.append(parent.getName());
        }
        outStr.append("\n\tSource ID: ");
        outStr.append(Integer.toString(this.getLinkSourceID()));
        outStr.append("\n");
        return outStr.toString();
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

