/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.List;

public abstract class MFWNodeObject
extends MFWNode {
    public static final byte EXPAND_STATUS_UKNOWN = 0;
    public static final byte EXPAND_STATUS_YES = 1;
    public static final byte EXPAND_STATUS_NO = 2;
    public static final byte EXPAND_STATUS_PARTIAL = 3;

    protected MFWNodeObject() {
    }

    public abstract MFWInfoObject getObjectInfo();

    @Override
    public MFWInfo getInfo() {
        return this.getObjectInfo();
    }

    public abstract List<MFWNode> getChildNodes();

    public abstract void addProperty(short var1, String var2);

    public abstract void addProperty(short var1, boolean var2);

    public abstract void addProperty(short var1, int var2);

    public abstract List<String> getPropertyValues(short var1);

    public abstract String getPropertyValue(short var1);

    public abstract boolean getBooleanPropertyValue(short var1);

    public abstract int getEnumPropertyValue(short var1);

    public abstract List<MFWNode> getObjectNodes(short var1);

    public abstract MFWNodeObject getObjectNode(short var1);

    public abstract MFWNodeObject addObjectNode(short var1);

    public abstract void reserveChildren(short var1, int var2);

    public abstract MFWNodeObject addExpandableObjectNode(short var1);

    public abstract void removeChildNode(MFWNode var1);

    public abstract Object getExpandLock();

    public abstract void setExpandStatus(short var1, byte var2);

    public abstract byte getExpandStatus(short var1);

    public abstract void addLinkNode(short var1, short var2, String var3);

    public abstract List<MFWNodeLink> getLinkNodes();

    protected abstract void queryChild(MFWRequestContextUser var1, MFWQuerySpec var2, List<MFWNode> var3);

    protected abstract void queryChild(MFWRequestContextUser var1, short var2, List<MFWNode> var3);

    protected abstract MFWNode querySingleChild(MFWRequestContextUser var1, MFWQuerySpec var2);

    protected abstract MFWNode querySingleChild(MFWRequestContextUser var1, short var2);

    protected abstract void queryAllChildren(MFWRequestContextUser var1, MFWQuerySpec var2, List<MFWNode> var3);

    protected abstract void queryAllChildren(MFWRequestContextUser var1, List<MFWNode> var2);

    public void findObjectNodes(short ridObjName, short ridPropName, String sPropValue, List<MFWNodeObject> outList) {
        MFWException.ASSERT(outList != null, "findObjectNodes method expects a valid array list as its last argument");
        List<MFWNode> objList = this.getObjectNodes(ridObjName);
        for (int idx = 0; idx < objList.size(); ++idx) {
            MFWNodeObject anObj = (MFWNodeObject)objList.get(idx);
            if (ridPropName == -1) {
                outList.add(anObj);
                continue;
            }
            String propValue = anObj.getPropertyValue(ridPropName);
            if (propValue == null) continue;
            if (sPropValue == null) {
                outList.add(anObj);
                continue;
            }
            if (!sPropValue.equals(propValue)) continue;
            outList.add(anObj);
        }
    }

    public void findObjectNodesRecursively(short ridObjName, short ridContainerName, short ridPropName, String sPropValue, boolean bStopAtFirst, List<MFWNodeObject> outList) {
        MFWInfoObject objInfo = this.getObjectInfo();
        if (objInfo.findChildInfo(ridObjName) != null) {
            this.findObjectNodes(ridObjName, ridPropName, sPropValue, outList);
        }
        if ((!bStopAtFirst || outList.isEmpty()) && objInfo.findChildInfo(ridContainerName) != null) {
            List<MFWNode> vContainers = this.getObjectNodes(ridContainerName);
            for (int idx = 0; idx < vContainers.size() && (!bStopAtFirst || outList.isEmpty()); ++idx) {
                MFWNodeObject aCntr = (MFWNodeObject)vContainers.get(idx);
                aCntr.findObjectNodesRecursively(ridObjName, ridContainerName, ridPropName, sPropValue, bStopAtFirst, outList);
            }
        }
    }

    public void findObjectNodesRecursively(short ridObjName, short[] ridContainerNames, short ridPropName, String sPropValue, boolean bStopAtFirst, List<MFWNodeObject> outList) {
        MFWInfoObject objInfo = this.getObjectInfo();
        if (objInfo.findChildInfo(ridObjName) != null) {
            this.findObjectNodes(ridObjName, ridPropName, sPropValue, outList);
        }
        if (!bStopAtFirst || outList.isEmpty()) {
            for (int ii = 0; ii < ridContainerNames.length; ++ii) {
                if (objInfo.findChildInfo(ridContainerNames[ii]) == null) continue;
                List<MFWNode> vContainers = this.getObjectNodes(ridContainerNames[ii]);
                for (int idx = 0; idx < vContainers.size() && (!bStopAtFirst || outList.isEmpty()); ++idx) {
                    MFWNodeObject aCntr = (MFWNodeObject)vContainers.get(idx);
                    aCntr.findObjectNodesRecursively(ridObjName, ridContainerNames, ridPropName, sPropValue, bStopAtFirst, outList);
                }
            }
        }
    }

    protected MFWInfoObjectImpl.ChildInfo validateChild(short ridName, short eNodeType) {
        MFWInfoObjectImpl.ChildInfo childInfo = ((MFWInfoObjectImpl)this.getObjectInfo()).findDetailedChildInfo(ridName);
        if (childInfo == null) {
            StringBuffer sMsg1 = new StringBuffer("unknown child '");
            sMsg1.append(MFWModelRes.getInstance().getResource(ridName));
            sMsg1.append("'(");
            sMsg1.append(Integer.toString(ridName));
            sMsg1.append(") for object of type '");
            sMsg1.append(this.getName());
            MFWException.ASSERT(false, sMsg1.toString());
        }
        if (eNodeType != 0 && childInfo.getInfo().getNodeType() != eNodeType) {
            StringBuffer sMsg2 = new StringBuffer("'");
            sMsg2.append(childInfo.getInfo().getName());
            sMsg2.append("' is not a valid child for an object of type '");
            sMsg2.append(this.getName());
            MFWException.ASSERT(false, sMsg2.toString());
        }
        return childInfo;
    }

    public String toString() {
        StringBuffer outStr = new StringBuffer("MFWNodeObject: ");
        outStr.append(this.getName());
        outStr.append("\n\tAncestry: ");
        boolean bMultiple = false;
        for (MFWNodeObject parent = this.getParentObject(); parent != null; parent = parent.getParentObject()) {
            if (bMultiple) {
                outStr.append("->");
            } else {
                bMultiple = true;
            }
            outStr.append(parent.getName());
        }
        outStr.append("\n\tNodes:\n");
        List<MFWNode> vChildren = this.getChildNodes();
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            outStr.append("\t\t");
            outStr.append(vChildren.get(idx).getName());
            if (vChildren.get(idx).isProperty()) {
                MFWNodeProperty property = (MFWNodeProperty)vChildren.get(idx);
                outStr.append(": ");
                outStr.append(property.getValue());
            }
            outStr.append("\n");
        }
        return outStr.toString();
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

