/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWInfoPropertyImpl;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodePropertyInt;
import com.cognos.mfw4j.framework.MFWNodePropertyString;
import com.cognos.mfw4j.utilities.MFWStringHelper;

public abstract class MFWNodeProperty
extends MFWNode {
    private MFWNodeObject mParent = null;

    protected MFWNodeProperty(MFWNodeObject aParent) {
        this.mParent = aParent;
    }

    @Override
    public MFWNodeObject getParentObject() {
        return this.mParent;
    }

    @Override
    public MFWCluster getCluster() {
        return this.mParent.getCluster();
    }

    public abstract MFWInfoProperty getPropertyInfo();

    @Override
    public MFWInfo getInfo() {
        return this.getPropertyInfo();
    }

    public abstract String getValue();

    public abstract void setValue(String var1);

    public abstract boolean getBooleanValue();

    public abstract void setBooleanValue(boolean var1);

    public abstract int getEnumValue();

    public abstract void setEnumValue(int var1);

    public String toString() {
        StringBuffer outStr = new StringBuffer("MFWNodeProperty: ");
        outStr.append(this.getName());
        outStr.append("\n\tAncestry: ");
        boolean bMultiple = false;
        for (MFWNodeObject parent = this.getParentObject(); parent != null; parent = parent.getParentObject()) {
            if (bMultiple) {
                outStr.append("->");
            } else {
                bMultiple = true;
            }
            outStr.append(parent.getName());
        }
        outStr.append("\n\tValue: ");
        outStr.append(this.getValue());
        outStr.append("\n");
        return outStr.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MFWNodeProperty) {
            MFWNodeProperty thatProp = (MFWNodeProperty)o;
            if (this.getNameRID() != thatProp.getNameRID()) {
                return false;
            }
            return this.mParent.equals(thatProp.mParent) && MFWStringHelper.areEqual(this.getValue(), thatProp.getValue());
        }
        return false;
    }

    @Override
    public void destroy() {
        this.mParent = null;
        super.destroy();
    }

    public static MFWNodeProperty makeDefaultPropertyNode(MFWNodeObject parentObj, MFWInfoObjectImpl.ChildInfo childInfo) {
        MFWInfoPropertyImpl propInfo = (MFWInfoPropertyImpl)childInfo.getInfo();
        if (!childInfo.hasSingleMultiplicity() || propInfo.getDefaultValue().length() == 0) {
            return null;
        }
        if (propInfo.getDataType() == 2) {
            return new MFWNodePropertyInt(parentObj, propInfo, propInfo.getDefaultEnumValue());
        }
        if (propInfo.getDataType() == 4) {
            return new MFWNodePropertyInt(parentObj, propInfo, propInfo.getDefaultBooleanValue() ? 1 : 0);
        }
        return new MFWNodePropertyString(parentObj, propInfo, propInfo.getDefaultValue());
    }
}

