/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWInfoPropertyImpl;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;

public class MFWNodePropertyDynamic
extends MFWNodeProperty {
    private MFWInfoPropertyImpl mInfo = null;
    private MFWRequestContextUser mContext = null;
    private MFWConnection mConnection = null;

    public MFWNodePropertyDynamic(MFWNodeObject objParent, MFWInfoPropertyImpl propInfo, MFWRequestContextUser aContext, MFWConnection aConn) {
        super(objParent);
        this.mInfo = propInfo;
        MFWException.ASSERT(this.mInfo.isDynamic(), "Expecting a dynamic property");
        this.mContext = aContext;
        this.mConnection = aConn;
    }

    @Override
    public MFWInfoProperty getPropertyInfo() {
        return this.mInfo;
    }

    @Override
    public boolean getBooleanValue() {
        MFWException.ASSERT(this.mInfo.getDataType() == 4, "getBooleanValue is supported only for boolean properties");
        String dynValue = this.mConnection.evaluateDynamicProperty(this.mContext, this.mInfo.getRID(), this.getParentObject());
        if (dynValue == null) {
            return this.mInfo.getDefaultBooleanValue();
        }
        return "true".equals(dynValue);
    }

    @Override
    public int getEnumValue() {
        MFWException.ASSERT(this.mInfo.getDataType() == 2, "getEnumValue is supported only for enumerated properties");
        String dynValue = this.mConnection.evaluateDynamicProperty(this.mContext, this.mInfo.getRID(), this.getParentObject());
        if (dynValue == null) {
            return this.mInfo.getDefaultEnumValue();
        }
        return this.mInfo.getEnumCode(dynValue);
    }

    @Override
    public String getValue() {
        String dynValue = this.mConnection.evaluateDynamicProperty(this.mContext, this.mInfo.getRID(), this.getParentObject());
        if (dynValue == null) {
            return this.mInfo.getDefaultValue();
        }
        return dynValue;
    }

    @Override
    public void setBooleanValue(boolean value) {
        MFWException.ASSERT(false, "Value of dynamic property nodes cannot be set");
    }

    @Override
    public void setEnumValue(int value) {
        MFWException.ASSERT(false, "Value of dynamic property nodes cannot be set");
    }

    @Override
    public void setValue(String value) {
        MFWException.ASSERT(false, "Value of dynamic property nodes cannot be set");
    }

    @Override
    public void destroy() {
        this.mInfo = null;
        this.mConnection = null;
        this.mContext = null;
        super.destroy();
    }
}

